// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.ConstraintSummary
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisioningParametersResponse
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactOutput
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactParameter
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactPreferences
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.TagOptionSummary
import aws.sdk.kotlin.services.servicecatalog.model.UsageInstruction
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeProvisioningParametersOperationDeserializer: HttpDeserializer.NonStreaming<DescribeProvisioningParametersResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeProvisioningParametersResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeProvisioningParametersError(context, call, payload)
        }
        val builder = DescribeProvisioningParametersResponse.Builder()

        if (payload != null) {
            deserializeDescribeProvisioningParametersOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeProvisioningParametersError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProvisioningParametersOperationBody(builder: DescribeProvisioningParametersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONSTRAINTSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ConstraintSummaries"))
    val PROVISIONINGARTIFACTOUTPUTKEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisioningArtifactOutputKeys"))
    val PROVISIONINGARTIFACTOUTPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisioningArtifactOutputs"))
    val PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisioningArtifactParameters"))
    val PROVISIONINGARTIFACTPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProvisioningArtifactPreferences"))
    val TAGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TagOptions"))
    val USAGEINSTRUCTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UsageInstructions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONSTRAINTSUMMARIES_DESCRIPTOR)
        field(PROVISIONINGARTIFACTOUTPUTKEYS_DESCRIPTOR)
        field(PROVISIONINGARTIFACTOUTPUTS_DESCRIPTOR)
        field(PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR)
        field(PROVISIONINGARTIFACTPREFERENCES_DESCRIPTOR)
        field(TAGOPTIONS_DESCRIPTOR)
        field(USAGEINSTRUCTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONSTRAINTSUMMARIES_DESCRIPTOR.index -> builder.constraintSummaries =
                    deserializer.deserializeList(CONSTRAINTSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ConstraintSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConstraintSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROVISIONINGARTIFACTOUTPUTKEYS_DESCRIPTOR.index -> builder.provisioningArtifactOutputKeys =
                    deserializer.deserializeList(PROVISIONINGARTIFACTOUTPUTKEYS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProvisioningArtifactOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProvisioningArtifactOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROVISIONINGARTIFACTOUTPUTS_DESCRIPTOR.index -> builder.provisioningArtifactOutputs =
                    deserializer.deserializeList(PROVISIONINGARTIFACTOUTPUTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProvisioningArtifactOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProvisioningArtifactOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR.index -> builder.provisioningArtifactParameters =
                    deserializer.deserializeList(PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProvisioningArtifactParameter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProvisioningArtifactParameterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROVISIONINGARTIFACTPREFERENCES_DESCRIPTOR.index -> builder.provisioningArtifactPreferences = deserializeProvisioningArtifactPreferencesDocument(deserializer)
                TAGOPTIONS_DESCRIPTOR.index -> builder.tagOptions =
                    deserializer.deserializeList(TAGOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<TagOptionSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagOptionSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USAGEINSTRUCTIONS_DESCRIPTOR.index -> builder.usageInstructions =
                    deserializer.deserializeList(USAGEINSTRUCTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<UsageInstruction>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUsageInstructionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
