// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.AccessLevelFilter
import aws.sdk.kotlin.services.servicecatalog.model.ListRecordHistoryRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListRecordHistorySearchFilter
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListRecordHistoryOperationSerializer: HttpSerializer.NonStreaming<ListRecordHistoryRequest> {
    override fun serialize(context: ExecutionContext, input: ListRecordHistoryRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeListRecordHistoryOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeListRecordHistoryOperationBody(context: ExecutionContext, input: ListRecordHistoryRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCEPTLANGUAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AcceptLanguage"))
    val ACCESSLEVELFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AccessLevelFilter"))
    val PAGESIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("PageSize"))
    val PAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PageToken"))
    val SEARCHFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SearchFilter"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCEPTLANGUAGE_DESCRIPTOR)
        field(ACCESSLEVELFILTER_DESCRIPTOR)
        field(PAGESIZE_DESCRIPTOR)
        field(PAGETOKEN_DESCRIPTOR)
        field(SEARCHFILTER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.acceptLanguage?.let { field(ACCEPTLANGUAGE_DESCRIPTOR, it) }
        input.accessLevelFilter?.let { field(ACCESSLEVELFILTER_DESCRIPTOR, it, ::serializeAccessLevelFilterDocument) }
        input.pageSize?.let { field(PAGESIZE_DESCRIPTOR, it) }
        input.pageToken?.let { field(PAGETOKEN_DESCRIPTOR, it) }
        input.searchFilter?.let { field(SEARCHFILTER_DESCRIPTOR, it, ::serializeListRecordHistorySearchFilterDocument) }
    }
    return serializer.toByteArray()
}
