// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.ProvisionProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningParameter
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningPreferences
import aws.sdk.kotlin.services.servicecatalog.model.Tag
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ProvisionProductOperationSerializer: HttpSerializer.NonStreaming<ProvisionProductRequest> {
    override fun serialize(context: ExecutionContext, input: ProvisionProductRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeProvisionProductOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeProvisionProductOperationBody(context: ExecutionContext, input: ProvisionProductRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCEPTLANGUAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AcceptLanguage"))
    val NOTIFICATIONARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("NotificationArns"))
    val PATHID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PathId"))
    val PATHNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PathName"))
    val PRODUCTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProductId"))
    val PRODUCTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProductName"))
    val PROVISIONTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisionToken"))
    val PROVISIONEDPRODUCTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisionedProductName"))
    val PROVISIONINGARTIFACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisioningArtifactId"))
    val PROVISIONINGARTIFACTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisioningArtifactName"))
    val PROVISIONINGPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisioningParameters"))
    val PROVISIONINGPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProvisioningPreferences"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCEPTLANGUAGE_DESCRIPTOR)
        field(NOTIFICATIONARNS_DESCRIPTOR)
        field(PATHID_DESCRIPTOR)
        field(PATHNAME_DESCRIPTOR)
        field(PRODUCTID_DESCRIPTOR)
        field(PRODUCTNAME_DESCRIPTOR)
        field(PROVISIONTOKEN_DESCRIPTOR)
        field(PROVISIONEDPRODUCTNAME_DESCRIPTOR)
        field(PROVISIONINGARTIFACTID_DESCRIPTOR)
        field(PROVISIONINGARTIFACTNAME_DESCRIPTOR)
        field(PROVISIONINGPARAMETERS_DESCRIPTOR)
        field(PROVISIONINGPREFERENCES_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.acceptLanguage?.let { field(ACCEPTLANGUAGE_DESCRIPTOR, it) }
        if (input.notificationArns != null) {
            listField(NOTIFICATIONARNS_DESCRIPTOR) {
                for (el0 in input.notificationArns) {
                    serializeString(el0)
                }
            }
        }
        input.pathId?.let { field(PATHID_DESCRIPTOR, it) }
        input.pathName?.let { field(PATHNAME_DESCRIPTOR, it) }
        input.productId?.let { field(PRODUCTID_DESCRIPTOR, it) }
        input.productName?.let { field(PRODUCTNAME_DESCRIPTOR, it) }
        input.provisionToken?.let { field(PROVISIONTOKEN_DESCRIPTOR, it) } ?: field(PROVISIONTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.provisionedProductName?.let { field(PROVISIONEDPRODUCTNAME_DESCRIPTOR, it) }
        input.provisioningArtifactId?.let { field(PROVISIONINGARTIFACTID_DESCRIPTOR, it) }
        input.provisioningArtifactName?.let { field(PROVISIONINGARTIFACTNAME_DESCRIPTOR, it) }
        if (input.provisioningParameters != null) {
            listField(PROVISIONINGPARAMETERS_DESCRIPTOR) {
                for (el0 in input.provisioningParameters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeProvisioningParameterDocument))
                }
            }
        }
        input.provisioningPreferences?.let { field(PROVISIONINGPREFERENCES_DESCRIPTOR, it, ::serializeProvisioningPreferencesDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
