// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.ProductViewAggregationValue
import aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary
import aws.sdk.kotlin.services.servicecatalog.model.SearchProductsResponse
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class SearchProductsOperationDeserializer: HttpDeserializer.NonStreaming<SearchProductsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SearchProductsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSearchProductsError(context, call, payload)
        }
        val builder = SearchProductsResponse.Builder()

        if (payload != null) {
            deserializeSearchProductsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSearchProductsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSearchProductsOperationBody(builder: SearchProductsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextPageToken"))
    val PRODUCTVIEWAGGREGATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ProductViewAggregations"))
    val PRODUCTVIEWAGGREGATIONS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val PRODUCTVIEWSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProductViewSummaries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(PRODUCTVIEWAGGREGATIONS_DESCRIPTOR)
        field(PRODUCTVIEWSUMMARIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                PRODUCTVIEWAGGREGATIONS_DESCRIPTOR.index -> builder.productViewAggregations =
                    deserializer.deserializeMap(PRODUCTVIEWAGGREGATIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<ProductViewAggregationValue>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(PRODUCTVIEWAGGREGATIONS_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<ProductViewAggregationValue>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeProductViewAggregationValueDocument(deserializer) } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                PRODUCTVIEWSUMMARIES_DESCRIPTOR.index -> builder.productViewSummaries =
                    deserializer.deserializeList(PRODUCTVIEWSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProductViewSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProductViewSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
