// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.AccessLevelFilter
import aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductViewFilterBy
import aws.sdk.kotlin.services.servicecatalog.model.SearchProvisionedProductsRequest
import aws.sdk.kotlin.services.servicecatalog.model.SortOrder
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SearchProvisionedProductsOperationSerializer: HttpSerializer.NonStreaming<SearchProvisionedProductsRequest> {
    override fun serialize(context: ExecutionContext, input: SearchProvisionedProductsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeSearchProvisionedProductsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeSearchProvisionedProductsOperationBody(context: ExecutionContext, input: SearchProvisionedProductsRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCEPTLANGUAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AcceptLanguage"))
    val ACCESSLEVELFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AccessLevelFilter"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Filters"))
    val FILTERS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val PAGESIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("PageSize"))
    val PAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PageToken"))
    val SORTBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SortBy"))
    val SORTORDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SortOrder"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCEPTLANGUAGE_DESCRIPTOR)
        field(ACCESSLEVELFILTER_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(PAGESIZE_DESCRIPTOR)
        field(PAGETOKEN_DESCRIPTOR)
        field(SORTBY_DESCRIPTOR)
        field(SORTORDER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.acceptLanguage?.let { field(ACCEPTLANGUAGE_DESCRIPTOR, it) }
        input.accessLevelFilter?.let { field(ACCESSLEVELFILTER_DESCRIPTOR, it, ::serializeAccessLevelFilterDocument) }
        if (input.filters != null) {
            mapField(FILTERS_DESCRIPTOR) {
                input.filters.forEach { (key, value) ->
                    listEntry(key.value, FILTERS_C0_DESCRIPTOR) {
                        for (el1 in value) {
                            serializeString(el1)
                        }
                    }
                }
            }
        }
        input.pageSize?.let { field(PAGESIZE_DESCRIPTOR, it) }
        input.pageToken?.let { field(PAGETOKEN_DESCRIPTOR, it) }
        input.sortBy?.let { field(SORTBY_DESCRIPTOR, it) }
        input.sortOrder?.let { field(SORTORDER_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
