// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.PropertyKey
import aws.sdk.kotlin.services.servicecatalog.model.RecordStatus
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class UpdateProvisionedProductPropertiesOperationDeserializer: HttpDeserializer.NonStreaming<UpdateProvisionedProductPropertiesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateProvisionedProductPropertiesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateProvisionedProductPropertiesError(context, call, payload)
        }
        val builder = UpdateProvisionedProductPropertiesResponse.Builder()

        if (payload != null) {
            deserializeUpdateProvisionedProductPropertiesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateProvisionedProductPropertiesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateProvisionedProductPropertiesOperationBody(builder: UpdateProvisionedProductPropertiesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROVISIONEDPRODUCTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisionedProductId"))
    val PROVISIONEDPRODUCTPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ProvisionedProductProperties"))
    val RECORDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RecordId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROVISIONEDPRODUCTID_DESCRIPTOR)
        field(PROVISIONEDPRODUCTPROPERTIES_DESCRIPTOR)
        field(RECORDID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROVISIONEDPRODUCTID_DESCRIPTOR.index -> builder.provisionedProductId = deserializeString()
                PROVISIONEDPRODUCTPROPERTIES_DESCRIPTOR.index -> builder.provisionedProductProperties =
                    deserializer.deserializeMap(PROVISIONEDPRODUCTPROPERTIES_DESCRIPTOR) {
                        val map0 = mutableMapOf<PropertyKey, String>()
                        while (hasNextEntry()) {
                            val k0 = PropertyKey.fromValue(key())
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                RECORDID_DESCRIPTOR.index -> builder.recordId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { RecordStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
