// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.TagOptionDetail
import aws.sdk.kotlin.services.servicecatalog.model.UpdateTagOptionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateTagOptionOperationDeserializer: HttpDeserializer.NonStreaming<UpdateTagOptionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateTagOptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateTagOptionError(context, call, payload)
        }
        val builder = UpdateTagOptionResponse.Builder()

        if (payload != null) {
            deserializeUpdateTagOptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateTagOptionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateResourceException" -> DuplicateResourceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TagOptionNotMigratedException" -> TagOptionNotMigratedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateTagOptionOperationBody(builder: UpdateTagOptionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TAGOPTIONDETAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TagOptionDetail"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TAGOPTIONDETAIL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TAGOPTIONDETAIL_DESCRIPTOR.index -> builder.tagOptionDetail = deserializeTagOptionDetailDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
