// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Input for CreatePlatformEndpoint action.
 */
public class CreatePlatformEndpointRequest private constructor(builder: Builder) {
    /**
     * For a list of attributes, see `SetEndpointAttributes`[](https://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html).
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB.
     */
    public val customUserData: kotlin.String? = builder.customUserData
    /**
     * `PlatformApplicationArn` returned from CreatePlatformApplication is used to create a an endpoint.
     */
    public val platformApplicationArn: kotlin.String? = builder.platformApplicationArn
    /**
     * Unique identifier created by the notification service for an app on a device. The specific name for Token will vary, depending on which notification service is being used. For example, when using APNS as the notification service, you need the device token. Alternatively, when using GCM (Firebase Cloud Messaging) or ADM, the device token equivalent is called the registration ID.
     */
    public val token: kotlin.String? = builder.token

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.CreatePlatformEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePlatformEndpointRequest(")
        append("attributes=$attributes,")
        append("customUserData=$customUserData,")
        append("platformApplicationArn=$platformApplicationArn,")
        append("token=$token")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (customUserData?.hashCode() ?: 0)
        result = 31 * result + (platformApplicationArn?.hashCode() ?: 0)
        result = 31 * result + (token?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePlatformEndpointRequest

        if (attributes != other.attributes) return false
        if (customUserData != other.customUserData) return false
        if (platformApplicationArn != other.platformApplicationArn) return false
        if (token != other.token) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.CreatePlatformEndpointRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For a list of attributes, see `SetEndpointAttributes`[](https://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html).
         */
        public var attributes: Map<String, String>? = null
        /**
         * Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB.
         */
        public var customUserData: kotlin.String? = null
        /**
         * `PlatformApplicationArn` returned from CreatePlatformApplication is used to create a an endpoint.
         */
        public var platformApplicationArn: kotlin.String? = null
        /**
         * Unique identifier created by the notification service for an app on a device. The specific name for Token will vary, depending on which notification service is being used. For example, when using APNS as the notification service, you need the device token. Alternatively, when using GCM (Firebase Cloud Messaging) or ADM, the device token equivalent is called the registration ID.
         */
        public var token: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.CreatePlatformEndpointRequest) : this() {
            this.attributes = x.attributes
            this.customUserData = x.customUserData
            this.platformApplicationArn = x.platformApplicationArn
            this.token = x.token
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.CreatePlatformEndpointRequest = CreatePlatformEndpointRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
