// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Input for Publish action.
 */
public class PublishRequest private constructor(builder: Builder) {
    /**
     * The message you want to send.
     *
     * If you are publishing to a topic and you want to send the same message to all transport protocols, include the text of the message as a String value. If you want to send different messages for each transport protocol, set the value of the `MessageStructure` parameter to `json` and use a JSON object for the `Message` parameter.
     *
     * Constraints:
     * + With the exception of SMS, messages must be UTF-8 encoded strings and at most 256 KB in size (262,144 bytes, not 262,144 characters).
     * + For SMS, each message can contain up to 140 characters. This character limit depends on the encoding schema. For example, an SMS message can contain 160 GSM characters, 140 ASCII characters, or 70 UCS-2 characters.If you publish a message that exceeds this size limit, Amazon SNS sends the message as multiple messages, each fitting within the size limit. Messages aren't truncated mid-word but are cut off at whole-word boundaries.The total size limit for a single SMS `Publish` action is 1,600 characters.
     *
     * JSON-specific constraints:
     * + Keys in the JSON object that correspond to supported transport protocols must have simple JSON string values.
     * + The values will be parsed (unescaped) before they are used in outgoing messages.
     * + Outbound notifications are JSON encoded (meaning that the characters will be reescaped for sending).
     * + Values have a minimum length of 0 (the empty string, "", is allowed).
     * + Values have a maximum length bounded by the overall message size (so, including multiple protocols may limit message sizes).
     * + Non-string values will cause the key to be ignored.
     * + Keys that do not correspond to supported transport protocols are ignored.
     * + Duplicate keys are not allowed.
     * + Failure to parse or validate any key or value in the message will cause the `Publish` call to return an error (no partial delivery).
     */
    public val message: kotlin.String? = builder.message
    /**
     * Message attributes for Publish action.
     */
    public val messageAttributes: Map<String, MessageAttributeValue>? = builder.messageAttributes
    /**
     * This parameter applies only to FIFO (first-in-first-out) topics. The `MessageDeduplicationId` can contain up to 128 alphanumeric characters `(a-z, A-Z, 0-9)` and punctuation `(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)`.
     *
     * Every message must have a unique `MessageDeduplicationId`, which is a token used for deduplication of sent messages. If a message with a particular `MessageDeduplicationId` is sent successfully, any message sent with the same `MessageDeduplicationId` during the 5-minute deduplication interval is treated as a duplicate.
     *
     * If the topic has `ContentBasedDeduplication` set, the system generates a `MessageDeduplicationId` based on the contents of the message. Your `MessageDeduplicationId` overrides the generated one.
     */
    public val messageDeduplicationId: kotlin.String? = builder.messageDeduplicationId
    /**
     * This parameter applies only to FIFO (first-in-first-out) topics. The `MessageGroupId` can contain up to 128 alphanumeric characters `(a-z, A-Z, 0-9)` and punctuation `(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)`.
     *
     * The `MessageGroupId` is a tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). Every message must include a `MessageGroupId`.
     */
    public val messageGroupId: kotlin.String? = builder.messageGroupId
    /**
     * Set `MessageStructure` to `json` if you want to send a different message for each protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a longer message to your email subscribers. If you set `MessageStructure` to `json`, the value of the `Message` parameter must:
     * + be a syntactically valid JSON object; and
     * + contain at least a top-level JSON key of "default" with a value that is a string.
     *
     * You can define other top-level keys that define the message you want to send to a specific transport protocol (e.g., "http").
     *
     * Valid value: `json`
     */
    public val messageStructure: kotlin.String? = builder.messageStructure
    /**
     * The phone number to which you want to deliver an SMS message. Use E.164 format.
     *
     * If you don't specify a value for the `PhoneNumber` parameter, you must specify a value for the `TargetArn` or `TopicArn` parameters.
     */
    public val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * Optional parameter to be used as the "Subject" line when the message is delivered to email endpoints. This field will also be included, if present, in the standard JSON messages delivered to other endpoints.
     *
     * Constraints: Subjects must be UTF-8 text with no line breaks or control characters, and less than 100 characters long.
     */
    public val subject: kotlin.String? = builder.subject
    /**
     * If you don't specify a value for the `TargetArn` parameter, you must specify a value for the `PhoneNumber` or `TopicArn` parameters.
     */
    public val targetArn: kotlin.String? = builder.targetArn
    /**
     * The topic you want to publish to.
     *
     * If you don't specify a value for the `TopicArn` parameter, you must specify a value for the `PhoneNumber` or `TargetArn` parameters.
     */
    public val topicArn: kotlin.String? = builder.topicArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.PublishRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PublishRequest(")
        append("message=$message,")
        append("messageAttributes=$messageAttributes,")
        append("messageDeduplicationId=$messageDeduplicationId,")
        append("messageGroupId=$messageGroupId,")
        append("messageStructure=$messageStructure,")
        append("phoneNumber=*** Sensitive Data Redacted ***,")
        append("subject=$subject,")
        append("targetArn=$targetArn,")
        append("topicArn=$topicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (messageAttributes?.hashCode() ?: 0)
        result = 31 * result + (messageDeduplicationId?.hashCode() ?: 0)
        result = 31 * result + (messageGroupId?.hashCode() ?: 0)
        result = 31 * result + (messageStructure?.hashCode() ?: 0)
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        result = 31 * result + (topicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PublishRequest

        if (message != other.message) return false
        if (messageAttributes != other.messageAttributes) return false
        if (messageDeduplicationId != other.messageDeduplicationId) return false
        if (messageGroupId != other.messageGroupId) return false
        if (messageStructure != other.messageStructure) return false
        if (phoneNumber != other.phoneNumber) return false
        if (subject != other.subject) return false
        if (targetArn != other.targetArn) return false
        if (topicArn != other.topicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.PublishRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The message you want to send.
         *
         * If you are publishing to a topic and you want to send the same message to all transport protocols, include the text of the message as a String value. If you want to send different messages for each transport protocol, set the value of the `MessageStructure` parameter to `json` and use a JSON object for the `Message` parameter.
         *
         * Constraints:
         * + With the exception of SMS, messages must be UTF-8 encoded strings and at most 256 KB in size (262,144 bytes, not 262,144 characters).
         * + For SMS, each message can contain up to 140 characters. This character limit depends on the encoding schema. For example, an SMS message can contain 160 GSM characters, 140 ASCII characters, or 70 UCS-2 characters.If you publish a message that exceeds this size limit, Amazon SNS sends the message as multiple messages, each fitting within the size limit. Messages aren't truncated mid-word but are cut off at whole-word boundaries.The total size limit for a single SMS `Publish` action is 1,600 characters.
         *
         * JSON-specific constraints:
         * + Keys in the JSON object that correspond to supported transport protocols must have simple JSON string values.
         * + The values will be parsed (unescaped) before they are used in outgoing messages.
         * + Outbound notifications are JSON encoded (meaning that the characters will be reescaped for sending).
         * + Values have a minimum length of 0 (the empty string, "", is allowed).
         * + Values have a maximum length bounded by the overall message size (so, including multiple protocols may limit message sizes).
         * + Non-string values will cause the key to be ignored.
         * + Keys that do not correspond to supported transport protocols are ignored.
         * + Duplicate keys are not allowed.
         * + Failure to parse or validate any key or value in the message will cause the `Publish` call to return an error (no partial delivery).
         */
        public var message: kotlin.String? = null
        /**
         * Message attributes for Publish action.
         */
        public var messageAttributes: Map<String, MessageAttributeValue>? = null
        /**
         * This parameter applies only to FIFO (first-in-first-out) topics. The `MessageDeduplicationId` can contain up to 128 alphanumeric characters `(a-z, A-Z, 0-9)` and punctuation `(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)`.
         *
         * Every message must have a unique `MessageDeduplicationId`, which is a token used for deduplication of sent messages. If a message with a particular `MessageDeduplicationId` is sent successfully, any message sent with the same `MessageDeduplicationId` during the 5-minute deduplication interval is treated as a duplicate.
         *
         * If the topic has `ContentBasedDeduplication` set, the system generates a `MessageDeduplicationId` based on the contents of the message. Your `MessageDeduplicationId` overrides the generated one.
         */
        public var messageDeduplicationId: kotlin.String? = null
        /**
         * This parameter applies only to FIFO (first-in-first-out) topics. The `MessageGroupId` can contain up to 128 alphanumeric characters `(a-z, A-Z, 0-9)` and punctuation `(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)`.
         *
         * The `MessageGroupId` is a tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). Every message must include a `MessageGroupId`.
         */
        public var messageGroupId: kotlin.String? = null
        /**
         * Set `MessageStructure` to `json` if you want to send a different message for each protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a longer message to your email subscribers. If you set `MessageStructure` to `json`, the value of the `Message` parameter must:
         * + be a syntactically valid JSON object; and
         * + contain at least a top-level JSON key of "default" with a value that is a string.
         *
         * You can define other top-level keys that define the message you want to send to a specific transport protocol (e.g., "http").
         *
         * Valid value: `json`
         */
        public var messageStructure: kotlin.String? = null
        /**
         * The phone number to which you want to deliver an SMS message. Use E.164 format.
         *
         * If you don't specify a value for the `PhoneNumber` parameter, you must specify a value for the `TargetArn` or `TopicArn` parameters.
         */
        public var phoneNumber: kotlin.String? = null
        /**
         * Optional parameter to be used as the "Subject" line when the message is delivered to email endpoints. This field will also be included, if present, in the standard JSON messages delivered to other endpoints.
         *
         * Constraints: Subjects must be UTF-8 text with no line breaks or control characters, and less than 100 characters long.
         */
        public var subject: kotlin.String? = null
        /**
         * If you don't specify a value for the `TargetArn` parameter, you must specify a value for the `PhoneNumber` or `TopicArn` parameters.
         */
        public var targetArn: kotlin.String? = null
        /**
         * The topic you want to publish to.
         *
         * If you don't specify a value for the `TopicArn` parameter, you must specify a value for the `PhoneNumber` or `TargetArn` parameters.
         */
        public var topicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.PublishRequest) : this() {
            this.message = x.message
            this.messageAttributes = x.messageAttributes
            this.messageDeduplicationId = x.messageDeduplicationId
            this.messageGroupId = x.messageGroupId
            this.messageStructure = x.messageStructure
            this.phoneNumber = x.phoneNumber
            this.subject = x.subject
            this.targetArn = x.targetArn
            this.topicArn = x.topicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.PublishRequest = PublishRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
