// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Input for SetTopicAttributes action.
 */
public class SetTopicAttributesRequest private constructor(builder: Builder) {
    /**
     * A map of attributes with their corresponding values.
     *
     * The following lists the names, descriptions, and values of the special request parameters that the `SetTopicAttributes` action uses:
     * + `ApplicationSuccessFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to a platform application endpoint.
     * + `DeliveryPolicy` – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.
     * + `DisplayName` – The display name to use for a topic with SMS subscriptions.
     * + `Policy` – The policy that defines who can access your topic. By default, only the topic owner can publish or subscribe to the topic.
     * + `TracingConfig` – Tracing mode of an Amazon SNS topic. By default `TracingConfig` is set to `PassThrough`, and the topic passes through the tracing header it receives from an Amazon SNS publisher to its subscriptions. If set to `Active`, Amazon SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true. This is only supported on standard topics.
     * + HTTP
     *    + `HTTPSuccessFeedbackRoleArn` – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
     *    + `HTTPSuccessFeedbackSampleRate` – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an HTTP endpoint.
     *    + `HTTPFailureFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
     * + Amazon Kinesis Data Firehose
     *    + `FirehoseSuccessFeedbackRoleArn` – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.
     *    + `FirehoseSuccessFeedbackSampleRate` – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.
     *    + `FirehoseFailureFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.
     * + Lambda
     *    + `LambdaSuccessFeedbackRoleArn` – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Lambda endpoint.
     *    + `LambdaSuccessFeedbackSampleRate` – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Lambda endpoint.
     *    + `LambdaFailureFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Lambda endpoint.
     * + Platform application endpoint
     *    + `ApplicationSuccessFeedbackRoleArn` – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon Web Services application endpoint.
     *    + `ApplicationSuccessFeedbackSampleRate` – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Amazon Web Services application endpoint.
     *    + `ApplicationFailureFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Web Services application endpoint.
     * In addition to being able to configure topic attributes for message delivery status of notification messages sent to Amazon SNS application endpoints, you can also configure application attributes for the delivery status of push notification messages sent to push notification services.For example, For more information, see [Using Amazon SNS Application Attributes for Message Delivery Status](https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html).
     * + Amazon SQS
     *    + `SQSSuccessFeedbackRoleArn` – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
     *    + `SQSSuccessFeedbackSampleRate` – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
     *    + `SQSFailureFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
     *
     * The <endpoint>SuccessFeedbackRoleArn and <endpoint>FailureFeedbackRoleArn attributes are used to give Amazon SNS write access to use CloudWatch Logs on your behalf. The <endpoint>SuccessFeedbackSampleRate attribute is for specifying the sample rate percentage (0-100) of successfully delivered messages. After you configure the <endpoint>FailureFeedbackRoleArn attribute, then all failed message deliveries generate CloudWatch Logs.
     *
     * The following attribute applies only to [server-side-encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html):
     * + `KmsMasterKeyId` – The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms). For more examples, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the *Key Management Service API Reference*.
     * + `SignatureVersion` – The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. By default, `SignatureVersion` is set to `1`.
     *
     * The following attribute applies only to [FIFO topics](https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html):
     * + `ContentBasedDeduplication` – Enables content-based deduplication for FIFO topics.
     *    + By default, `ContentBasedDeduplication` is set to `false`. If you create a FIFO topic and this attribute is `false`, you must specify a value for the `MessageDeduplicationId` parameter for the [Publish](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html) action.
     *    + When you set `ContentBasedDeduplication` to `true`, Amazon SNS uses a SHA-256 hash to generate the `MessageDeduplicationId` using the body of the message (but not the attributes of the message).(Optional) To override the generated value, you can specify a value for the `MessageDeduplicationId` parameter for the `Publish` action.
     */
    public val attributeName: kotlin.String? = builder.attributeName
    /**
     * The new value for the attribute.
     */
    public val attributeValue: kotlin.String? = builder.attributeValue
    /**
     * The ARN of the topic to modify.
     */
    public val topicArn: kotlin.String? = builder.topicArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.SetTopicAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetTopicAttributesRequest(")
        append("attributeName=$attributeName,")
        append("attributeValue=$attributeValue,")
        append("topicArn=$topicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (attributeValue?.hashCode() ?: 0)
        result = 31 * result + (topicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetTopicAttributesRequest

        if (attributeName != other.attributeName) return false
        if (attributeValue != other.attributeValue) return false
        if (topicArn != other.topicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.SetTopicAttributesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A map of attributes with their corresponding values.
         *
         * The following lists the names, descriptions, and values of the special request parameters that the `SetTopicAttributes` action uses:
         * + `ApplicationSuccessFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to a platform application endpoint.
         * + `DeliveryPolicy` – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.
         * + `DisplayName` – The display name to use for a topic with SMS subscriptions.
         * + `Policy` – The policy that defines who can access your topic. By default, only the topic owner can publish or subscribe to the topic.
         * + `TracingConfig` – Tracing mode of an Amazon SNS topic. By default `TracingConfig` is set to `PassThrough`, and the topic passes through the tracing header it receives from an Amazon SNS publisher to its subscriptions. If set to `Active`, Amazon SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true. This is only supported on standard topics.
         * + HTTP
         *    + `HTTPSuccessFeedbackRoleArn` – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
         *    + `HTTPSuccessFeedbackSampleRate` – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an HTTP endpoint.
         *    + `HTTPFailureFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
         * + Amazon Kinesis Data Firehose
         *    + `FirehoseSuccessFeedbackRoleArn` – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.
         *    + `FirehoseSuccessFeedbackSampleRate` – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.
         *    + `FirehoseFailureFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.
         * + Lambda
         *    + `LambdaSuccessFeedbackRoleArn` – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Lambda endpoint.
         *    + `LambdaSuccessFeedbackSampleRate` – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Lambda endpoint.
         *    + `LambdaFailureFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Lambda endpoint.
         * + Platform application endpoint
         *    + `ApplicationSuccessFeedbackRoleArn` – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon Web Services application endpoint.
         *    + `ApplicationSuccessFeedbackSampleRate` – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Amazon Web Services application endpoint.
         *    + `ApplicationFailureFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Web Services application endpoint.
         * In addition to being able to configure topic attributes for message delivery status of notification messages sent to Amazon SNS application endpoints, you can also configure application attributes for the delivery status of push notification messages sent to push notification services.For example, For more information, see [Using Amazon SNS Application Attributes for Message Delivery Status](https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html).
         * + Amazon SQS
         *    + `SQSSuccessFeedbackRoleArn` – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
         *    + `SQSSuccessFeedbackSampleRate` – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
         *    + `SQSFailureFeedbackRoleArn` – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
         *
         * The <endpoint>SuccessFeedbackRoleArn and <endpoint>FailureFeedbackRoleArn attributes are used to give Amazon SNS write access to use CloudWatch Logs on your behalf. The <endpoint>SuccessFeedbackSampleRate attribute is for specifying the sample rate percentage (0-100) of successfully delivered messages. After you configure the <endpoint>FailureFeedbackRoleArn attribute, then all failed message deliveries generate CloudWatch Logs.
         *
         * The following attribute applies only to [server-side-encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html):
         * + `KmsMasterKeyId` – The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms). For more examples, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the *Key Management Service API Reference*.
         * + `SignatureVersion` – The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. By default, `SignatureVersion` is set to `1`.
         *
         * The following attribute applies only to [FIFO topics](https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html):
         * + `ContentBasedDeduplication` – Enables content-based deduplication for FIFO topics.
         *    + By default, `ContentBasedDeduplication` is set to `false`. If you create a FIFO topic and this attribute is `false`, you must specify a value for the `MessageDeduplicationId` parameter for the [Publish](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html) action.
         *    + When you set `ContentBasedDeduplication` to `true`, Amazon SNS uses a SHA-256 hash to generate the `MessageDeduplicationId` using the body of the message (but not the attributes of the message).(Optional) To override the generated value, you can specify a value for the `MessageDeduplicationId` parameter for the `Publish` action.
         */
        public var attributeName: kotlin.String? = null
        /**
         * The new value for the attribute.
         */
        public var attributeValue: kotlin.String? = null
        /**
         * The ARN of the topic to modify.
         */
        public var topicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.SetTopicAttributesRequest) : this() {
            this.attributeName = x.attributeName
            this.attributeValue = x.attributeValue
            this.topicArn = x.topicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.SetTopicAttributesRequest = SetTopicAttributesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
