// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A verified or pending destination phone number in the SMS sandbox.
 *
 * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the *SMS sandbox*. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see [SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the *Amazon SNS Developer Guide*.
 */
public class SmsSandboxPhoneNumber private constructor(builder: Builder) {
    /**
     * The destination phone number.
     */
    public val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * The destination phone number's verification status.
     */
    public val status: aws.sdk.kotlin.services.sns.model.SmsSandboxPhoneNumberVerificationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.SmsSandboxPhoneNumber = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SmsSandboxPhoneNumber(")
        append("phoneNumber=*** Sensitive Data Redacted ***,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = phoneNumber?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SmsSandboxPhoneNumber

        if (phoneNumber != other.phoneNumber) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.SmsSandboxPhoneNumber = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The destination phone number.
         */
        public var phoneNumber: kotlin.String? = null
        /**
         * The destination phone number's verification status.
         */
        public var status: aws.sdk.kotlin.services.sns.model.SmsSandboxPhoneNumberVerificationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.SmsSandboxPhoneNumber) : this() {
            this.phoneNumber = x.phoneNumber
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.SmsSandboxPhoneNumber = SmsSandboxPhoneNumber(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
