// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.paginators

import aws.sdk.kotlin.services.sns.SnsClient
import aws.sdk.kotlin.services.sns.model.Endpoint
import aws.sdk.kotlin.services.sns.model.ListEndpointsByPlatformApplicationRequest
import aws.sdk.kotlin.services.sns.model.ListEndpointsByPlatformApplicationResponse
import aws.sdk.kotlin.services.sns.model.ListOriginationNumbersRequest
import aws.sdk.kotlin.services.sns.model.ListOriginationNumbersResponse
import aws.sdk.kotlin.services.sns.model.ListPhoneNumbersOptedOutRequest
import aws.sdk.kotlin.services.sns.model.ListPhoneNumbersOptedOutResponse
import aws.sdk.kotlin.services.sns.model.ListPlatformApplicationsRequest
import aws.sdk.kotlin.services.sns.model.ListPlatformApplicationsResponse
import aws.sdk.kotlin.services.sns.model.ListSmsSandboxPhoneNumbersRequest
import aws.sdk.kotlin.services.sns.model.ListSmsSandboxPhoneNumbersResponse
import aws.sdk.kotlin.services.sns.model.ListSubscriptionsByTopicRequest
import aws.sdk.kotlin.services.sns.model.ListSubscriptionsByTopicResponse
import aws.sdk.kotlin.services.sns.model.ListSubscriptionsRequest
import aws.sdk.kotlin.services.sns.model.ListSubscriptionsResponse
import aws.sdk.kotlin.services.sns.model.ListTopicsRequest
import aws.sdk.kotlin.services.sns.model.ListTopicsResponse
import aws.sdk.kotlin.services.sns.model.PhoneNumberInformation
import aws.sdk.kotlin.services.sns.model.PlatformApplication
import aws.sdk.kotlin.services.sns.model.SmsSandboxPhoneNumber
import aws.sdk.kotlin.services.sns.model.Subscription
import aws.sdk.kotlin.services.sns.model.Topic
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListEndpointsByPlatformApplicationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEndpointsByPlatformApplicationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEndpointsByPlatformApplicationResponse]
 */
public fun SnsClient.listEndpointsByPlatformApplicationPaginated(initialRequest: ListEndpointsByPlatformApplicationRequest): Flow<ListEndpointsByPlatformApplicationResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEndpointsByPlatformApplicationPaginated.listEndpointsByPlatformApplication(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEndpointsByPlatformApplicationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEndpointsByPlatformApplicationResponse]
 */
public fun SnsClient.listEndpointsByPlatformApplicationPaginated(block: ListEndpointsByPlatformApplicationRequest.Builder.() -> Unit): Flow<ListEndpointsByPlatformApplicationResponse> =
    listEndpointsByPlatformApplicationPaginated(ListEndpointsByPlatformApplicationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEndpointsByPlatformApplicationPaginated]
 * to access the nested member [Endpoint]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Endpoint]
 */
@JvmName("listEndpointsByPlatformApplicationResponseEndpoint")
public fun Flow<ListEndpointsByPlatformApplicationResponse>.endpoints(): Flow<Endpoint> =
    transform() { response ->
        response.endpoints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOriginationNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOriginationNumbersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOriginationNumbersResponse]
 */
public fun SnsClient.listOriginationNumbersPaginated(initialRequest: ListOriginationNumbersRequest = ListOriginationNumbersRequest { }): Flow<ListOriginationNumbersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOriginationNumbersPaginated.listOriginationNumbers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOriginationNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOriginationNumbersResponse]
 */
public fun SnsClient.listOriginationNumbersPaginated(block: ListOriginationNumbersRequest.Builder.() -> Unit): Flow<ListOriginationNumbersResponse> =
    listOriginationNumbersPaginated(ListOriginationNumbersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOriginationNumbersPaginated]
 * to access the nested member [PhoneNumberInformation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PhoneNumberInformation]
 */
@JvmName("listOriginationNumbersResponsePhoneNumberInformation")
public fun Flow<ListOriginationNumbersResponse>.phoneNumbers(): Flow<PhoneNumberInformation> =
    transform() { response ->
        response.phoneNumbers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPhoneNumbersOptedOutResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPhoneNumbersOptedOutRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPhoneNumbersOptedOutResponse]
 */
public fun SnsClient.listPhoneNumbersOptedOutPaginated(initialRequest: ListPhoneNumbersOptedOutRequest = ListPhoneNumbersOptedOutRequest { }): Flow<ListPhoneNumbersOptedOutResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPhoneNumbersOptedOutPaginated.listPhoneNumbersOptedOut(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPhoneNumbersOptedOutResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPhoneNumbersOptedOutResponse]
 */
public fun SnsClient.listPhoneNumbersOptedOutPaginated(block: ListPhoneNumbersOptedOutRequest.Builder.() -> Unit): Flow<ListPhoneNumbersOptedOutResponse> =
    listPhoneNumbersOptedOutPaginated(ListPhoneNumbersOptedOutRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPhoneNumbersOptedOutPaginated]
 * to access the nested member [PhoneNumber]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PhoneNumber]
 */
@JvmName("listPhoneNumbersOptedOutResponsePhoneNumber")
public fun Flow<ListPhoneNumbersOptedOutResponse>.phoneNumbers(): Flow<String> =
    transform() { response ->
        response.phoneNumbers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPlatformApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPlatformApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlatformApplicationsResponse]
 */
public fun SnsClient.listPlatformApplicationsPaginated(initialRequest: ListPlatformApplicationsRequest = ListPlatformApplicationsRequest { }): Flow<ListPlatformApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPlatformApplicationsPaginated.listPlatformApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPlatformApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlatformApplicationsResponse]
 */
public fun SnsClient.listPlatformApplicationsPaginated(block: ListPlatformApplicationsRequest.Builder.() -> Unit): Flow<ListPlatformApplicationsResponse> =
    listPlatformApplicationsPaginated(ListPlatformApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPlatformApplicationsPaginated]
 * to access the nested member [PlatformApplication]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PlatformApplication]
 */
@JvmName("listPlatformApplicationsResponsePlatformApplication")
public fun Flow<ListPlatformApplicationsResponse>.platformApplications(): Flow<PlatformApplication> =
    transform() { response ->
        response.platformApplications?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSmsSandboxPhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSmsSandboxPhoneNumbersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSmsSandboxPhoneNumbersResponse]
 */
public fun SnsClient.listSmsSandboxPhoneNumbersPaginated(initialRequest: ListSmsSandboxPhoneNumbersRequest = ListSmsSandboxPhoneNumbersRequest { }): Flow<ListSmsSandboxPhoneNumbersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSmsSandboxPhoneNumbersPaginated.listSmsSandboxPhoneNumbers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSmsSandboxPhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSmsSandboxPhoneNumbersResponse]
 */
public fun SnsClient.listSmsSandboxPhoneNumbersPaginated(block: ListSmsSandboxPhoneNumbersRequest.Builder.() -> Unit): Flow<ListSmsSandboxPhoneNumbersResponse> =
    listSmsSandboxPhoneNumbersPaginated(ListSmsSandboxPhoneNumbersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSmsSandboxPhoneNumbersPaginated]
 * to access the nested member [SmsSandboxPhoneNumber]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SmsSandboxPhoneNumber]
 */
@JvmName("listSmsSandboxPhoneNumbersResponseSmsSandboxPhoneNumber")
public fun Flow<ListSmsSandboxPhoneNumbersResponse>.phoneNumbers(): Flow<SmsSandboxPhoneNumber> =
    transform() { response ->
        response.phoneNumbers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionsResponse]
 */
public fun SnsClient.listSubscriptionsPaginated(initialRequest: ListSubscriptionsRequest = ListSubscriptionsRequest { }): Flow<ListSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSubscriptionsPaginated.listSubscriptions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionsResponse]
 */
public fun SnsClient.listSubscriptionsPaginated(block: ListSubscriptionsRequest.Builder.() -> Unit): Flow<ListSubscriptionsResponse> =
    listSubscriptionsPaginated(ListSubscriptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSubscriptionsPaginated]
 * to access the nested member [Subscription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Subscription]
 */
@JvmName("listSubscriptionsResponseSubscription")
public fun Flow<ListSubscriptionsResponse>.subscriptions(): Flow<Subscription> =
    transform() { response ->
        response.subscriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSubscriptionsByTopicResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSubscriptionsByTopicRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionsByTopicResponse]
 */
public fun SnsClient.listSubscriptionsByTopicPaginated(initialRequest: ListSubscriptionsByTopicRequest): Flow<ListSubscriptionsByTopicResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSubscriptionsByTopicPaginated.listSubscriptionsByTopic(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSubscriptionsByTopicResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionsByTopicResponse]
 */
public fun SnsClient.listSubscriptionsByTopicPaginated(block: ListSubscriptionsByTopicRequest.Builder.() -> Unit): Flow<ListSubscriptionsByTopicResponse> =
    listSubscriptionsByTopicPaginated(ListSubscriptionsByTopicRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSubscriptionsByTopicPaginated]
 * to access the nested member [Subscription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Subscription]
 */
@JvmName("listSubscriptionsByTopicResponseSubscription")
public fun Flow<ListSubscriptionsByTopicResponse>.subscriptions(): Flow<Subscription> =
    transform() { response ->
        response.subscriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTopicsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTopicsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTopicsResponse]
 */
public fun SnsClient.listTopicsPaginated(initialRequest: ListTopicsRequest = ListTopicsRequest { }): Flow<ListTopicsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTopicsPaginated.listTopics(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTopicsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTopicsResponse]
 */
public fun SnsClient.listTopicsPaginated(block: ListTopicsRequest.Builder.() -> Unit): Flow<ListTopicsResponse> =
    listTopicsPaginated(ListTopicsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTopicsPaginated]
 * to access the nested member [Topic]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Topic]
 */
@JvmName("listTopicsResponseTopic")
public fun Flow<ListTopicsResponse>.topics(): Flow<Topic> =
    transform() { response ->
        response.topics?.forEach {
            emit(it)
        }
    }
