// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.serde

import aws.sdk.kotlin.services.sns.model.PublishResponse
import aws.sdk.kotlin.services.sns.model.SnsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class PublishOperationDeserializer: HttpDeserializer.NonStreaming<PublishResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PublishResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPublishError(context, call, payload)
        }
        val builder = PublishResponse.Builder()

        if (payload != null) {
            deserializePublishOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPublishError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw SnsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KMSInvalidState" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSNotFound" -> KmsNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PlatformApplicationDisabled" -> PlatformApplicationDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSOptInRequired" -> KmsOptInRequiredDeserializer().deserialize(context, wrappedCall, payload)
        "ParameterValueInvalid" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EndpointDisabled" -> EndpointDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSecurity" -> InvalidSecurityExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSAccessDenied" -> KmsAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFound" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameter" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AuthorizationError" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSThrottling" -> KmsThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalError" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSDisabled" -> KmsDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SnsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePublishOperationBody(builder: PublishResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "Publish")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // MessageId com.amazonaws.sns#PublishResponse$MessageId
            "MessageId" -> builder.messageId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sns#messageId`)" }
            // SequenceNumber com.amazonaws.sns#PublishResponse$SequenceNumber
            "SequenceNumber" -> builder.sequenceNumber = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sns#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
