// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreaminfluxdb.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateDbInstanceRequest private constructor(builder: Builder) {
    /**
     * The amount of storage to allocate for your DB storage type (in gibibytes).
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The Timestream for InfluxDB DB instance type to run InfluxDB on.
     */
    public val dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = builder.dbInstanceType
    /**
     * The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the database is configured. For example, DB parameter groups can specify the limit for query concurrency.
     */
    public val dbParameterGroupIdentifier: kotlin.String? = builder.dbParameterGroupIdentifier
    /**
     * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     */
    public val dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = builder.dbStorageType
    /**
     * Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high availability.
     */
    public val deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DeploymentType? = builder.deploymentType
    /**
     * The id of the DB instance.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
     */
    public val logDeliveryConfiguration: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration? = builder.logDeliveryConfiguration
    /**
     * The port number on which InfluxDB accepts connections.
     *
     * If you change the Port value, your database restarts immediately.
     *
     * Valid Values: 1024-65535
     *
     * Default: 8086
     *
     * Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
     */
    public val port: kotlin.Int? = builder.port

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreaminfluxdb.model.UpdateDbInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDbInstanceRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("dbInstanceType=$dbInstanceType,")
        append("dbParameterGroupIdentifier=$dbParameterGroupIdentifier,")
        append("dbStorageType=$dbStorageType,")
        append("deploymentType=$deploymentType,")
        append("identifier=$identifier,")
        append("logDeliveryConfiguration=$logDeliveryConfiguration,")
        append("port=$port")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (dbInstanceType?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbStorageType?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDbInstanceRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (dbInstanceType != other.dbInstanceType) return false
        if (dbParameterGroupIdentifier != other.dbParameterGroupIdentifier) return false
        if (dbStorageType != other.dbStorageType) return false
        if (deploymentType != other.deploymentType) return false
        if (identifier != other.identifier) return false
        if (logDeliveryConfiguration != other.logDeliveryConfiguration) return false
        if (port != other.port) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreaminfluxdb.model.UpdateDbInstanceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of storage to allocate for your DB storage type (in gibibytes).
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * The Timestream for InfluxDB DB instance type to run InfluxDB on.
         */
        public var dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = null
        /**
         * The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the database is configured. For example, DB parameter groups can specify the limit for query concurrency.
         */
        public var dbParameterGroupIdentifier: kotlin.String? = null
        /**
         * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         */
        public var dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = null
        /**
         * Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high availability.
         */
        public var deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DeploymentType? = null
        /**
         * The id of the DB instance.
         */
        public var identifier: kotlin.String? = null
        /**
         * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         */
        public var logDeliveryConfiguration: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration? = null
        /**
         * The port number on which InfluxDB accepts connections.
         *
         * If you change the Port value, your database restarts immediately.
         *
         * Valid Values: 1024-65535
         *
         * Default: 8086
         *
         * Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
         */
        public var port: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreaminfluxdb.model.UpdateDbInstanceRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.dbInstanceType = x.dbInstanceType
            this.dbParameterGroupIdentifier = x.dbParameterGroupIdentifier
            this.dbStorageType = x.dbStorageType
            this.deploymentType = x.deploymentType
            this.identifier = x.identifier
            this.logDeliveryConfiguration = x.logDeliveryConfiguration
            this.port = x.port
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreaminfluxdb.model.UpdateDbInstanceRequest = UpdateDbInstanceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration] inside the given [block]
         */
        public fun logDeliveryConfiguration(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration.Builder.() -> kotlin.Unit) {
            this.logDeliveryConfiguration = aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
