/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.awsprotocol.eventstream;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.Header;
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.MessageBuilder;
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.Prelude;
import aws.smithy.kotlin.runtime.hashing.Crc32;
import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.io.HashingSink;
import aws.smithy.kotlin.runtime.io.HashingSource;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.io.SdkIoKt;
import aws.smithy.kotlin.runtime.io.SdkSink;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.SdkSourceKt;
import aws.smithy.kotlin.runtime.text.encoding.HexKt;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/Message;", "", "headers", "", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/Header;", "payload", "", "(Ljava/util/List;[B)V", "getHeaders", "()Ljava/util/List;", "getPayload", "()[B", "component1", "component2", "copy", "encode", "", "dest", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "aws-event-stream"})
@SourceDebugExtension(value={"SMAP\nMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Message.kt\naws/smithy/kotlin/runtime/awsprotocol/eventstream/Message\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1855#2,2:160\n1#3:162\n*S KotlinDebug\n*F\n+ 1 Message.kt\naws/smithy/kotlin/runtime/awsprotocol/eventstream/Message\n*L\n115#1:160,2\n*E\n"})
public final class Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Header> headers;
    @NotNull
    private final byte[] payload;

    public Message(@NotNull List<Header> headers, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.headers = headers;
        this.payload = payload;
    }

    @NotNull
    public final List<Header> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final byte[] getPayload() {
        return this.payload;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Message cfr_ignored_0 = (Message)other;
        if (!Intrinsics.areEqual(this.headers, ((Message)other).headers)) {
            return false;
        }
        return Arrays.equals(this.payload, ((Message)other).payload);
    }

    public int hashCode() {
        int result = ((Object)this.headers).hashCode();
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }

    public final void encode(@NotNull SdkBufferedSink dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        SdkBuffer headerBuf = new SdkBuffer();
        Iterable $this$forEach$iv = this.headers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Header it = (Header)element$iv;
            boolean bl = false;
            it.encode((SdkBufferedSink)headerBuf);
        }
        long headersLen = headerBuf.getSize();
        int payloadLen = this.payload.length;
        long messageLen = (long)12 + headersLen + (long)payloadLen + (long)4;
        if (!(headersLen < 131072L)) {
            boolean $i$a$-check-Message$encode$42 = false;
            String $i$a$-check-Message$encode$42 = "Invalid Headers length: " + headersLen;
            throw new IllegalStateException($i$a$-check-Message$encode$42.toString());
        }
        if (!(messageLen < 0x1000000L)) {
            boolean $i$a$-check-Message$encode$52 = false;
            String $i$a$-check-Message$encode$52 = "Invalid Message length: " + messageLen;
            throw new IllegalStateException($i$a$-check-Message$encode$52.toString());
        }
        Prelude prelude = new Prelude((int)messageLen, (int)headersLen);
        HashingSink sink = new HashingSink((HashFunction)new Crc32(), (SdkSink)dest);
        SdkBufferedSink buffer = SdkIoKt.buffer((SdkSink)((SdkSink)sink));
        prelude.encode(buffer);
        buffer.write(headerBuf, headerBuf.getSize());
        SdkBufferedSink.DefaultImpls.write$default((SdkBufferedSink)buffer, (byte[])this.payload, (int)0, (int)0, (int)6, null);
        buffer.emit();
        SdkBufferedSink.DefaultImpls.write$default((SdkBufferedSink)dest, (byte[])sink.digest(), (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public final List<Header> component1() {
        return this.headers;
    }

    @NotNull
    public final byte[] component2() {
        return this.payload;
    }

    @NotNull
    public final Message copy(@NotNull List<Header> headers, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        return new Message(headers, payload);
    }

    public static /* synthetic */ Message copy$default(Message message, List list, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            list = message.headers;
        }
        if ((n & 2) != 0) {
            byArray = message.payload;
        }
        return message.copy(list, byArray);
    }

    @NotNull
    public String toString() {
        return "Message(headers=" + this.headers + ", payload=" + Arrays.toString(this.payload) + ')';
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/Message$Companion;", "", "()V", "decode", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/Message;", "source", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "aws-event-stream"})
    @SourceDebugExtension(value={"SMAP\nMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Message.kt\naws/smithy/kotlin/runtime/awsprotocol/eventstream/Message$Companion\n+ 2 Closeable.kt\naws/smithy/kotlin/runtime/io/CloseableKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n29#2,4:160\n43#2,4:164\n33#2,9:168\n1#3:177\n*S KotlinDebug\n*F\n+ 1 Message.kt\naws/smithy/kotlin/runtime/awsprotocol/eventstream/Message$Companion\n*L\n51#1:160,4\n51#1:164,4\n51#1:168,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Message decode(@NotNull SdkBufferedSource source) {
            long headerBytesConsumed;
            long start;
            int it22;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Closeable $this$use$iv = (Closeable)source.peek();
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                SdkBufferedSource it22 = (SdkBufferedSource)$this$use$iv;
                boolean bl = false;
                it22 = UInt.constructor-impl((int)it22.readInt());
            }
            catch (Throwable first$iv2) {
                try {
                    try {
                        closed$iv = true;
                        $this$use$iv.close();
                    }
                    catch (Throwable second$iv) {
                        ExceptionsKt.addSuppressed((Throwable)first$iv2, (Throwable)second$iv);
                    }
                    throw first$iv2;
                }
                catch (Throwable first$iv2) {
                    if (!closed$iv) {
                        $this$use$iv.close();
                    }
                    throw first$iv2;
                }
            }
            $this$use$iv.close();
            int totalLen = it22;
            if (!(Integer.compareUnsigned(totalLen, UInt.constructor-impl((int)0x1000000)) <= 0)) {
                boolean $i$a$-check-Message$Companion$decode$52 = false;
                String $i$a$-check-Message$Companion$decode$52 = "Invalid Message size: " + UInt.toString-impl((int)totalLen);
                throw new IllegalStateException($i$a$-check-Message$Companion$decode$52.toString());
            }
            SdkBuffer messageBuffer = new SdkBuffer();
            Companion $this$decode_u24lambda_u242 = this;
            boolean bl = false;
            HashingSource crcSource = new HashingSource((HashFunction)new Crc32(), (SdkSource)source);
            SdkSourceKt.readFully((SdkSource)((SdkSource)crcSource), (SdkBuffer)messageBuffer, (long)(((long)totalLen & 0xFFFFFFFFL) - 4L));
            byte[] computedCrc = crcSource.digest();
            Prelude prelude = Prelude.Companion.decode((SdkBufferedSource)messageBuffer);
            int remaining = prelude.getTotalLen() - 12 - 4;
            if (!messageBuffer.request((long)remaining)) {
                boolean bl2 = false;
                String string = "Invalid buffer, not enough remaining; have: " + messageBuffer.getSize() + "; expected " + remaining;
                throw new IllegalStateException(string.toString());
            }
            MessageBuilder message = new MessageBuilder();
            for (headerBytesConsumed = 0L; headerBytesConsumed < (long)prelude.getHeadersLength(); headerBytesConsumed += start - messageBuffer.getBuffer().getSize()) {
                start = messageBuffer.getBuffer().getSize();
                Header header = Header.Companion.decode((SdkBufferedSource)messageBuffer);
                message.addHeader(header);
            }
            if (!(headerBytesConsumed == (long)prelude.getHeadersLength())) {
                boolean bl3 = false;
                String string = "Invalid Message: expected " + prelude.getHeadersLength() + " header bytes; consumed " + headerBytesConsumed;
                throw new IllegalStateException(string.toString());
            }
            message.setPayload(messageBuffer.readByteArray((long)prelude.getPayloadLen()));
            byte[] expectedCrc = source.readByteArray(4L);
            if (!Arrays.equals(computedCrc, expectedCrc)) {
                boolean bl4 = false;
                String string = "Message checksum mismatch; expected=0x" + HexKt.encodeToHex((byte[])expectedCrc) + "; calculated=0x" + HexKt.encodeToHex((byte[])computedCrc);
                throw new IllegalStateException(string.toString());
            }
            return message.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

