/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.auth.awssigning;

import aws.smithy.kotlin.runtime.auth.awssigning.AwsSignatureType;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAlgorithm;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig;
import aws.smithy.kotlin.runtime.auth.awssigning.BaseSigV4SignatureCalculatorKt;
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSignerKt;
import aws.smithy.kotlin.runtime.auth.awssigning.HashSpecification;
import aws.smithy.kotlin.runtime.auth.awssigning.SignatureCalculator;
import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.hashing.HashFunctionKt;
import aws.smithy.kotlin.runtime.text.encoding.HexKt;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Laws/smithy/kotlin/runtime/auth/awssigning/BaseSigV4SignatureCalculator;", "Laws/smithy/kotlin/runtime/auth/awssigning/SignatureCalculator;", "algorithm", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningAlgorithm;", "sha256Provider", "Lkotlin/Function0;", "Laws/smithy/kotlin/runtime/hashing/HashFunction;", "Laws/smithy/kotlin/runtime/hashing/HashSupplier;", "<init>", "(Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningAlgorithm;Lkotlin/jvm/functions/Function0;)V", "getAlgorithm", "()Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningAlgorithm;", "getSha256Provider", "()Lkotlin/jvm/functions/Function0;", "supportedAlgorithms", "", "stringToSign", "", "canonicalRequest", "config", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;", "chunkStringToSign", "chunkBody", "", "prevSignature", "chunkTrailerStringToSign", "trailingHeaders", "aws-signing-default"})
public abstract class BaseSigV4SignatureCalculator
implements SignatureCalculator {
    @NotNull
    private final AwsSigningAlgorithm algorithm;
    @NotNull
    private final Function0<HashFunction> sha256Provider;
    @NotNull
    private final Set<AwsSigningAlgorithm> supportedAlgorithms;

    public BaseSigV4SignatureCalculator(@NotNull AwsSigningAlgorithm algorithm, @NotNull Function0<? extends HashFunction> sha256Provider) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(sha256Provider, (String)"sha256Provider");
        this.algorithm = algorithm;
        this.sha256Provider = sha256Provider;
        Object[] objectArray = new AwsSigningAlgorithm[]{AwsSigningAlgorithm.SIGV4, AwsSigningAlgorithm.SIGV4_ASYMMETRIC};
        this.supportedAlgorithms = SetsKt.setOf((Object[])objectArray);
        if (!this.supportedAlgorithms.contains(this.algorithm)) {
            boolean bl = false;
            String string = "This class should only be used for " + CollectionsKt.joinToString$default((Iterable)this.supportedAlgorithms, null, null, null, (int)0, null, null, (int)63, null) + ", got " + this.algorithm;
            throw new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ BaseSigV4SignatureCalculator(AwsSigningAlgorithm awsSigningAlgorithm, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(awsSigningAlgorithm, (Function0<? extends HashFunction>)function0);
    }

    @NotNull
    public final AwsSigningAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public Function0<HashFunction> getSha256Provider() {
        return this.sha256Provider;
    }

    @Override
    @NotNull
    public String stringToSign(@NotNull String canonicalRequest2, @NotNull AwsSigningConfig config) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)canonicalRequest2, (String)"canonicalRequest");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        StringBuilder $this$stringToSign_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$stringToSign_u24lambda_u241.append(this.algorithm.getSigningName()).append('\n');
        $this$stringToSign_u24lambda_u241.append(config.getSigningDate().format(TimestampFormat.ISO_8601_CONDENSED)).append('\n');
        $this$stringToSign_u24lambda_u241.append(DefaultAwsSignerKt.getCredentialScope(config)).append('\n');
        $this$stringToSign_u24lambda_u241.append(HexKt.encodeToHex((byte[])HashFunctionKt.hash((byte[])StringsKt.encodeToByteArray((String)canonicalRequest2), this.getSha256Provider())));
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String chunkStringToSign(@NotNull byte[] chunkBody, @NotNull byte[] prevSignature, @NotNull AwsSigningConfig config) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)chunkBody, (String)"chunkBody");
        Intrinsics.checkNotNullParameter((Object)prevSignature, (String)"prevSignature");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        StringBuilder $this$chunkStringToSign_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$chunkStringToSign_u24lambda_u242.append(this.algorithm.getSigningName() + "-PAYLOAD").append('\n');
        $this$chunkStringToSign_u24lambda_u242.append(config.getSigningDate().format(TimestampFormat.ISO_8601_CONDENSED)).append('\n');
        $this$chunkStringToSign_u24lambda_u242.append(DefaultAwsSignerKt.getCredentialScope(config)).append('\n');
        $this$chunkStringToSign_u24lambda_u242.append(StringsKt.decodeToString((byte[])prevSignature)).append('\n');
        String nonSignatureHeadersHash = WhenMappings.$EnumSwitchMapping$0[config.getSignatureType().ordinal()] == 1 ? BaseSigV4SignatureCalculatorKt.access$eventStreamNonSignatureHeaders(config.getSigningDate()) : HashSpecification.EmptyBody.INSTANCE.getHash();
        $this$chunkStringToSign_u24lambda_u242.append(nonSignatureHeadersHash).append('\n');
        $this$chunkStringToSign_u24lambda_u242.append(HexKt.encodeToHex((byte[])HashFunctionKt.hash((byte[])chunkBody, this.getSha256Provider())));
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String chunkTrailerStringToSign(@NotNull byte[] trailingHeaders, @NotNull byte[] prevSignature, @NotNull AwsSigningConfig config) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)trailingHeaders, (String)"trailingHeaders");
        Intrinsics.checkNotNullParameter((Object)prevSignature, (String)"prevSignature");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        StringBuilder $this$chunkTrailerStringToSign_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$chunkTrailerStringToSign_u24lambda_u243.append(this.algorithm.getSigningName() + "-TRAILER").append('\n');
        $this$chunkTrailerStringToSign_u24lambda_u243.append(config.getSigningDate().format(TimestampFormat.ISO_8601_CONDENSED)).append('\n');
        $this$chunkTrailerStringToSign_u24lambda_u243.append(DefaultAwsSignerKt.getCredentialScope(config)).append('\n');
        $this$chunkTrailerStringToSign_u24lambda_u243.append(StringsKt.decodeToString((byte[])prevSignature)).append('\n');
        $this$chunkTrailerStringToSign_u24lambda_u243.append(HexKt.encodeToHex((byte[])HashFunctionKt.hash((byte[])trailingHeaders, this.getSha256Provider())));
        return stringBuilder.toString();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AwsSignatureType.values().length];
            try {
                nArray[AwsSignatureType.HTTP_REQUEST_EVENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

