/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.auth.awssigning;

import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig;
import aws.smithy.kotlin.runtime.net.url.QueryParameters;
import aws.smithy.kotlin.runtime.net.url.Url;
import aws.smithy.kotlin.runtime.net.url.UrlPath;
import aws.smithy.kotlin.runtime.text.encoding.Encodable;
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\f\u0010\t\u001a\u00020\u0002*\u00020\u0006H\u0000\u001a\u001e\u0010\n\u001a\u00020\u0002*\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000bH\u0002\u001a\f\u0010\u000f\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"skipHeaders", "", "", "STREAM_CHUNK_BYTES", "", "canonicalPath", "Laws/smithy/kotlin/runtime/net/url/Url$Builder;", "config", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;", "canonicalQueryParams", "canonicalLine", "Lkotlin/Pair;", "", "multipleSpaces", "Lkotlin/text/Regex;", "trimAll", "includeHeader", "", "name", "aws-signing-default"})
@SourceDebugExtension(value={"SMAP\nCanonicalizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Canonicalizer.kt\naws/smithy/kotlin/runtime/auth/awssigning/CanonicalizerKt\n+ 2 UrlPath.kt\naws/smithy/kotlin/runtime/net/url/UrlPath$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 QueryParameters.kt\naws/smithy/kotlin/runtime/net/url/QueryParameters$Companion\n*L\n1#1,267:1\n31#2:268\n1628#3,3:269\n1187#3,2:273\n1261#3,2:275\n1557#3:277\n1628#3,3:278\n1264#3:281\n1261#3,4:282\n39#4:272\n*S KotlinDebug\n*F\n+ 1 Canonicalizer.kt\naws/smithy/kotlin/runtime/auth/awssigning/CanonicalizerKt\n*L\n231#1:268\n232#1:269,3\n245#1:273,2\n245#1:275,2\n247#1:277\n247#1:278,3\n245#1:281\n252#1:282,4\n242#1:272\n*E\n"})
public final class CanonicalizerKt {
    @NotNull
    private static final Set<String> skipHeaders;
    private static final int STREAM_CHUNK_BYTES = 16384;
    @NotNull
    private static final Regex multipleSpaces;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String canonicalPath(@NotNull Url.Builder $this$canonicalPath, @NotNull AwsSigningConfig config) {
        void $this$mapTo$iv;
        UrlPath.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$canonicalPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        UrlPath.Builder srcPath = $this$canonicalPath.getPath();
        List srcSegments = srcPath.getSegments();
        Function1 mapper = config.getUseDoubleUriEncode() ? CanonicalizerKt::canonicalPath$lambda$0 : CanonicalizerKt::canonicalPath$lambda$1;
        UrlPath.Companion this_$iv = UrlPath.Companion;
        boolean $i$f$invoke = false;
        UrlPath.Builder $this$canonicalPath_u24lambda_u242 = builder = new UrlPath.Builder();
        boolean bl = false;
        Iterable iterable = srcSegments;
        Collection destination$iv = $this$canonicalPath_u24lambda_u242.getSegments();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            destination$iv.add(mapper.invoke(item$iv));
        }
        $this$canonicalPath_u24lambda_u242.setTrailingSlash(srcPath.getTrailingSlash());
        if (config.getNormalizeUriPath()) {
            $this$canonicalPath_u24lambda_u242.normalize();
        }
        return builder.build().toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String canonicalQueryParams(@NotNull Url.Builder $this$canonicalQueryParams) {
        void $this$associateTo$iv;
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv;
        QueryParameters.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$canonicalQueryParams, (String)"<this>");
        QueryParameters.Companion this_$iv = QueryParameters.Companion;
        boolean $i$f$invoke = false;
        QueryParameters.Builder $this$canonicalQueryParams_u24lambda_u248 = builder = new QueryParameters.Builder();
        boolean bl = false;
        Iterable iterable = $this$canonicalQueryParams.getParameters().entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var9_10 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Encodable key = (Encodable)entry.getKey();
            List values = (List)entry.getValue();
            Encodable reencodedKey = key.reencode(PercentEncoding.Companion.getSigV4());
            Iterable $this$map$iv = values;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Encodable encodable = (Encodable)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it.reencode(PercentEncoding.Companion.getSigV4()));
            }
            List reencodedValues = (List)destination$iv$iv2;
            entry = TuplesKt.to((Object)reencodedKey, (Object)reencodedValues);
            map.put(entry.getFirst(), entry.getSecond());
        }
        $this$associate$iv = CollectionsKt.sortedWith((Iterable)destination$iv$iv.entrySet(), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((Encodable)it.getKey()).getEncoded());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((Encodable)it.getKey()).getEncoded())));
            }
        });
        boolean $i$f$associateTo2 = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map map = (Map)$this$canonicalQueryParams_u24lambda_u248;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl4 = false;
            Encodable key = (Encodable)entry.getKey();
            List values = (List)entry.getValue();
            entry = TuplesKt.to((Object)key, (Object)CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)values, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Encodable it = (Encodable)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getEncoded());
                    it = (Encodable)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getEncoded())));
                }
            })));
            map.put(entry.getFirst(), entry.getSecond());
        }
        Map cfr_ignored_0 = (Map)$this$canonicalQueryParams_u24lambda_u248;
        return StringsKt.removePrefix((String)builder.build().toString(), (CharSequence)"?");
    }

    private static final String canonicalLine(Pair<String, ? extends List<String>> $this$canonicalLine) {
        String valuesString = CollectionsKt.joinToString$default((Iterable)((Iterable)$this$canonicalLine.getSecond()), (CharSequence)",", null, null, (int)0, null, CanonicalizerKt::canonicalLine$lambda$9, (int)30, null);
        return (String)$this$canonicalLine.getFirst() + ':' + valuesString;
    }

    private static final String trimAll(String $this$trimAll) {
        CharSequence charSequence = $this$trimAll;
        Regex regex = multipleSpaces;
        String string = " ";
        return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString();
    }

    private static final boolean includeHeader(String name, AwsSigningConfig config) {
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return !skipHeaders.contains(string) && (Boolean)config.getShouldSignHeader().invoke((Object)name) != false;
    }

    private static final Encodable canonicalPath$lambda$0(Encodable existing) {
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        return PercentEncoding.Companion.getSigV4().encodableFromDecoded(existing.getEncoded());
    }

    private static final Encodable canonicalPath$lambda$1(Encodable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final CharSequence canonicalLine$lambda$9(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CanonicalizerKt.trimAll(it);
    }

    public static final /* synthetic */ boolean access$includeHeader(String name, AwsSigningConfig config) {
        return CanonicalizerKt.includeHeader(name, config);
    }

    public static final /* synthetic */ String access$canonicalLine(Pair $receiver) {
        return CanonicalizerKt.canonicalLine((Pair<String, ? extends List<String>>)$receiver);
    }

    static {
        Object[] objectArray = new String[]{"expect", "sec-websocket-key", "sec-websocket-protocol", "sec-websocket-version", "user-agent", "x-amzn-trace-id", "connection", "keep-alive", "proxy-authenticate", "proxy-authorization", "te", "trailers", "transfer-encoding", "upgrade"};
        skipHeaders = SetsKt.setOf((Object[])objectArray);
        multipleSpaces = new Regex(" +");
    }
}

