/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.auth.awssigning;

import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAlgorithm;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig;
import aws.smithy.kotlin.runtime.auth.awssigning.BaseSigV4SignatureCalculator;
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSignerBuilder;
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSignerImpl;
import aws.smithy.kotlin.runtime.auth.awssigning.SignatureCalculator;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001f\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u001a\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0010H\u0000\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"DefaultAwsSigner", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigner;", "getDefaultAwsSigner", "()Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigner;", "block", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/auth/awssigning/DefaultAwsSignerBuilder;", "", "Lkotlin/ExtensionFunctionType;", "signatureCalculator", "Laws/smithy/kotlin/runtime/auth/awssigning/BaseSigV4SignatureCalculator;", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningAlgorithm;", "getSignatureCalculator", "(Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningAlgorithm;)Laws/smithy/kotlin/runtime/auth/awssigning/BaseSigV4SignatureCalculator;", "credentialScope", "", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;", "getCredentialScope", "(Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;)Ljava/lang/String;", "credentialValue", "config", "aws-signing-default"})
public final class DefaultAwsSignerKt {
    @NotNull
    private static final AwsSigner DefaultAwsSigner = new DefaultAwsSignerImpl(null, null, null, 7, null);

    @NotNull
    public static final AwsSigner getDefaultAwsSigner() {
        return DefaultAwsSigner;
    }

    @NotNull
    public static final AwsSigner DefaultAwsSigner(@NotNull Function1<? super DefaultAwsSignerBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        DefaultAwsSignerBuilder defaultAwsSignerBuilder = new DefaultAwsSignerBuilder();
        block.invoke((Object)defaultAwsSignerBuilder);
        return defaultAwsSignerBuilder.build();
    }

    private static final BaseSigV4SignatureCalculator getSignatureCalculator(AwsSigningAlgorithm $this$signatureCalculator) {
        BaseSigV4SignatureCalculator baseSigV4SignatureCalculator;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$signatureCalculator.ordinal()]) {
            case 1: {
                baseSigV4SignatureCalculator = SignatureCalculator.Companion.getSigV4();
                break;
            }
            case 2: {
                baseSigV4SignatureCalculator = SignatureCalculator.Companion.getSigV4a();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return baseSigV4SignatureCalculator;
    }

    @NotNull
    public static final String getCredentialScope(@NotNull AwsSigningConfig $this$credentialScope) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$credentialScope, (String)"<this>");
        AwsSigningConfig $this$_get_credentialScope__u24lambda_u240 = $this$credentialScope;
        boolean bl = false;
        String signingDate = $this$_get_credentialScope__u24lambda_u240.getSigningDate().format(TimestampFormat.ISO_8601_CONDENSED_DATE);
        switch (WhenMappings.$EnumSwitchMapping$0[$this$_get_credentialScope__u24lambda_u240.getAlgorithm().ordinal()]) {
            case 1: {
                string = signingDate + '/' + $this$_get_credentialScope__u24lambda_u240.getRegion() + '/' + $this$_get_credentialScope__u24lambda_u240.getService() + "/aws4_request";
                break;
            }
            case 2: {
                string = signingDate + '/' + $this$_get_credentialScope__u24lambda_u240.getService() + "/aws4_request";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final String credentialValue(@NotNull AwsSigningConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return config.getCredentials().getAccessKeyId() + '/' + DefaultAwsSignerKt.getCredentialScope(config);
    }

    public static final /* synthetic */ BaseSigV4SignatureCalculator access$getSignatureCalculator(AwsSigningAlgorithm $receiver) {
        return DefaultAwsSignerKt.getSignatureCalculator($receiver);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AwsSigningAlgorithm.values().length];
            try {
                nArray[AwsSigningAlgorithm.SIGV4.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AwsSigningAlgorithm.SIGV4_ASYMMETRIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

