/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.auth.awssigning;

import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAlgorithm;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig;
import aws.smithy.kotlin.runtime.auth.awssigning.BaseSigV4SignatureCalculator;
import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.hashing.HmacKt;
import aws.smithy.kotlin.runtime.text.encoding.HexKt;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001e\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Laws/smithy/kotlin/runtime/auth/awssigning/SigV4SignatureCalculator;", "Laws/smithy/kotlin/runtime/auth/awssigning/BaseSigV4SignatureCalculator;", "sha256Provider", "Lkotlin/Function0;", "Laws/smithy/kotlin/runtime/hashing/HashFunction;", "Laws/smithy/kotlin/runtime/hashing/HashSupplier;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getSha256Provider", "()Lkotlin/jvm/functions/Function0;", "calculate", "", "signingKey", "", "stringToSign", "config", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;", "aws-signing-default"})
public final class SigV4SignatureCalculator
extends BaseSigV4SignatureCalculator {
    @NotNull
    private final Function0<HashFunction> sha256Provider;

    public SigV4SignatureCalculator(@NotNull Function0<? extends HashFunction> sha256Provider) {
        Intrinsics.checkNotNullParameter(sha256Provider, (String)"sha256Provider");
        super(AwsSigningAlgorithm.SIGV4, sha256Provider);
        this.sha256Provider = sha256Provider;
    }

    public /* synthetic */ SigV4SignatureCalculator(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this((Function0<? extends HashFunction>)function0);
    }

    @Override
    @NotNull
    public Function0<HashFunction> getSha256Provider() {
        return this.sha256Provider;
    }

    @Override
    @NotNull
    public String calculate(@NotNull byte[] signingKey2, @NotNull String stringToSign) {
        Intrinsics.checkNotNullParameter((Object)signingKey2, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)stringToSign, (String)"stringToSign");
        return HexKt.encodeToHex((byte[])HmacKt.hmac((byte[])signingKey2, (byte[])StringsKt.encodeToByteArray((String)stringToSign), this.getSha256Provider()));
    }

    @Override
    @NotNull
    public byte[] signingKey(@NotNull AwsSigningConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        byte[] initialKey = StringsKt.encodeToByteArray((String)("AWS4" + config.getCredentials().getSecretAccessKey()));
        byte[] kDate = SigV4SignatureCalculator.signingKey$hmac(this, initialKey, config.getSigningDate().format(TimestampFormat.ISO_8601_CONDENSED_DATE));
        byte[] kRegion = SigV4SignatureCalculator.signingKey$hmac(this, kDate, config.getRegion());
        byte[] kService = SigV4SignatureCalculator.signingKey$hmac(this, kRegion, config.getService());
        return SigV4SignatureCalculator.signingKey$hmac(this, kService, "aws4_request");
    }

    private static final byte[] signingKey$hmac(SigV4SignatureCalculator this$0, byte[] key, String message) {
        return HmacKt.hmac((byte[])key, (byte[])StringsKt.encodeToByteArray((String)message), this$0.getSha256Provider());
    }

    public SigV4SignatureCalculator() {
        this(null, 1, null);
    }
}

