/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.auth.awssigning;

import aws.smithy.kotlin.runtime.auth.awscredentials.Credentials;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAlgorithm;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig;
import aws.smithy.kotlin.runtime.auth.awssigning.BaseSigV4SignatureCalculator;
import aws.smithy.kotlin.runtime.auth.awssigning.SigV4aSignatureCalculatorKt;
import aws.smithy.kotlin.runtime.collections.ReadThroughCache;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.hashing.EcdsaJVMKt;
import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.hashing.HmacKt;
import aws.smithy.kotlin.runtime.text.encoding.HexKt;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.util.ExpiringValue;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001e\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Laws/smithy/kotlin/runtime/auth/awssigning/SigV4aSignatureCalculator;", "Laws/smithy/kotlin/runtime/auth/awssigning/BaseSigV4SignatureCalculator;", "sha256Provider", "Lkotlin/Function0;", "Laws/smithy/kotlin/runtime/hashing/HashFunction;", "Laws/smithy/kotlin/runtime/hashing/HashSupplier;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getSha256Provider", "()Lkotlin/jvm/functions/Function0;", "privateKeyCache", "Laws/smithy/kotlin/runtime/collections/ReadThroughCache;", "Laws/smithy/kotlin/runtime/auth/awscredentials/Credentials;", "", "calculate", "", "signingKey", "stringToSign", "config", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;", "fixedInputString", "accessKeyId", "counter", "", "aws-signing-default"})
public final class SigV4aSignatureCalculator
extends BaseSigV4SignatureCalculator {
    @NotNull
    private final Function0<HashFunction> sha256Provider;
    @NotNull
    private final ReadThroughCache<Credentials, byte[]> privateKeyCache;

    public SigV4aSignatureCalculator(@NotNull Function0<? extends HashFunction> sha256Provider) {
        Intrinsics.checkNotNullParameter(sha256Provider, (String)"sha256Provider");
        super(AwsSigningAlgorithm.SIGV4_ASYMMETRIC, sha256Provider);
        this.sha256Provider = sha256Provider;
        this.privateKeyCache = new ReadThroughCache(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS), null, 2, null);
    }

    public /* synthetic */ SigV4aSignatureCalculator(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this((Function0<? extends HashFunction>)function0);
    }

    @Override
    @NotNull
    public Function0<HashFunction> getSha256Provider() {
        return this.sha256Provider;
    }

    @Override
    @NotNull
    public String calculate(@NotNull byte[] signingKey2, @NotNull String stringToSign) {
        Intrinsics.checkNotNullParameter((Object)signingKey2, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)stringToSign, (String)"stringToSign");
        return HexKt.encodeToHex((byte[])EcdsaJVMKt.ecdsaSecp256r1((byte[])signingKey2, (byte[])StringsKt.encodeToByteArray((String)stringToSign)));
    }

    @Override
    @NotNull
    public byte[] signingKey(@NotNull AwsSigningConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return (byte[])BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(this, config, null){
            int label;
            final /* synthetic */ SigV4aSignatureCalculator this$0;
            final /* synthetic */ AwsSigningConfig $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SigV4aSignatureCalculator.access$getPrivateKeyCache$p(this.this$0).get((Object)this.$config.getCredentials(), (Function2)new Function2<Credentials, Continuation<? super ExpiringValue<byte[]>>, Object>(this.$config, this.this$0, null){
                            int label;
                            final /* synthetic */ AwsSigningConfig $config;
                            final /* synthetic */ SigV4aSignatureCalculator this$0;
                            {
                                this.$config = $config;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        byte[] privateKey;
                                        BigInteger c;
                                        ResultKt.throwOnFailure((Object)object);
                                        int counter = 1;
                                        byte[] inputKey = StringsKt.encodeToByteArray((String)("AWS4A" + this.$config.getCredentials().getSecretAccessKey()));
                                        do {
                                            byte[] k0 = HmacKt.hmac((byte[])inputKey, (byte[])SigV4aSignatureCalculator.access$fixedInputString(this.this$0, this.$config.getCredentials().getAccessKeyId(), (byte)counter), this.this$0.getSha256Provider());
                                            c = SigV4aSignatureCalculatorKt.access$toPositiveBigInteger(k0);
                                            privateKey = c.plus(new BigInteger("1")).toByteArray();
                                            if (counter == -2 && c.compareTo(SigV4aSignatureCalculatorKt.getN_MINUS_TWO()) > 0) {
                                                throw new IllegalStateException("Counter exceeded maximum length");
                                            }
                                            int n = counter;
                                            counter = (byte)(n + 1);
                                        } while (c.compareTo(SigV4aSignatureCalculatorKt.getN_MINUS_TWO()) > 0);
                                        return new ExpiringValue((Object)privateKey, Instant.Companion.getMAX_VALUE());
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Credentials p1, Continuation<? super ExpiringValue<byte[]>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super byte[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final byte[] fixedInputString(String accessKeyId, byte counter) {
        byte[] byArray = new byte[]{0, 0, 0, 1};
        byte[] byArray2 = ArraysKt.plus((byte[])byArray, (byte[])StringsKt.encodeToByteArray((String)AwsSigningAlgorithm.SIGV4_ASYMMETRIC.getSigningName()));
        byArray = new byte[]{0};
        byte[] byArray3 = ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])byArray2, (byte[])byArray), (byte[])StringsKt.encodeToByteArray((String)accessKeyId)), (byte)counter);
        byArray = new byte[]{0, 0, 1, 0};
        return ArraysKt.plus((byte[])byArray3, (byte[])byArray);
    }

    public SigV4aSignatureCalculator() {
        this(null, 1, null);
    }

    public static final /* synthetic */ ReadThroughCache access$getPrivateKeyCache$p(SigV4aSignatureCalculator $this) {
        return $this.privateKeyCache;
    }

    public static final /* synthetic */ byte[] access$fixedInputString(SigV4aSignatureCalculator $this, String accessKeyId, byte counter) {
        return $this.fixedInputString(accessKeyId, counter);
    }
}

