/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.crt;

import aws.sdk.kotlin.crt.CRT;
import aws.sdk.kotlin.crt.CrtRuntimeException;
import aws.sdk.kotlin.crt.http.HeadersBuilder;
import aws.sdk.kotlin.crt.http.HttpRequest;
import aws.sdk.kotlin.crt.http.HttpRequestBodyStream;
import aws.sdk.kotlin.crt.http.HttpStream;
import aws.sdk.kotlin.crt.io.Protocol;
import aws.sdk.kotlin.crt.io.Uri;
import aws.sdk.kotlin.crt.io.UriBuilder;
import aws.sdk.kotlin.crt.io.UserInfo;
import aws.smithy.kotlin.runtime.crt.ReadChannelBodyStream;
import aws.smithy.kotlin.runtime.crt.SdkSourceBodyStream;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpErrorCode;
import aws.smithy.kotlin.runtime.http.HttpException;
import aws.smithy.kotlin.runtime.http.engine.crt.RequestUtilKt;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannel;
import aws.smithy.kotlin.runtime.io.SdkIoKt;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.SdkSourceJVMKt;
import aws.smithy.kotlin.runtime.net.url.Url;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\u001a\u001b\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001c\u0010\n\u001a\u00020\t*\u00020\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0080@\u00a2\u0006\u0004\b\n\u0010\u000b\u001a/\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a'\u0010\u0018\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0017\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u0019\u0010\u001d\u001a\u00020\u001c2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u001d\u0010 \u001a!\u0010\"\u001a\u00020!2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0004\b\"\u0010#\"\u0014\u0010$\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010%\"\u0018\u0010)\u001a\u00020&*\u00020\u00008@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\"\u0018\u0010*\u001a\u00020!*\u00020\u00008@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\"\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.\"\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000e0,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u0010.\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00060"}, d2={"Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "Lkotlin/coroutines/CoroutineContext;", "callContext", "Laws/sdk/kotlin/crt/http/HttpRequest;", "toCrtRequest", "(Laws/smithy/kotlin/runtime/http/request/HttpRequest;Lkotlin/coroutines/CoroutineContext;)Laws/sdk/kotlin/crt/http/HttpRequest;", "Laws/sdk/kotlin/crt/http/HttpStream;", "Laws/smithy/kotlin/runtime/http/HttpBody;", "body", "", "sendChunkedBody", "(Laws/sdk/kotlin/crt/http/HttpStream;Laws/smithy/kotlin/runtime/http/HttpBody;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "errorCode", "", "errorName", "", "cause", "Laws/smithy/kotlin/runtime/http/HttpException;", "crtException", "(ILjava/lang/String;Ljava/lang/Throwable;)Laws/smithy/kotlin/runtime/http/HttpException;", "T", "Lkotlin/Function0;", "block", "mapCrtException", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "fmtCrtErrorMessage", "(I)Ljava/lang/String;", "Laws/smithy/kotlin/runtime/http/HttpErrorCode;", "mapCrtErrorCode", "(Ljava/lang/String;)Laws/smithy/kotlin/runtime/http/HttpErrorCode;", "code", "(I)Laws/smithy/kotlin/runtime/http/HttpErrorCode;", "", "isRetryable", "(ILjava/lang/String;)Z", "CONTENT_LENGTH_HEADER", "Ljava/lang/String;", "Laws/sdk/kotlin/crt/io/Uri;", "getUri", "(Laws/smithy/kotlin/runtime/http/request/HttpRequest;)Laws/sdk/kotlin/crt/io/Uri;", "uri", "isChunked", "(Laws/smithy/kotlin/runtime/http/request/HttpRequest;)Z", "", "tlsNegotiationErrors", "Ljava/util/Set;", "connectionClosedErrors", "http-client-engine-crt"})
@SourceDebugExtension(value={"SMAP\nRequestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestUtil.kt\naws/smithy/kotlin/runtime/http/engine/crt/RequestUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class RequestUtilKt {
    @NotNull
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    @NotNull
    private static final Set<String> tlsNegotiationErrors;
    @NotNull
    private static final Set<String> connectionClosedErrors;

    @NotNull
    public static final Uri getUri(@NotNull aws.smithy.kotlin.runtime.http.request.HttpRequest $this$uri) {
        Intrinsics.checkNotNullParameter((Object)$this$uri, (String)"<this>");
        Url sdkUrl = $this$uri.getUrl();
        return Uri.Companion.build(arg_0 -> RequestUtilKt._get_uri_$lambda$2(sdkUrl, arg_0));
    }

    @NotNull
    public static final HttpRequest toCrtRequest(@NotNull aws.smithy.kotlin.runtime.http.request.HttpRequest $this$toCrtRequest, @NotNull CoroutineContext callContext) {
        HeadersBuilder crtHeaders;
        HttpRequestBodyStream bodyStream;
        block16: {
            Object contentLength;
            Object object;
            block15: {
                block14: {
                    HttpRequestBodyStream httpRequestBodyStream;
                    Intrinsics.checkNotNullParameter((Object)$this$toCrtRequest, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
                    HttpBody body = $this$toCrtRequest.getBody();
                    if (!(!body.isDuplex())) {
                        boolean $i$a$-check-RequestUtilKt$toCrtRequest$22 = false;
                        String $i$a$-check-RequestUtilKt$toCrtRequest$22 = "CrtHttpEngine does not yet support full duplex streams";
                        throw new IllegalStateException($i$a$-check-RequestUtilKt$toCrtRequest$22.toString());
                    }
                    if (RequestUtilKt.isChunked($this$toCrtRequest)) {
                        httpRequestBodyStream = null;
                    } else {
                        HttpBody $i$a$-check-RequestUtilKt$toCrtRequest$22 = body;
                        if ($i$a$-check-RequestUtilKt$toCrtRequest$22 instanceof HttpBody.Empty) {
                            httpRequestBodyStream = null;
                        } else if ($i$a$-check-RequestUtilKt$toCrtRequest$22 instanceof HttpBody.Bytes) {
                            httpRequestBodyStream = HttpRequestBodyStream.Companion.fromByteArray(((HttpBody.Bytes)body).bytes());
                        } else if ($i$a$-check-RequestUtilKt$toCrtRequest$22 instanceof HttpBody.ChannelContent) {
                            httpRequestBodyStream = (HttpRequestBodyStream)new ReadChannelBodyStream(((HttpBody.ChannelContent)body).readFrom(), callContext);
                        } else if ($i$a$-check-RequestUtilKt$toCrtRequest$22 instanceof HttpBody.SourceContent) {
                            SdkSource source = ((HttpBody.SourceContent)body).readFrom();
                            JobKt.getJob((CoroutineContext)callContext).invokeOnCompletion(arg_0 -> RequestUtilKt.toCrtRequest$lambda$4(source, arg_0));
                            httpRequestBodyStream = (HttpRequestBodyStream)new SdkSourceBodyStream(source);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    bodyStream = httpRequestBodyStream;
                    HeadersBuilder $this$toCrtRequest_u24lambda_u246 = crtHeaders = new HeadersBuilder();
                    boolean bl = false;
                    $this$toCrtRequest.getHeaders().forEach((arg_0, arg_1) -> RequestUtilKt.toCrtRequest$lambda$6$lambda$5($this$toCrtRequest_u24lambda_u246, arg_0, arg_1));
                    object = body.getContentLength();
                    if (object == null) break block14;
                    Long l = object;
                    long it = ((Number)l).longValue();
                    boolean bl2 = false;
                    object = it >= 0L ? l : null;
                    if (object != null && (object = ((Long)object).toString()) != null) break block15;
                }
                object = (String)$this$toCrtRequest.getHeaders().get(CONTENT_LENGTH_HEADER);
            }
            Object object2 = contentLength = object;
            if (object2 == null) break block16;
            Object it = object2;
            boolean bl = false;
            crtHeaders.append(CONTENT_LENGTH_HEADER, (String)it);
        }
        return new HttpRequest($this$toCrtRequest.getMethod().name(), $this$toCrtRequest.getUrl().getRequestRelativePath(), crtHeaders.build(), bodyStream);
    }

    public static final boolean isChunked(@NotNull aws.smithy.kotlin.runtime.http.request.HttpRequest $this$isChunked) {
        Intrinsics.checkNotNullParameter((Object)$this$isChunked, (String)"<this>");
        return ($this$isChunked.getBody() instanceof HttpBody.SourceContent || $this$isChunked.getBody() instanceof HttpBody.ChannelContent) && $this$isChunked.getHeaders().contains("Transfer-Encoding", (Object)"chunked");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object sendChunkedBody(@NotNull HttpStream var0, @NotNull HttpBody var1_1, @NotNull Continuation<? super Unit> $completion) {
        block14: {
            if (!($completion instanceof sendChunkedBody.1)) ** GOTO lbl-1000
            var13_3 = $completion;
            if ((var13_3.label & -2147483648) != 0) {
                var13_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl($completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    /* synthetic */ Object result;
                    int label;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return RequestUtilKt.sendChunkedBody(null, null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var3_6 = body;
                    if (!(var3_6 instanceof HttpBody.SourceContent)) ** GOTO lbl22
                    source = ((HttpBody.SourceContent)body).readFrom();
                    bufferedSource = SdkIoKt.buffer((SdkSource)source);
                    while (!bufferedSource.exhausted()) {
                        bufferedSource.request(65536L);
                        $this$sendChunkedBody.writeChunk(bufferedSource.getBuffer().readByteArray(), bufferedSource.exhausted());
                    }
                    break block14;
lbl22:
                    // 1 sources

                    if (!(var3_6 instanceof HttpBody.ChannelContent)) break;
                    chan = ((HttpBody.ChannelContent)body).readFrom();
                    buffer = new SdkBuffer();
                    nextBuffer = new SdkBuffer();
                    sentFirstChunk = 0;
lbl27:
                    // 2 sources

                    while (!chan.isClosedForRead()) {
                        $continuation.L$0 = $this$sendChunkedBody;
                        $continuation.L$1 = chan;
                        $continuation.L$2 = buffer;
                        $continuation.L$3 = nextBuffer;
                        $continuation.I$0 = sentFirstChunk;
                        $continuation.label = 1;
                        v0 = chan.read(buffer, 65536L, (Continuation)$continuation);
                        if (v0 == var14_5) {
                            return var14_5;
                        }
                        ** GOTO lbl47
                    }
                    break block14;
                }
                case 1: {
                    sentFirstChunk = $continuation.I$0;
                    nextBuffer = (SdkBuffer)$continuation.L$3;
                    buffer = (SdkBuffer)$continuation.L$2;
                    chan = (SdkByteReadChannel)$continuation.L$1;
                    $this$sendChunkedBody = (HttpStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl47:
                    // 2 sources

                    bytesRead = ((Number)v0).longValue();
                    if (sentFirstChunk == 0 && bytesRead == -1L) {
                        throw new RuntimeException("CRT does not support empty chunked bodies.");
                    }
                    $continuation.L$0 = $this$sendChunkedBody;
                    $continuation.L$1 = chan;
                    $continuation.L$2 = buffer;
                    $continuation.L$3 = nextBuffer;
                    $continuation.label = 2;
                    v1 = chan.read(nextBuffer, 65536L, (Continuation)$continuation);
                    if (v1 == var14_5) {
                        return var14_5;
                    }
                    ** GOTO lbl66
                }
                case 2: {
                    nextBuffer = (SdkBuffer)$continuation.L$3;
                    buffer = (SdkBuffer)$continuation.L$2;
                    chan = (SdkByteReadChannel)$continuation.L$1;
                    $this$sendChunkedBody = (HttpStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl66:
                    // 2 sources

                    isFinalChunk = ((Number)v1).longValue() == -1L ? 1 : 0;
                    var11_15 = $this$sendChunkedBody;
                    $continuation.L$0 = $this$sendChunkedBody;
                    $continuation.L$1 = chan;
                    $continuation.L$2 = nextBuffer;
                    $continuation.L$3 = var11_15;
                    $continuation.I$0 = isFinalChunk;
                    $continuation.label = 3;
                    v2 = SdkSourceJVMKt.readToByteArray((SdkSource)((SdkSource)buffer), (Continuation)$continuation);
                    if (v2 == var14_5) {
                        return var14_5;
                    }
                    ** GOTO lbl86
                }
                case 3: {
                    isFinalChunk = $continuation.I$0;
                    var11_15 = (HttpStream)$continuation.L$3;
                    nextBuffer = (SdkBuffer)$continuation.L$2;
                    chan = (SdkByteReadChannel)$continuation.L$1;
                    $this$sendChunkedBody = (HttpStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl86:
                    // 2 sources

                    var11_15.writeChunk((byte[])v2, isFinalChunk != 0);
                    if (isFinalChunk != 0) break block14;
                    buffer = nextBuffer;
                    sentFirstChunk = 1;
                    ** GOTO lbl27
                }
            }
            throw new IllegalStateException("sendChunkedBody should not be called for non-chunked body types".toString());
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final HttpException crtException(int errorCode, @Nullable String errorName, @Nullable Throwable cause) {
        return new HttpException(RequestUtilKt.fmtCrtErrorMessage(errorCode), cause, RequestUtilKt.mapCrtErrorCode(errorName), RequestUtilKt.isRetryable(errorCode, errorName));
    }

    public static /* synthetic */ HttpException crtException$default(int n, String string, Throwable throwable, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = CRT.INSTANCE.errorName(n);
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        return RequestUtilKt.crtException(n, string, throwable);
    }

    public static final <T> T mapCrtException(@NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$mapCrtException = false;
        try {
            object = block.invoke();
        }
        catch (CrtRuntimeException ex) {
            throw RequestUtilKt.crtException(ex.getErrorCode(), ex.getErrorName(), ex);
        }
        return (T)object;
    }

    @NotNull
    public static final String fmtCrtErrorMessage(int errorCode) {
        String errorDescription = CRT.INSTANCE.errorString(errorCode);
        String errName = CRT.INSTANCE.errorName(errorCode);
        return errName + ": " + errorDescription + "; crtErrorCode=" + errorCode;
    }

    private static final HttpErrorCode mapCrtErrorCode(String errorName) {
        String string = errorName;
        return Intrinsics.areEqual((Object)string, (Object)"AWS_IO_SOCKET_TIMEOUT") ? HttpErrorCode.SOCKET_TIMEOUT : (Intrinsics.areEqual((Object)string, (Object)"AWS_ERROR_HTTP_UNSUPPORTED_PROTOCOL") ? HttpErrorCode.PROTOCOL_NEGOTIATION_ERROR : (Intrinsics.areEqual((Object)string, (Object)"AWS_IO_SOCKET_NOT_CONNECTED") ? HttpErrorCode.CONNECT_TIMEOUT : (Intrinsics.areEqual((Object)string, (Object)"AWS_IO_TLS_NEGOTIATION_TIMEOUT") ? HttpErrorCode.TLS_NEGOTIATION_TIMEOUT : (CollectionsKt.contains((Iterable)tlsNegotiationErrors, (Object)string) ? HttpErrorCode.TLS_NEGOTIATION_ERROR : (CollectionsKt.contains((Iterable)connectionClosedErrors, (Object)string) ? HttpErrorCode.CONNECTION_CLOSED : HttpErrorCode.SDK_UNKNOWN)))));
    }

    @NotNull
    public static final HttpErrorCode mapCrtErrorCode(int code) {
        return RequestUtilKt.mapCrtErrorCode(CRT.INSTANCE.errorName(code));
    }

    public static final boolean isRetryable(int errorCode, @Nullable String errorName) {
        boolean bl;
        String string = errorName;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = StringsKt.startsWith$default((String)it, (String)"AWS_IO_", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"AWS_ERROR_IO_", (boolean)false, (int)2, null) ? true : (connectionClosedErrors.contains(it) ? true : (StringsKt.startsWith$default((String)it, (String)"AWS_ERROR_HTTP_", (boolean)false, (int)2, null) ? CRT.INSTANCE.isHttpErrorRetryable(errorCode) : false));
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Unit _get_uri_$lambda$2(Url $sdkUrl, UriBuilder $this$build) {
        UserInfo userInfo;
        aws.smithy.kotlin.runtime.net.url.UserInfo userInfo2;
        aws.smithy.kotlin.runtime.net.url.UserInfo it;
        aws.smithy.kotlin.runtime.net.url.UserInfo userInfo3;
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        $this$build.setScheme(Protocol.Companion.createOrDefault($sdkUrl.getScheme().getProtocolName()));
        $this$build.setHost($sdkUrl.getHost().toString());
        $this$build.setPort(Integer.valueOf($sdkUrl.getPort()));
        aws.smithy.kotlin.runtime.net.url.UserInfo userInfo4 = userInfo3 = $sdkUrl.getUserInfo();
        UriBuilder uriBuilder = $this$build;
        boolean bl = false;
        boolean bl2 = it.isNotEmpty();
        UriBuilder uriBuilder2 = uriBuilder;
        Object object = userInfo2 = bl2 ? userInfo3 : null;
        if (userInfo2 != null) {
            it = userInfo2;
            uriBuilder = uriBuilder2;
            boolean bl3 = false;
            userInfo = new UserInfo(it.getUserName().getDecoded(), it.getPassword().getDecoded());
            uriBuilder2 = uriBuilder;
        } else {
            userInfo = null;
        }
        uriBuilder2.setUserInfo(userInfo);
        return Unit.INSTANCE;
    }

    private static final Unit toCrtRequest$lambda$4(SdkSource $source, Throwable it) {
        $source.close();
        return Unit.INSTANCE;
    }

    private static final Unit toCrtRequest$lambda$6$lambda$5(HeadersBuilder $this_with, String key, List values) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        $this_with.appendAll(key, (Iterable)values);
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"AWS_IO_TLS_ERROR_NEGOTIATION_FAILURE", "AWS_IO_TLS_ERROR_NOT_NEGOTIATED", "AWS_IO_TLS_DIGEST_ALGORITHM_UNSUPPORTED", "AWS_IO_TLS_SIGNATURE_ALGORITHM_UNSUPPORTED"};
        tlsNegotiationErrors = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"AWS_ERROR_HTTP_CONNECTION_CLOSED", "AWS_ERROR_HTTP_SERVER_CLOSED", "AWS_IO_BROKEN_PIPE", "AWS_IO_SOCKET_CLOSED"};
        connectionClosedErrors = SetsKt.setOf((Object[])objectArray);
    }
}

