/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.http.engine.okhttp.SdkRequestTag;
import aws.smithy.kotlin.runtime.logging.Logger;
import aws.smithy.kotlin.runtime.net.DefaultHostResolverJVMKt;
import aws.smithy.kotlin.runtime.net.HostResolver;
import aws.smithy.kotlin.runtime.tracing.NoOpTraceSpanKt;
import aws.smithy.kotlin.runtime.tracing.TraceSpan;
import aws.smithy.kotlin.runtime.tracing.TraceSpanExtKt;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.ConnectionPool;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J2\u0010!\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\"\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0016J&\u0010'\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0016J&\u0010.\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001e0+H\u0016J\u0018\u00102\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00103\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u00107\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u00108\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010<\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00104\u001a\u000205H\u0016J\u0010\u0010=\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010>\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010?\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010@\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010A\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u001a\u0010B\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u0010\u0010E\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0019\u0010F\u001a\u00020\u000e2\u000e\b\u0004\u0010G\u001a\b\u0012\u0004\u0012\u00020I0HH\u0082\bJ!\u0010F\u001a\u00020\u000e2\u0006\u0010J\u001a\u00020K2\u000e\b\u0004\u0010G\u001a\b\u0012\u0004\u0012\u00020I0HH\u0082\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/HttpEngineEventListener;", "Lokhttp3/EventListener;", "pool", "Lokhttp3/ConnectionPool;", "hr", "Laws/smithy/kotlin/runtime/net/HostResolver;", "call", "Lokhttp3/Call;", "(Lokhttp3/ConnectionPool;Laws/smithy/kotlin/runtime/net/HostResolver;Lokhttp3/Call;)V", "logger", "Laws/smithy/kotlin/runtime/logging/Logger;", "traceSpan", "Laws/smithy/kotlin/runtime/tracing/TraceSpan;", "cacheConditionalHit", "", "cachedResponse", "Lokhttp3/Response;", "cacheHit", "response", "cacheMiss", "callEnd", "callFailed", "ioe", "Ljava/io/IOException;", "callStart", "canceled", "connectEnd", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "proxy", "Ljava/net/Proxy;", "protocol", "Lokhttp3/Protocol;", "connectFailed", "connectStart", "connectionAcquired", "connection", "Lokhttp3/Connection;", "connectionReleased", "dnsEnd", "domainName", "", "inetAddressList", "", "Ljava/net/InetAddress;", "dnsStart", "proxySelectEnd", "url", "Lokhttp3/HttpUrl;", "proxies", "proxySelectStart", "requestBodyEnd", "byteCount", "", "requestBodyStart", "requestFailed", "requestHeadersEnd", "request", "Lokhttp3/Request;", "requestHeadersStart", "responseBodyEnd", "responseBodyStart", "responseFailed", "responseHeadersEnd", "responseHeadersStart", "satisfactionFailure", "secureConnectEnd", "handshake", "Lokhttp3/Handshake;", "secureConnectStart", "trace", "msg", "Lkotlin/Function0;", "", "throwable", "", "http-client-engine-okhttp"})
public final class HttpEngineEventListener
extends EventListener {
    @NotNull
    private final ConnectionPool pool;
    @NotNull
    private final HostResolver hr;
    @NotNull
    private final TraceSpan traceSpan;
    @NotNull
    private final Logger logger;

    public HttpEngineEventListener(@NotNull ConnectionPool pool, @NotNull HostResolver hr, @NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)hr, (String)"hr");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.pool = pool;
        this.hr = hr;
        Request this_$iv = call.request();
        boolean $i$f$reifiedTag = false;
        SdkRequestTag sdkRequestTag = (SdkRequestTag)this_$iv.tag(Reflection.getOrCreateKotlinClass(SdkRequestTag.class));
        if (sdkRequestTag == null || (sdkRequestTag = sdkRequestTag.getTraceSpan()) == null || (sdkRequestTag = sdkRequestTag.child("HTTP")) == null) {
            sdkRequestTag = NoOpTraceSpanKt.getNoOpTraceSpan();
        }
        TraceSpan $this$logger$iv = this.traceSpan = sdkRequestTag;
        boolean $i$f$logger = false;
        String string = Reflection.getOrCreateKotlinClass(HttpEngineEventListener.class).getQualifiedName();
        if (string == null) {
            boolean bl = false;
            String string2 = "logger<T> cannot be used on an anonymous object";
            throw new IllegalArgumentException(string2.toString());
        }
        String sourceComponent$iv = string;
        this.logger = TraceSpanExtKt.logger((TraceSpan)$this$logger$iv, (String)sourceComponent$iv);
    }

    private final void trace(Function0<? extends Object> msg) {
        boolean $i$f$trace = false;
        this.logger.trace((Function0)new Function0<Object>(msg){
            final /* synthetic */ Function0<Object> $msg;
            {
                this.$msg = $msg;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$msg.invoke();
            }
        });
    }

    private final void trace(Throwable throwable, Function0<? extends Object> msg) {
        boolean $i$f$trace = false;
        this.logger.trace(throwable, (Function0)new Function0<Object>(msg){
            final /* synthetic */ Function0<Object> $msg;
            {
                this.$msg = $msg;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$msg.invoke();
            }
        });
    }

    public void callStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "call started";
            }
        });
    }

    public void callEnd(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "call complete";
            }
        });
        this.traceSpan.close();
    }

    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "call failed";
            }
        });
        this.traceSpan.close();
    }

    public void canceled(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "call cancelled";
            }
        });
    }

    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(inetSocketAddress, proxy){
            final /* synthetic */ InetSocketAddress $inetSocketAddress$inlined;
            final /* synthetic */ Proxy $proxy$inlined;
            {
                this.$inetSocketAddress$inlined = inetSocketAddress;
                this.$proxy$inlined = proxy;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "starting connection: addr=" + this.$inetSocketAddress$inlined + "; proxy=" + this.$proxy$inlined;
            }
        });
    }

    public void connectEnd(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(inetSocketAddress, proxy, protocol){
            final /* synthetic */ InetSocketAddress $inetSocketAddress$inlined;
            final /* synthetic */ Proxy $proxy$inlined;
            final /* synthetic */ Protocol $protocol$inlined;
            {
                this.$inetSocketAddress$inlined = inetSocketAddress;
                this.$proxy$inlined = proxy;
                this.$protocol$inlined = protocol;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "connection established: addr=" + this.$inetSocketAddress$inlined + "; proxy=" + this.$proxy$inlined + "; protocol=" + this.$protocol$inlined;
            }
        });
    }

    public void connectFailed(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<Object>(inetSocketAddress, proxy, protocol){
            final /* synthetic */ InetSocketAddress $inetSocketAddress$inlined;
            final /* synthetic */ Proxy $proxy$inlined;
            final /* synthetic */ Protocol $protocol$inlined;
            {
                this.$inetSocketAddress$inlined = inetSocketAddress;
                this.$proxy$inlined = proxy;
                this.$protocol$inlined = protocol;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "connect failed: addr=" + this.$inetSocketAddress$inlined + "; proxy=" + this.$proxy$inlined + "; protocol=" + this.$protocol$inlined;
            }
        });
        InetAddress inetAddress = inetSocketAddress.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"inetSocketAddress.address");
        this.hr.reportFailure(DefaultHostResolverJVMKt.toHostAddress((InetAddress)inetAddress));
    }

    public void connectionAcquired(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        int connId = System.identityHashCode(connection);
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(connId, connection, this){
            final /* synthetic */ int $connId$inlined;
            final /* synthetic */ Connection $connection$inlined;
            final /* synthetic */ HttpEngineEventListener this$0;
            {
                this.$connId$inlined = n;
                this.$connection$inlined = connection;
                this.this$0 = httpEngineEventListener;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "connection acquired: conn(id=" + this.$connId$inlined + ")=" + this.$connection$inlined + "; connPool: total=" + HttpEngineEventListener.access$getPool$p(this.this$0).connectionCount() + ", idle=" + HttpEngineEventListener.access$getPool$p(this.this$0).idleConnectionCount();
            }
        });
    }

    public void connectionReleased(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        int connId = System.identityHashCode(connection);
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(connId, connection, this){
            final /* synthetic */ int $connId$inlined;
            final /* synthetic */ Connection $connection$inlined;
            final /* synthetic */ HttpEngineEventListener this$0;
            {
                this.$connId$inlined = n;
                this.$connection$inlined = connection;
                this.this$0 = httpEngineEventListener;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "connection released: conn(id=" + this.$connId$inlined + ")=" + this.$connection$inlined + "; connPool: total=" + HttpEngineEventListener.access$getPool$p(this.this$0).connectionCount() + ", idle=" + HttpEngineEventListener.access$getPool$p(this.this$0).idleConnectionCount();
            }
        });
    }

    public void dnsStart(@NotNull Call call, @NotNull String domainName) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(domainName){
            final /* synthetic */ String $domainName$inlined;
            {
                this.$domainName$inlined = string;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "dns query: domain=" + this.$domainName$inlined;
            }
        });
    }

    public void dnsEnd(@NotNull Call call, @NotNull String domainName, @NotNull List<? extends InetAddress> inetAddressList) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        Intrinsics.checkNotNullParameter(inetAddressList, (String)"inetAddressList");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(domainName, inetAddressList){
            final /* synthetic */ String $domainName$inlined;
            final /* synthetic */ List $inetAddressList$inlined;
            {
                this.$domainName$inlined = string;
                this.$inetAddressList$inlined = list;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "dns resolved: domain=" + this.$domainName$inlined + "; records=" + this.$inetAddressList$inlined;
            }
        });
    }

    public void proxySelectStart(@NotNull Call call, @NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(url){
            final /* synthetic */ HttpUrl $url$inlined;
            {
                this.$url$inlined = httpUrl;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "proxy select start: url=" + this.$url$inlined;
            }
        });
    }

    public void proxySelectEnd(@NotNull Call call, @NotNull HttpUrl url, @NotNull List<? extends Proxy> proxies) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(proxies, (String)"proxies");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(url, proxies){
            final /* synthetic */ HttpUrl $url$inlined;
            final /* synthetic */ List $proxies$inlined;
            {
                this.$url$inlined = httpUrl;
                this.$proxies$inlined = list;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "proxy select end: url=" + this.$url$inlined + "; proxies=" + this.$proxies$inlined;
            }
        });
    }

    public void requestBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "sending request body";
            }
        });
    }

    public void requestBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(byteCount){
            final /* synthetic */ long $byteCount$inlined;
            {
                this.$byteCount$inlined = l;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "finished sending request body: bytesSent=" + this.$byteCount$inlined;
            }
        });
    }

    public void requestFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "request failed";
            }
        });
    }

    public void requestHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "sending request headers";
            }
        });
    }

    public void requestHeadersEnd(@NotNull Call call, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "finished sending request headers";
            }
        });
    }

    public void responseBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "response body available";
            }
        });
    }

    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(byteCount){
            final /* synthetic */ long $byteCount$inlined;
            {
                this.$byteCount$inlined = l;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "response body finished: bytesConsumed=" + this.$byteCount$inlined;
            }
        });
    }

    public void responseFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "response failed";
            }
        });
    }

    public void responseHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "response headers start";
            }
        });
    }

    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        long contentLength = response.body().contentLength();
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(contentLength){
            final /* synthetic */ long $contentLength$inlined;
            {
                this.$contentLength$inlined = l;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "response headers end: contentLengthHeader=" + this.$contentLength$inlined;
            }
        });
    }

    public void secureConnectStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "initiating TLS connection";
            }
        });
    }

    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(handshake){
            final /* synthetic */ Handshake $handshake$inlined;
            {
                this.$handshake$inlined = handshake;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "TLS connect end: handshake=" + this.$handshake$inlined;
            }
        });
    }

    public void satisfactionFailure(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "cache satisfaction failure";
            }
        });
    }

    public void cacheConditionalHit(@NotNull Call call, @NotNull Response cachedResponse) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)cachedResponse, (String)"cachedResponse");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "cache conditional hit";
            }
        });
    }

    public void cacheHit(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "cache hit";
            }
        });
    }

    public void cacheMiss(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                boolean bl = false;
                return "cache miss";
            }
        });
    }

    public static final /* synthetic */ ConnectionPool access$getPool$p(HttpEngineEventListener $this) {
        return $this.pool;
    }
}

