/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.client.ExecutionContext;
import aws.smithy.kotlin.runtime.http.Headers;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpStatusCode;
import aws.smithy.kotlin.runtime.http.Protocol;
import aws.smithy.kotlin.runtime.http.Url;
import aws.smithy.kotlin.runtime.http.UrlBuilder;
import aws.smithy.kotlin.runtime.http.UrlKt;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpHeadersAdapter;
import aws.smithy.kotlin.runtime.http.engine.okhttp.SdkRequestTag;
import aws.smithy.kotlin.runtime.http.engine.okhttp.StreamingRequestBody;
import aws.smithy.kotlin.runtime.http.request.HttpRequest;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.http.util.StringValuesMap;
import aws.smithy.kotlin.runtime.http.util.TextKt;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.internal.ConvertKt;
import aws.smithy.kotlin.runtime.net.Host;
import aws.smithy.kotlin.runtime.tracing.CoroutineContextUtilsKt;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"toOkHttpRequest", "Lokhttp3/Request;", "Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "execContext", "Laws/smithy/kotlin/runtime/client/ExecutionContext;", "callContext", "Lkotlin/coroutines/CoroutineContext;", "toSdkResponse", "Laws/smithy/kotlin/runtime/http/response/HttpResponse;", "Lokhttp3/Response;", "toUrl", "Laws/smithy/kotlin/runtime/http/Url;", "Ljava/net/URI;", "http-client-engine-okhttp"})
public final class OkHttpUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Request toOkHttpRequest(@NotNull HttpRequest $this$toOkHttpRequest, @NotNull ExecutionContext execContext, @NotNull CoroutineContext callContext) {
        RequestBody requestBody;
        Intrinsics.checkNotNullParameter((Object)$this$toOkHttpRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)execContext, (String)"execContext");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        Request.Builder builder = new Request.Builder();
        builder.tag(Reflection.getOrCreateKotlinClass(SdkRequestTag.class), (Object)new SdkRequestTag(execContext, CoroutineContextUtilsKt.getTraceSpan((CoroutineContext)callContext)));
        builder.url($this$toOkHttpRequest.getUrl().toString());
        $this$toOkHttpRequest.getHeaders().forEach((Function2)new Function2<String, List<? extends String>, Unit>(builder){
            final /* synthetic */ Request.Builder $builder;
            {
                this.$builder = $builder;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String key, @NotNull List<String> values) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter(values, (String)"values");
                Iterable iterable = values;
                Request.Builder builder = this.$builder;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    builder.addHeader(key, it);
                }
            }
        });
        if (HttpMethod.permitsRequestBody((String)$this$toOkHttpRequest.getMethod().name())) {
            HttpBody body = $this$toOkHttpRequest.getBody();
            if (body instanceof HttpBody.Empty) {
                requestBody = RequestBody.Companion.create(new byte[0], null, 0, 0);
            } else if (body instanceof HttpBody.Bytes) {
                byte[] it = ((HttpBody.Bytes)body).bytes();
                boolean bl = false;
                requestBody = RequestBody.Companion.create(it, null, 0, it.length);
            } else {
                if (!(body instanceof HttpBody.SourceContent ? true : body instanceof HttpBody.ChannelContent)) throw new NoWhenBranchMatchedException();
                requestBody = new StreamingRequestBody(body, callContext);
            }
        } else {
            if (!($this$toOkHttpRequest.getBody() instanceof HttpBody.Empty)) {
                boolean bl = false;
                String string = "unexpected HTTP body for method " + $this$toOkHttpRequest.getMethod();
                throw new IllegalStateException(string.toString());
            }
            requestBody = null;
        }
        RequestBody engineBody = requestBody;
        builder.method($this$toOkHttpRequest.getMethod().name(), engineBody);
        return builder.build();
    }

    @NotNull
    public static final HttpResponse toSdkResponse(@NotNull Response $this$toSdkResponse) {
        Intrinsics.checkNotNullParameter((Object)$this$toSdkResponse, (String)"<this>");
        OkHttpHeadersAdapter sdkHeaders = new OkHttpHeadersAdapter($this$toSdkResponse.headers());
        HttpBody httpBody2 = $this$toSdkResponse.body().contentLength() != 0L ? (HttpBody)new HttpBody.SourceContent($this$toSdkResponse){
            private final boolean isOneShot;
            @Nullable
            private final Long contentLength;
            final /* synthetic */ Response $this_toSdkResponse;
            {
                this.$this_toSdkResponse = $receiver;
                this.isOneShot = true;
                this.contentLength = $receiver.body().contentLength() >= 0L ? Long.valueOf($receiver.body().contentLength()) : null;
            }

            public boolean isOneShot() {
                return this.isOneShot;
            }

            @Nullable
            public Long getContentLength() {
                return this.contentLength;
            }

            @NotNull
            public SdkSource readFrom() {
                return ConvertKt.toSdk((Source)((Source)this.$this_toSdkResponse.body().source()));
            }
        } : (HttpBody)HttpBody.Empty.INSTANCE;
        return new HttpResponse(HttpStatusCode.Companion.fromValue($this$toSdkResponse.code()), (Headers)sdkHeaders, httpBody2);
    }

    private static final Url toUrl(URI $this$toUrl) {
        URI uri = $this$toUrl;
        return UrlBuilder.Companion.invoke((Function1)new Function1<UrlBuilder, Unit>(uri){
            final /* synthetic */ URI $uri;
            {
                this.$uri = $uri;
                super(1);
            }

            /*
             * Unable to fully structure code
             */
            public final void invoke(@NotNull UrlBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                v0 = this.$uri.getScheme();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"uri.scheme");
                $this$invoke.setScheme(Protocol.Companion.parse(v0));
                v1 = this.$uri.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"uri.host");
                if (StringsKt.startsWith$default((String)v1, (String)"[", (boolean)false, (int)2, null)) {
                    v2 = this.$uri.getHost();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"uri.host");
                    v3 = StringsKt.substring((String)v2, (IntRange)RangesKt.until((int)1, (int)(this.$uri.getHost().length() - 1)));
                } else {
                    v3 = this.$uri.getHost();
                }
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"if (uri.host.startsWith(\u2026length - 1) else uri.host");
                $this$invoke.setHost(Host.Companion.parse(v3));
                var2_2 = this.$uri.getPort();
                var3_3 = ((Number)var2_2).intValue();
                var7_6 = $this$invoke;
                $i$a$-takeIf-OkHttpUtilsKt$toUrl$1$1 = false;
                var8_10 = it > 0;
                var7_6.setPort((Integer)(var8_10 != false ? var2_2 : null));
                v4 = this.$uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"uri.path");
                $this$invoke.setPath(v4);
                if (this.$uri.getQuery() != null) {
                    v5 = this.$uri.getQuery();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"uri.query");
                    if (StringsKt.isBlank((CharSequence)v5) == false) {
                        v6 = this.$uri.getQuery();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"uri.query");
                        parsedParameters = TextKt.splitAsQueryParameters((String)v6);
                        $this$invoke.getParameters().appendAll((StringValuesMap)parsedParameters);
                    }
                }
                v7 = $this$invoke;
                var2_2 = this.$uri.getUserInfo();
                if (var2_2 == null) ** GOTO lbl-1000
                var5_11 = $i$a$-takeIf-OkHttpUtilsKt$toUrl$1$1 = var2_2;
                var7_6 = v7;
                $i$a$-takeIf-OkHttpUtilsKt$toUrl$1$2 = false;
                var8_10 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
                v7 = var7_6;
                v8 = var3_4 = var8_10 != false ? $i$a$-takeIf-OkHttpUtilsKt$toUrl$1$1 : null;
                if (var3_4 != null) {
                    it = var3_4;
                    var7_6 = v7;
                    $i$a$-let-OkHttpUtilsKt$toUrl$1$3 = false;
                    v9 = UrlKt.UserInfo((String)p0);
                    v7 = var7_6;
                } else lbl-1000:
                // 2 sources

                {
                    v9 = null;
                }
                v7.setUserInfo(v9);
                v10 = $this$invoke;
                v11 = this.$uri.getFragment();
                if (v11 != null) {
                    $i$a$-takeIf-OkHttpUtilsKt$toUrl$1$1 = var3_5 = v11;
                    var7_6 = v10;
                    $i$a$-takeIf-OkHttpUtilsKt$toUrl$1$4 = false;
                    var8_10 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
                    v10 = var7_6;
                    v12 = var8_10 ? var3_5 : null;
                } else {
                    v12 = null;
                }
                v10.setFragment(v12);
            }
        });
    }

    public static final /* synthetic */ Url access$toUrl(URI $receiver) {
        return OkHttpUtilsKt.toUrl($receiver);
    }
}

