/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.http.interceptors.FlexibleChecksumsResponseInterceptorKt;
import aws.smithy.kotlin.runtime.io.HashingSource;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.text.encoding.Base64Kt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\bH\u0096\u0001J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Laws/smithy/kotlin/runtime/http/interceptors/ChecksumValidatingSource;", "Laws/smithy/kotlin/runtime/io/SdkSource;", "expectedChecksum", "", "hashingSource", "Laws/smithy/kotlin/runtime/io/HashingSource;", "(Ljava/lang/String;Laws/smithy/kotlin/runtime/io/HashingSource;)V", "close", "", "read", "", "sink", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "limit", "http-client"})
final class ChecksumValidatingSource
implements SdkSource {
    @NotNull
    private final String expectedChecksum;
    @NotNull
    private final HashingSource hashingSource;

    public ChecksumValidatingSource(@NotNull String expectedChecksum, @NotNull HashingSource hashingSource) {
        Intrinsics.checkNotNullParameter((Object)expectedChecksum, (String)"expectedChecksum");
        Intrinsics.checkNotNullParameter((Object)hashingSource, (String)"hashingSource");
        this.expectedChecksum = expectedChecksum;
        this.hashingSource = hashingSource;
    }

    public void close() {
        this.hashingSource.close();
    }

    public long read(@NotNull SdkBuffer sink, long limit) {
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long it = l = this.hashingSource.read(sink, limit);
        boolean bl = false;
        if (it == -1L) {
            FlexibleChecksumsResponseInterceptorKt.access$validateAndThrow(this.expectedChecksum, Base64Kt.encodeBase64String((byte[])this.hashingSource.digest()));
        }
        return l;
    }
}

