/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.ClientException;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpBodyKt;
import aws.smithy.kotlin.runtime.http.interceptors.ChecksumMismatchException;
import aws.smithy.kotlin.runtime.http.interceptors.ChecksumValidatingByteReadChannel;
import aws.smithy.kotlin.runtime.http.interceptors.ChecksumValidatingSource;
import aws.smithy.kotlin.runtime.io.HashingByteReadChannel;
import aws.smithy.kotlin.runtime.io.HashingSource;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannel;
import aws.smithy.kotlin.runtime.io.SdkSource;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\f"}, d2={"CHECKSUM_HEADER_VALIDATION_PRIORITY_LIST", "", "", "getCHECKSUM_HEADER_VALIDATION_PRIORITY_LIST", "()Ljava/util/List;", "validateAndThrow", "", "expected", "actual", "toChecksumValidatingBody", "Laws/smithy/kotlin/runtime/http/HttpBody;", "expectedChecksum", "http-client"})
public final class FlexibleChecksumsResponseInterceptorKt {
    @NotNull
    private static final List<String> CHECKSUM_HEADER_VALIDATION_PRIORITY_LIST;

    @NotNull
    public static final List<String> getCHECKSUM_HEADER_VALIDATION_PRIORITY_LIST() {
        return CHECKSUM_HEADER_VALIDATION_PRIORITY_LIST;
    }

    private static final HttpBody toChecksumValidatingBody(HttpBody $this$toChecksumValidatingBody, String expectedChecksum) {
        HttpBody httpBody;
        HttpBody httpBody2 = $this$toChecksumValidatingBody;
        if (httpBody2 instanceof HttpBody.SourceContent) {
            SdkSource sdkSource = ((HttpBody.SourceContent)$this$toChecksumValidatingBody).readFrom();
            Intrinsics.checkNotNull((Object)sdkSource, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.io.HashingSource");
            httpBody = HttpBodyKt.toHttpBody((SdkSource)new ChecksumValidatingSource(expectedChecksum, (HashingSource)sdkSource), (Long)$this$toChecksumValidatingBody.getContentLength());
        } else if (httpBody2 instanceof HttpBody.ChannelContent) {
            SdkByteReadChannel sdkByteReadChannel = ((HttpBody.ChannelContent)$this$toChecksumValidatingBody).readFrom();
            Intrinsics.checkNotNull((Object)sdkByteReadChannel, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.io.HashingByteReadChannel");
            httpBody = HttpBodyKt.toHttpBody((SdkByteReadChannel)new ChecksumValidatingByteReadChannel(expectedChecksum, (HashingByteReadChannel)sdkByteReadChannel), (Long)$this$toChecksumValidatingBody.getContentLength());
        } else {
            throw new ClientException("HttpBody type is not supported");
        }
        return httpBody;
    }

    private static final void validateAndThrow(String expected, String actual) {
        if (!Intrinsics.areEqual((Object)expected, (Object)actual)) {
            throw new ChecksumMismatchException("Checksum mismatch. Expected " + expected + " but was " + actual);
        }
    }

    public static final /* synthetic */ HttpBody access$toChecksumValidatingBody(HttpBody $receiver, String expectedChecksum) {
        return FlexibleChecksumsResponseInterceptorKt.toChecksumValidatingBody($receiver, expectedChecksum);
    }

    public static final /* synthetic */ void access$validateAndThrow(String expected, String actual) {
        FlexibleChecksumsResponseInterceptorKt.validateAndThrow(expected, actual);
    }

    static {
        Object[] objectArray = new String[]{"x-amz-checksum-crc32c", "x-amz-checksum-crc32", "x-amz-checksum-sha1", "x-amz-checksum-sha256"};
        CHECKSUM_HEADER_VALIDATION_PRIORITY_LIST = CollectionsKt.listOf((Object[])objectArray);
    }
}

