/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.http.interceptors.ResponseLengthValidationInterceptorKt;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\fH\u0096\u0001J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016R\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Laws/smithy/kotlin/runtime/http/interceptors/LengthValidatingSource;", "Laws/smithy/kotlin/runtime/io/SdkSource;", "source", "expectedContentLength", "", "(Laws/smithy/kotlin/runtime/io/SdkSource;J)V", "bytesReceived", "getBytesReceived", "()J", "setBytesReceived", "(J)V", "close", "", "read", "sink", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "limit", "http-client"})
final class LengthValidatingSource
implements SdkSource {
    @NotNull
    private final SdkSource source;
    private final long expectedContentLength;
    private long bytesReceived;

    public LengthValidatingSource(@NotNull SdkSource source, long expectedContentLength) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.expectedContentLength = expectedContentLength;
    }

    public void close() {
        this.source.close();
    }

    public final long getBytesReceived() {
        return this.bytesReceived;
    }

    public final void setBytesReceived(long l) {
        this.bytesReceived = l;
    }

    public long read(@NotNull SdkBuffer sink, long limit) {
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long it = l = this.source.read(sink, limit);
        boolean bl = false;
        if (it == -1L || this.bytesReceived > this.expectedContentLength) {
            ResponseLengthValidationInterceptorKt.access$validateContentLength(this.expectedContentLength, this.bytesReceived);
        } else {
            this.bytesReceived += it;
        }
        return l;
    }
}

