/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.request;

import aws.smithy.kotlin.runtime.http.DeferredHeaders;
import aws.smithy.kotlin.runtime.http.DeferredHeadersBuilder;
import aws.smithy.kotlin.runtime.http.Headers;
import aws.smithy.kotlin.runtime.http.HeadersBuilder;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpMethod;
import aws.smithy.kotlin.runtime.http.request.HttpRequest;
import aws.smithy.kotlin.runtime.http.request.HttpRequestKt;
import aws.smithy.kotlin.runtime.net.UrlBuilder;
import aws.smithy.kotlin.runtime.util.CanDeepCopy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B/\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0000H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Laws/smithy/kotlin/runtime/http/request/HttpRequestBuilder;", "Laws/smithy/kotlin/runtime/util/CanDeepCopy;", "()V", "method", "Laws/smithy/kotlin/runtime/http/HttpMethod;", "url", "Laws/smithy/kotlin/runtime/net/UrlBuilder;", "headers", "Laws/smithy/kotlin/runtime/http/HeadersBuilder;", "body", "Laws/smithy/kotlin/runtime/http/HttpBody;", "trailingHeaders", "Laws/smithy/kotlin/runtime/http/DeferredHeadersBuilder;", "(Laws/smithy/kotlin/runtime/http/HttpMethod;Laws/smithy/kotlin/runtime/net/UrlBuilder;Laws/smithy/kotlin/runtime/http/HeadersBuilder;Laws/smithy/kotlin/runtime/http/HttpBody;Laws/smithy/kotlin/runtime/http/DeferredHeadersBuilder;)V", "getBody", "()Laws/smithy/kotlin/runtime/http/HttpBody;", "setBody", "(Laws/smithy/kotlin/runtime/http/HttpBody;)V", "getHeaders", "()Laws/smithy/kotlin/runtime/http/HeadersBuilder;", "getMethod", "()Laws/smithy/kotlin/runtime/http/HttpMethod;", "setMethod", "(Laws/smithy/kotlin/runtime/http/HttpMethod;)V", "getTrailingHeaders", "()Laws/smithy/kotlin/runtime/http/DeferredHeadersBuilder;", "getUrl", "()Laws/smithy/kotlin/runtime/net/UrlBuilder;", "build", "Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "deepCopy", "toString", "", "http"})
public final class HttpRequestBuilder
implements CanDeepCopy<HttpRequestBuilder> {
    @NotNull
    private HttpMethod method;
    @NotNull
    private final UrlBuilder url;
    @NotNull
    private final HeadersBuilder headers;
    @NotNull
    private HttpBody body;
    @NotNull
    private final DeferredHeadersBuilder trailingHeaders;

    private HttpRequestBuilder(HttpMethod method, UrlBuilder url2, HeadersBuilder headers2, HttpBody body, DeferredHeadersBuilder trailingHeaders2) {
        this.method = method;
        this.url = url2;
        this.headers = headers2;
        this.body = body;
        this.trailingHeaders = trailingHeaders2;
    }

    @NotNull
    public final HttpMethod getMethod() {
        return this.method;
    }

    public final void setMethod(@NotNull HttpMethod httpMethod) {
        Intrinsics.checkNotNullParameter((Object)((Object)httpMethod), (String)"<set-?>");
        this.method = httpMethod;
    }

    @NotNull
    public final UrlBuilder getUrl() {
        return this.url;
    }

    @NotNull
    public final HeadersBuilder getHeaders() {
        return this.headers;
    }

    @NotNull
    public final HttpBody getBody() {
        return this.body;
    }

    public final void setBody(@NotNull HttpBody httpBody) {
        Intrinsics.checkNotNullParameter((Object)httpBody, (String)"<set-?>");
        this.body = httpBody;
    }

    @NotNull
    public final DeferredHeadersBuilder getTrailingHeaders() {
        return this.trailingHeaders;
    }

    public HttpRequestBuilder() {
        this(HttpMethod.GET, new UrlBuilder(), new HeadersBuilder(), HttpBody.Empty.INSTANCE, new DeferredHeadersBuilder());
    }

    @NotNull
    public final HttpRequest build() {
        return HttpRequestKt.HttpRequest(this.method, this.url.build(), this.headers.isEmpty() ? Headers.Companion.getEmpty() : this.headers.build(), this.body, this.trailingHeaders.isEmpty() ? DeferredHeaders.Companion.getEmpty() : this.trailingHeaders.build());
    }

    @NotNull
    public HttpRequestBuilder deepCopy() {
        return new HttpRequestBuilder(this.method, this.url.deepCopy(), this.headers.deepCopy(), this.body, this.trailingHeaders.deepCopy());
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("HttpRequestBuilder(method=" + (Object)((Object)this.method) + ", url=" + this.url + ", headers=" + (Object)((Object)this.headers) + ", body=" + this.body + ", trailingHeaders=" + (Object)((Object)this.trailingHeaders) + ')');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

