/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.response;

import aws.smithy.kotlin.runtime.http.request.HttpRequest;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.time.Instant;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\""}, d2={"Laws/smithy/kotlin/runtime/http/response/HttpCall;", "", "request", "Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "response", "Laws/smithy/kotlin/runtime/http/response/HttpResponse;", "requestTime", "Laws/smithy/kotlin/runtime/time/Instant;", "responseTime", "callContext", "Lkotlin/coroutines/CoroutineContext;", "(Laws/smithy/kotlin/runtime/http/request/HttpRequest;Laws/smithy/kotlin/runtime/http/response/HttpResponse;Laws/smithy/kotlin/runtime/time/Instant;Laws/smithy/kotlin/runtime/time/Instant;Lkotlin/coroutines/CoroutineContext;)V", "getCallContext", "()Lkotlin/coroutines/CoroutineContext;", "getRequest", "()Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "getRequestTime", "()Laws/smithy/kotlin/runtime/time/Instant;", "getResponse", "()Laws/smithy/kotlin/runtime/http/response/HttpResponse;", "getResponseTime", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "http"})
public final class HttpCall {
    @NotNull
    private final HttpRequest request;
    @NotNull
    private final HttpResponse response;
    @NotNull
    private final Instant requestTime;
    @NotNull
    private final Instant responseTime;
    @NotNull
    private final CoroutineContext callContext;

    public HttpCall(@NotNull HttpRequest request, @NotNull HttpResponse response, @NotNull Instant requestTime, @NotNull Instant responseTime, @NotNull CoroutineContext callContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)requestTime, (String)"requestTime");
        Intrinsics.checkNotNullParameter((Object)responseTime, (String)"responseTime");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        this.request = request;
        this.response = response;
        this.requestTime = requestTime;
        this.responseTime = responseTime;
        this.callContext = callContext;
    }

    public /* synthetic */ HttpCall(HttpRequest httpRequest, HttpResponse httpResponse, Instant instant, Instant instant2, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        this(httpRequest, httpResponse, instant, instant2, coroutineContext);
    }

    @NotNull
    public final HttpRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final HttpResponse getResponse() {
        return this.response;
    }

    @NotNull
    public final Instant getRequestTime() {
        return this.requestTime;
    }

    @NotNull
    public final Instant getResponseTime() {
        return this.responseTime;
    }

    @NotNull
    public final CoroutineContext getCallContext() {
        return this.callContext;
    }

    @NotNull
    public final HttpRequest component1() {
        return this.request;
    }

    @NotNull
    public final HttpResponse component2() {
        return this.response;
    }

    @NotNull
    public final Instant component3() {
        return this.requestTime;
    }

    @NotNull
    public final Instant component4() {
        return this.responseTime;
    }

    @NotNull
    public final CoroutineContext component5() {
        return this.callContext;
    }

    @NotNull
    public final HttpCall copy(@NotNull HttpRequest request, @NotNull HttpResponse response, @NotNull Instant requestTime, @NotNull Instant responseTime, @NotNull CoroutineContext callContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)requestTime, (String)"requestTime");
        Intrinsics.checkNotNullParameter((Object)responseTime, (String)"responseTime");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        return new HttpCall(request, response, requestTime, responseTime, callContext);
    }

    public static /* synthetic */ HttpCall copy$default(HttpCall httpCall, HttpRequest httpRequest, HttpResponse httpResponse, Instant instant, Instant instant2, CoroutineContext coroutineContext, int n, Object object) {
        if ((n & 1) != 0) {
            httpRequest = httpCall.request;
        }
        if ((n & 2) != 0) {
            httpResponse = httpCall.response;
        }
        if ((n & 4) != 0) {
            instant = httpCall.requestTime;
        }
        if ((n & 8) != 0) {
            instant2 = httpCall.responseTime;
        }
        if ((n & 0x10) != 0) {
            coroutineContext = httpCall.callContext;
        }
        return httpCall.copy(httpRequest, httpResponse, instant, instant2, coroutineContext);
    }

    @NotNull
    public String toString() {
        return "HttpCall(request=" + this.request + ", response=" + this.response + ", requestTime=" + this.requestTime + ", responseTime=" + this.responseTime + ", callContext=" + this.callContext + ')';
    }

    public int hashCode() {
        int result = this.request.hashCode();
        result = result * 31 + this.response.hashCode();
        result = result * 31 + this.requestTime.hashCode();
        result = result * 31 + this.responseTime.hashCode();
        result = result * 31 + this.callContext.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpCall)) {
            return false;
        }
        HttpCall httpCall = (HttpCall)other;
        if (!Intrinsics.areEqual((Object)this.request, (Object)httpCall.request)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.response, (Object)httpCall.response)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.requestTime, (Object)httpCall.requestTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseTime, (Object)httpCall.responseTime)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.callContext, (Object)httpCall.callContext);
    }
}

