/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.response;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.http.Headers;
import aws.smithy.kotlin.runtime.http.HeadersBuilder;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpStatusCode;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.http.response.HttpResponseKt;
import aws.smithy.kotlin.runtime.util.CanDeepCopy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0000H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Laws/smithy/kotlin/runtime/http/response/HttpResponseBuilder;", "Laws/smithy/kotlin/runtime/util/CanDeepCopy;", "()V", "status", "Laws/smithy/kotlin/runtime/http/HttpStatusCode;", "headers", "Laws/smithy/kotlin/runtime/http/HeadersBuilder;", "body", "Laws/smithy/kotlin/runtime/http/HttpBody;", "(Laws/smithy/kotlin/runtime/http/HttpStatusCode;Laws/smithy/kotlin/runtime/http/HeadersBuilder;Laws/smithy/kotlin/runtime/http/HttpBody;)V", "getBody", "()Laws/smithy/kotlin/runtime/http/HttpBody;", "setBody", "(Laws/smithy/kotlin/runtime/http/HttpBody;)V", "getHeaders", "()Laws/smithy/kotlin/runtime/http/HeadersBuilder;", "getStatus", "()Laws/smithy/kotlin/runtime/http/HttpStatusCode;", "setStatus", "(Laws/smithy/kotlin/runtime/http/HttpStatusCode;)V", "build", "Laws/smithy/kotlin/runtime/http/response/HttpResponse;", "deepCopy", "toString", "", "http"})
public final class HttpResponseBuilder
implements CanDeepCopy<HttpResponseBuilder> {
    @NotNull
    private HttpStatusCode status;
    @NotNull
    private final HeadersBuilder headers;
    @NotNull
    private HttpBody body;

    private HttpResponseBuilder(HttpStatusCode status, HeadersBuilder headers2, HttpBody body) {
        this.status = status;
        this.headers = headers2;
        this.body = body;
    }

    @NotNull
    public final HttpStatusCode getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull HttpStatusCode httpStatusCode) {
        Intrinsics.checkNotNullParameter((Object)httpStatusCode, (String)"<set-?>");
        this.status = httpStatusCode;
    }

    @NotNull
    public final HeadersBuilder getHeaders() {
        return this.headers;
    }

    @NotNull
    public final HttpBody getBody() {
        return this.body;
    }

    public final void setBody(@NotNull HttpBody httpBody) {
        Intrinsics.checkNotNullParameter((Object)httpBody, (String)"<set-?>");
        this.body = httpBody;
    }

    public HttpResponseBuilder() {
        this(HttpStatusCode.Companion.getOK(), new HeadersBuilder(), HttpBody.Empty.INSTANCE);
    }

    @NotNull
    public final HttpResponse build() {
        return HttpResponseKt.HttpResponse(this.status, this.headers.isEmpty() ? Headers.Companion.getEmpty() : this.headers.build(), this.body);
    }

    @NotNull
    public HttpResponseBuilder deepCopy() {
        return new HttpResponseBuilder(this.status, this.headers.deepCopy(), this.body);
    }

    @NotNull
    public String toString() {
        return "HttpResponseBuilder(status=" + this.status + ", headers=" + (Object)((Object)this.headers) + ", body=" + this.body + ')';
    }
}

