/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import aws.smithy.kotlin.runtime.serde.xml.XmlTokenKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\bJ\b\u0010\u0013\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/XmlTagReader;", "", "tag", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken$BeginElement;", "reader", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;", "(Laws/smithy/kotlin/runtime/serde/xml/XmlToken$BeginElement;Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;)V", "closed", "", "lastEmitted", "getTag", "()Laws/smithy/kotlin/runtime/serde/xml/XmlToken$BeginElement;", "tagName", "", "getTagName", "()Ljava/lang/String;", "drop", "", "nextHasValue", "nextTag", "nextToken", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken;", "serde-xml"})
public final class XmlTagReader {
    @NotNull
    private final XmlToken.BeginElement tag;
    @NotNull
    private final XmlStreamReader reader;
    @Nullable
    private XmlTagReader lastEmitted;
    private boolean closed;

    public XmlTagReader(@NotNull XmlToken.BeginElement tag, @NotNull XmlStreamReader reader) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.tag = tag;
        this.reader = reader;
    }

    @NotNull
    public final XmlToken.BeginElement getTag() {
        return this.tag;
    }

    @NotNull
    public final String getTagName() {
        return this.tag.getName().toString();
    }

    @Nullable
    public final XmlToken nextToken() {
        if (this.closed) {
            return null;
        }
        XmlToken peek = XmlStreamReader.DefaultImpls.peek$default(this.reader, 0, 1, null);
        if (XmlTokenKt.terminates(peek, this.tag)) {
            this.reader.nextToken();
            this.closed = true;
            return null;
        }
        return this.reader.nextToken();
    }

    public final boolean nextHasValue() {
        if (this.closed) {
            return false;
        }
        return !(XmlStreamReader.DefaultImpls.peek$default(this.reader, 0, 1, null) instanceof XmlToken.EndElement);
    }

    public final void drop() {
        XmlToken tok;
        while ((tok = this.nextToken()) != null) {
        }
    }

    @Nullable
    public final XmlTagReader nextTag() {
        XmlToken.BeginElement nextTok;
        XmlTagReader xmlTagReader = this.lastEmitted;
        if (xmlTagReader != null) {
            xmlTagReader.drop();
        }
        XmlToken cand = this.nextToken();
        while (cand != null && !(cand instanceof XmlToken.BeginElement)) {
            cand = this.nextToken();
        }
        Object object = cand;
        XmlToken.BeginElement beginElement = nextTok = object instanceof XmlToken.BeginElement ? (XmlToken.BeginElement)object : null;
        Object newScope = object = beginElement != null ? XmlTagReaderKt.tagReader(beginElement, this.reader) : null;
        boolean bl = false;
        this.lastEmitted = newScope;
        return object;
    }
}

