/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml.deserialization;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.StringTextStreamKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\nJ\u0019\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0082\bJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0080\b\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u0003J\u0016\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003J\u0016\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0003J\u0016\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0003J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/deserialization/StringTextStream;", "", "source", "", "<init>", "(Ljava/lang/String;)V", "end", "", "offset", "advance", "", "length", "errCondition", "advanceIf", "", "text", "advanceUntilSpace", "advanceWhileSpace", "checkBounds", "error", "", "msg", "error$serde_xml", "peekMatches", "readOrThrow", "", "readThrough", "readUntil", "readWhileXmlName", "rewind", "sliceByEnd", "endExclusive", "sliceByLength", "serde-xml"})
@SourceDebugExtension(value={"SMAP\nStringTextStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringTextStream.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/StringTextStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,268:1\n78#1:269\n94#1,12:270\n79#1:282\n94#1,12:283\n78#1:295\n94#1,12:296\n79#1:308\n94#1,12:309\n94#1,12:321\n94#1,12:333\n78#1:346\n94#1,12:347\n79#1:359\n1#2:345\n*S KotlinDebug\n*F\n+ 1 StringTextStream.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/StringTextStream\n*L\n31#1:269\n31#1:270,12\n31#1:282\n78#1:283,12\n122#1:295\n122#1:296,12\n122#1:308\n135#1:309,12\n152#1:321,12\n193#1:333,12\n252#1:346\n252#1:347,12\n252#1:359\n*E\n"})
public final class StringTextStream {
    @NotNull
    private final String source;
    private final int end;
    private int offset;

    public StringTextStream(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.end = this.source.length();
    }

    /*
     * WARNING - void declaration
     */
    public final void advance(int length, @NotNull String errCondition) {
        Intrinsics.checkNotNullParameter((Object)errCondition, (String)"errCondition");
        StringTextStream this_$iv = this;
        boolean $i$f$checkBounds = false;
        if (this_$iv.offset + length > this_$iv.end) {
            void this_$iv$iv;
            StringTextStream stringTextStream = this_$iv;
            String msg$iv$iv = "Unexpected end-of-doc while " + errCondition;
            boolean $i$f$error$serde_xml = false;
            int start$iv$iv = Math.max(0, ((StringTextStream)this_$iv$iv).offset - 3);
            int end$iv$iv = Math.min(((StringTextStream)this_$iv$iv).end - 1, ((StringTextStream)this_$iv$iv).offset + 3);
            String string = ((StringTextStream)this_$iv$iv).source.substring(start$iv$iv, end$iv$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string2 = "\u00b7";
            String snippet$iv$iv = regex.replace(charSequence, string2);
            int caretPos$iv$iv = ((StringTextStream)this_$iv$iv).offset - start$iv$iv;
            String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
            String locationMultilineString$iv$iv = "At offset " + ((StringTextStream)this_$iv$iv).offset + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
            String fullMsg$iv$iv = msg$iv$iv + '\n' + locationMultilineString$iv$iv;
            throw new DeserializationException(fullMsg$iv$iv);
        }
        this.offset += length;
    }

    public final boolean advanceIf(@NotNull String text) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.startsWith$default((String)this.source, (String)text, (int)this.offset, (boolean)false, (int)4, null)) {
            this.offset += text.length();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void advanceUntilSpace() {
        while (this.offset < this.end) {
            char ch = this.source.charAt(this.offset);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return;
                }
            }
            int n = this.offset;
            this.offset = n + 1;
        }
    }

    public final void advanceWhileSpace() {
        while (this.offset < this.end) {
            char ch = this.source.charAt(this.offset);
            if (ch != ' ' && ch != '\r' && ch != '\n' && ch != '\t') {
                return;
            }
            int n = this.offset;
            this.offset = n + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBounds(int length, String errCondition) {
        boolean $i$f$checkBounds = false;
        if (this.offset + length > this.end) {
            void this_$iv;
            StringTextStream stringTextStream = this;
            String msg$iv = "Unexpected end-of-doc while " + errCondition;
            boolean $i$f$error$serde_xml = false;
            int start$iv = Math.max(0, ((StringTextStream)this_$iv).offset - 3);
            int end$iv = Math.min(((StringTextStream)this_$iv).end - 1, ((StringTextStream)this_$iv).offset + 3);
            String string = ((StringTextStream)this_$iv).source.substring(start$iv, end$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string2 = "\u00b7";
            String snippet$iv = regex.replace(charSequence, string2);
            int caretPos$iv = ((StringTextStream)this_$iv).offset - start$iv;
            String caret$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv) + '^';
            String locationMultilineString$iv = "At offset " + ((StringTextStream)this_$iv).offset + " (showing range " + start$iv + '-' + end$iv + "):\n" + snippet$iv + '\n' + caret$iv;
            String fullMsg$iv = msg$iv + '\n' + locationMultilineString$iv;
            throw new DeserializationException(fullMsg$iv);
        }
    }

    @NotNull
    public final Void error$serde_xml(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        boolean $i$f$error$serde_xml = false;
        int start = Math.max(0, this.offset - 3);
        int end = Math.min(this.end - 1, this.offset + 3);
        String string = this.source.substring(start, end + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        CharSequence charSequence = string;
        Regex regex = StringTextStreamKt.access$getNonAscii$p();
        String string2 = "\u00b7";
        String snippet = regex.replace(charSequence, string2);
        int caretPos = this.offset - start;
        String caret = StringsKt.repeat((CharSequence)" ", (int)caretPos) + '^';
        String locationMultilineString = "At offset " + this.offset + " (showing range " + start + '-' + end + "):\n" + snippet + '\n' + caret;
        String fullMsg = msg + '\n' + locationMultilineString;
        throw new DeserializationException(fullMsg);
    }

    public final boolean peekMatches(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int actualLength = Math.min(text.length(), this.end - this.offset);
        return Intrinsics.areEqual((Object)this.sliceByLength(actualLength), (Object)text);
    }

    /*
     * WARNING - void declaration
     */
    public final char readOrThrow(@NotNull String errCondition) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)errCondition, (String)"errCondition");
        StringTextStream stringTextStream = this;
        int length$iv = 1;
        boolean $i$f$checkBounds = false;
        if (this_$iv.offset + length$iv > this_$iv.end) {
            void this_$iv$iv;
            void var5_6 = this_$iv;
            String msg$iv$iv = "Unexpected end-of-doc while " + errCondition;
            boolean $i$f$error$serde_xml = false;
            int start$iv$iv = Math.max(0, ((StringTextStream)this_$iv$iv).offset - 3);
            int end$iv$iv = Math.min(((StringTextStream)this_$iv$iv).end - 1, ((StringTextStream)this_$iv$iv).offset + 3);
            String string = ((StringTextStream)this_$iv$iv).source.substring(start$iv$iv, end$iv$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string2 = "\u00b7";
            String snippet$iv$iv = regex.replace(charSequence, string2);
            int caretPos$iv$iv = ((StringTextStream)this_$iv$iv).offset - start$iv$iv;
            String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
            String locationMultilineString$iv$iv = "At offset " + ((StringTextStream)this_$iv$iv).offset + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
            String fullMsg$iv$iv = msg$iv$iv + '\n' + locationMultilineString$iv$iv;
            throw new DeserializationException(fullMsg$iv$iv);
        }
        int n = this.offset;
        this.offset = n + 1;
        return this.source.charAt(n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readThrough(@NotNull String text, @NotNull String errCondition) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)errCondition, (String)"errCondition");
        int charIndex = StringsKt.indexOf$default((CharSequence)this.source, (String)text, (int)this.offset, (boolean)false, (int)4, null);
        if (charIndex < 0) {
            void this_$iv;
            StringTextStream stringTextStream = this;
            String msg$iv = "Unexpected end-of-doc while " + errCondition;
            boolean $i$f$error$serde_xml = false;
            int start$iv = Math.max(0, ((StringTextStream)this_$iv).offset - 3);
            int end$iv = Math.min(((StringTextStream)this_$iv).end - 1, ((StringTextStream)this_$iv).offset + 3);
            String string = ((StringTextStream)this_$iv).source.substring(start$iv, end$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string2 = "\u00b7";
            String snippet$iv = regex.replace(charSequence, string2);
            int caretPos$iv = ((StringTextStream)this_$iv).offset - start$iv;
            String caret$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv) + '^';
            String locationMultilineString$iv = "At offset " + ((StringTextStream)this_$iv).offset + " (showing range " + start$iv + '-' + end$iv + "):\n" + snippet$iv + '\n' + caret$iv;
            String fullMsg$iv = msg$iv + '\n' + locationMultilineString$iv;
            throw new DeserializationException(fullMsg$iv);
        }
        int endOfResult = charIndex + text.length();
        String result = this.sliceByEnd(endOfResult);
        this.offset = endOfResult;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readUntil(@NotNull String text, @NotNull String errCondition) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)errCondition, (String)"errCondition");
        int charIndex = StringsKt.indexOf$default((CharSequence)this.source, (String)text, (int)this.offset, (boolean)false, (int)4, null);
        if (charIndex < 0) {
            void this_$iv;
            StringTextStream stringTextStream = this;
            String msg$iv = "Unexpected end-of-doc while " + errCondition;
            boolean $i$f$error$serde_xml = false;
            int start$iv = Math.max(0, ((StringTextStream)this_$iv).offset - 3);
            int end$iv = Math.min(((StringTextStream)this_$iv).end - 1, ((StringTextStream)this_$iv).offset + 3);
            String string = ((StringTextStream)this_$iv).source.substring(start$iv, end$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string2 = "\u00b7";
            String snippet$iv = regex.replace(charSequence, string2);
            int caretPos$iv = ((StringTextStream)this_$iv).offset - start$iv;
            String caret$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv) + '^';
            String locationMultilineString$iv = "At offset " + ((StringTextStream)this_$iv).offset + " (showing range " + start$iv + '-' + end$iv + "):\n" + snippet$iv + '\n' + caret$iv;
            String fullMsg$iv = msg$iv + '\n' + locationMultilineString$iv;
            throw new DeserializationException(fullMsg$iv);
        }
        String result = this.sliceByEnd(charIndex);
        this.offset = charIndex;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readWhileXmlName() {
        String string;
        char ch;
        char c = this.source.charAt(this.offset);
        if (!(Intrinsics.compare((int)97, (int)c) <= 0 && Intrinsics.compare((int)c, (int)122) <= 0 || Intrinsics.compare((int)65, (int)c) <= 0 && Intrinsics.compare((int)c, (int)90) <= 0 || c == ':' || c == '_' || Intrinsics.compare((int)192, (int)c) <= 0 && Intrinsics.compare((int)c, (int)214) <= 0 || Intrinsics.compare((int)216, (int)c) <= 0 && Intrinsics.compare((int)c, (int)246) <= 0 || Intrinsics.compare((int)248, (int)c) <= 0 && Intrinsics.compare((int)c, (int)767) <= 0 || Intrinsics.compare((int)880, (int)c) <= 0 && Intrinsics.compare((int)c, (int)893) <= 0 || Intrinsics.compare((int)895, (int)c) <= 0 && Intrinsics.compare((int)c, (int)8191) <= 0 || Intrinsics.compare((int)8204, (int)c) <= 0 && Intrinsics.compare((int)c, (int)8205) <= 0 || Intrinsics.compare((int)8304, (int)c) <= 0 && Intrinsics.compare((int)c, (int)8591) <= 0 || Intrinsics.compare((int)11264, (int)c) <= 0 && Intrinsics.compare((int)c, (int)12271) <= 0 || Intrinsics.compare((int)12289, (int)c) <= 0 && Intrinsics.compare((int)c, (int)55295) <= 0)) {
            void this_$iv;
            StringTextStream stringTextStream = this;
            String msg$iv = "Found '" + c + "' but expected a valid XML start name character";
            boolean $i$f$error$serde_xml = false;
            int start$iv = Math.max(0, ((StringTextStream)this_$iv).offset - 3);
            int end$iv = Math.min(((StringTextStream)this_$iv).end - 1, ((StringTextStream)this_$iv).offset + 3);
            String string2 = ((StringTextStream)this_$iv).source.substring(start$iv, end$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            CharSequence charSequence = string2;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string3 = "\u00b7";
            String snippet$iv = regex.replace(charSequence, string3);
            int caretPos$iv = ((StringTextStream)this_$iv).offset - start$iv;
            String caret$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv) + '^';
            String locationMultilineString$iv = "At offset " + ((StringTextStream)this_$iv).offset + " (showing range " + start$iv + '-' + end$iv + "):\n" + snippet$iv + '\n' + caret$iv;
            String fullMsg$iv = msg$iv + '\n' + locationMultilineString$iv;
            throw new DeserializationException(fullMsg$iv);
        }
        int peekOffset = 0;
        peekOffset = this.offset + 1;
        while (peekOffset < this.end && (Intrinsics.compare((int)97, (int)(ch = this.source.charAt(peekOffset))) <= 0 && Intrinsics.compare((int)ch, (int)122) <= 0 || Intrinsics.compare((int)65, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)90) <= 0 || Intrinsics.compare((int)48, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)57) <= 0 || ch == ':' || ch == '-' || ch == '.' || ch == '_' || ch == '\u00b7' || Intrinsics.compare((int)192, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)214) <= 0 || Intrinsics.compare((int)216, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)246) <= 0 || Intrinsics.compare((int)248, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)767) <= 0 || Intrinsics.compare((int)768, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)879) <= 0 || Intrinsics.compare((int)880, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)893) <= 0 || Intrinsics.compare((int)895, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)8191) <= 0 || Intrinsics.compare((int)8204, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)8205) <= 0 || Intrinsics.compare((int)8255, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)8256) <= 0 || Intrinsics.compare((int)8304, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)8591) <= 0 || Intrinsics.compare((int)11264, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)12271) <= 0 || Intrinsics.compare((int)12289, (int)ch) <= 0 && Intrinsics.compare((int)ch, (int)55295) <= 0)) {
            int $i$f$error$serde_xml = peekOffset;
            peekOffset = $i$f$error$serde_xml + 1;
        }
        String it = string = this.sliceByEnd(peekOffset);
        boolean bl = false;
        this.offset = peekOffset;
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void rewind(int length, @NotNull String errCondition) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)errCondition, (String)"errCondition");
        StringTextStream stringTextStream = this;
        int length$iv = -length;
        boolean $i$f$checkBounds = false;
        if (this_$iv.offset + length$iv > this_$iv.end) {
            void this_$iv$iv;
            void var6_6 = this_$iv;
            String msg$iv$iv = "Unexpected end-of-doc while " + errCondition;
            boolean $i$f$error$serde_xml = false;
            int start$iv$iv = Math.max(0, ((StringTextStream)this_$iv$iv).offset - 3);
            int end$iv$iv = Math.min(((StringTextStream)this_$iv$iv).end - 1, ((StringTextStream)this_$iv$iv).offset + 3);
            String string = ((StringTextStream)this_$iv$iv).source.substring(start$iv$iv, end$iv$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string2 = "\u00b7";
            String snippet$iv$iv = regex.replace(charSequence, string2);
            int caretPos$iv$iv = ((StringTextStream)this_$iv$iv).offset - start$iv$iv;
            String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
            String locationMultilineString$iv$iv = "At offset " + ((StringTextStream)this_$iv$iv).offset + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
            String fullMsg$iv$iv = msg$iv$iv + '\n' + locationMultilineString$iv$iv;
            throw new DeserializationException(fullMsg$iv$iv);
        }
        this.offset -= length;
    }

    private final String sliceByEnd(int endExclusive) {
        String string = this.source.substring(this.offset, endExclusive);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final String sliceByLength(int length) {
        return this.sliceByEnd(this.offset + length);
    }
}

