/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml;

import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.Deserializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor;
import aws.smithy.kotlin.runtime.serde.xml.FieldLocation;
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializerKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import aws.smithy.kotlin.runtime.text.encoding.Base64Kt;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J'\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00140\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0017H\u0016J\b\u0010+\u001a\u00020\fH\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\n\u00104\u001a\u0004\u0018\u000105H\u0016J\b\u00106\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/XmlStructDeserializer;", "Laws/smithy/kotlin/runtime/serde/Deserializer$FieldIterator;", "objDescriptor", "Laws/smithy/kotlin/runtime/serde/SdkObjectDescriptor;", "reader", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;", "parentToken", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken$BeginElement;", "parsedFieldLocations", "", "Laws/smithy/kotlin/runtime/serde/xml/FieldLocation;", "unwrapped", "", "<init>", "(Laws/smithy/kotlin/runtime/serde/SdkObjectDescriptor;Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;Laws/smithy/kotlin/runtime/serde/xml/XmlToken$BeginElement;Ljava/util/List;Z)V", "reentryFlag", "findNextFieldIndex", "", "()Ljava/lang/Integer;", "deserializeValue", "T", "transform", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "skipValue", "", "deserializeByte", "", "deserializeInt", "deserializeShort", "", "deserializeLong", "", "deserializeFloat", "", "deserializeDouble", "", "deserializeBigInteger", "Laws/smithy/kotlin/runtime/content/BigInteger;", "deserializeBigDecimal", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "deserializeString", "deserializeBoolean", "deserializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "deserializeByteArray", "", "deserializeInstant", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "deserializeNull", "", "inNestedMode", "serde-xml"})
@SourceDebugExtension(value={"SMAP\nXmlDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlDeserializer.kt\naws/smithy/kotlin/runtime/serde/xml/XmlStructDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 XmlDeserializer.kt\naws/smithy/kotlin/runtime/serde/xml/XmlDeserializerKt\n*L\n1#1,432:1\n774#2:433\n865#2,2:434\n1611#2,9:436\n1863#2:445\n1864#2:447\n1620#2:448\n1053#2:449\n1611#2,9:476\n1863#2:485\n1864#2:487\n1620#2:488\n1#3:446\n1#3:486\n1#3:489\n419#4,13:450\n419#4,13:463\n419#4,13:490\n*S KotlinDebug\n*F\n+ 1 XmlDeserializer.kt\naws/smithy/kotlin/runtime/serde/xml/XmlStructDeserializer\n*L\n254#1:433\n254#1:434,2\n255#1:436,9\n255#1:445\n255#1:447\n255#1:448\n262#1:449\n291#1:476,9\n291#1:485\n291#1:487\n291#1:488\n255#1:446\n291#1:486\n270#1:450,13\n281#1:463,13\n338#1:490,13\n*E\n"})
final class XmlStructDeserializer
implements Deserializer.FieldIterator {
    @NotNull
    private final SdkObjectDescriptor objDescriptor;
    @NotNull
    private final XmlToken.BeginElement parentToken;
    @NotNull
    private final List<FieldLocation> parsedFieldLocations;
    private final boolean unwrapped;
    private boolean reentryFlag;
    @NotNull
    private final XmlStreamReader reader;

    public XmlStructDeserializer(@NotNull SdkObjectDescriptor objDescriptor, @NotNull XmlStreamReader reader, @NotNull XmlToken.BeginElement parentToken, @NotNull List<FieldLocation> parsedFieldLocations, boolean unwrapped) {
        Intrinsics.checkNotNullParameter((Object)objDescriptor, (String)"objDescriptor");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)parentToken, (String)"parentToken");
        Intrinsics.checkNotNullParameter(parsedFieldLocations, (String)"parsedFieldLocations");
        this.objDescriptor = objDescriptor;
        this.parentToken = parentToken;
        this.parsedFieldLocations = parsedFieldLocations;
        this.unwrapped = unwrapped;
        this.reader = this.unwrapped ? reader : reader.subTreeReader(XmlStreamReader.SubtreeStartDepth.CHILD);
    }

    public /* synthetic */ XmlStructDeserializer(SdkObjectDescriptor sdkObjectDescriptor, XmlStreamReader xmlStreamReader, XmlToken.BeginElement beginElement, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = new ArrayList();
        }
        this(sdkObjectDescriptor, xmlStreamReader, beginElement, list, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Integer findNextFieldIndex() {
        if (this.unwrapped) {
            return XmlStreamReader.DefaultImpls.peek$default(this.reader, 0, 1, null) instanceof XmlToken.Text ? Integer.valueOf(0) : null;
        }
        if (this.inNestedMode()) {
            this.parsedFieldLocations.clear();
        }
        if (this.parsedFieldLocations.isEmpty()) {
            Collection destination$iv$iv;
            XmlToken token = this.reader.nextToken();
            if (token == null || token instanceof XmlToken.EndDocument) {
                return null;
            }
            if (token instanceof XmlToken.EndElement) {
                return this.findNextFieldIndex();
            }
            if (token instanceof XmlToken.BeginElement) {
                void $this$mapNotNullTo$iv$iv;
                void $this$filterTo$iv$iv;
                XmlToken xmlToken = XmlStreamReader.DefaultImpls.peek$default(this.reader, 0, 1, null);
                if (xmlToken == null) {
                    return null;
                }
                XmlToken nextToken = xmlToken;
                List objectFields = this.objDescriptor.getFields();
                Iterable $this$filter$iv = objectFields;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Iterable destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    SdkFieldDescriptor field2 = (SdkFieldDescriptor)element$iv$iv;
                    boolean bl = false;
                    if (!XmlDeserializerKt.access$fieldTokenMatcher(this.objDescriptor, field2, (XmlToken.BeginElement)token)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List memberFields = (List)destination$iv$iv2;
                Iterable $this$mapNotNull$iv = memberFields;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv2 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    FieldLocation it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    SdkFieldDescriptor it = (SdkFieldDescriptor)element$iv$iv;
                    boolean bl2 = false;
                    if (XmlDeserializerKt.access$findFieldLocation(it, (XmlToken.BeginElement)token, nextToken) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
            } else {
                return this.findNextFieldIndex();
            }
            List matchingFields = (List)destination$iv$iv;
            List matchedFieldLocations = matchingFields;
            Iterable $this$sortedBy$iv = matchedFieldLocations;
            boolean $i$f$sortedBy = false;
            this.parsedFieldLocations.addAll(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    FieldLocation it = (FieldLocation)a;
                    boolean bl = false;
                    Comparable comparable = Boolean.valueOf(it instanceof FieldLocation.Text);
                    it = (FieldLocation)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it instanceof FieldLocation.Text));
                }
            }));
        }
        FieldLocation fieldLocation = (FieldLocation)CollectionsKt.firstOrNull(this.parsedFieldLocations);
        return fieldLocation != null ? fieldLocation.getFieldIndex() : -1;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T deserializeValue(Function1<? super String, ? extends T> transform) {
        Object object;
        if (this.unwrapped) {
            XmlStreamReader $this$takeNextAs$iv = this.reader;
            boolean $i$f$takeNextAs = false;
            XmlToken xmlToken = $this$takeNextAs$iv.nextToken();
            if (xmlToken == null) {
                throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.Text.class) + " but instead found null");
            }
            XmlToken token$iv = xmlToken;
            boolean $i$f$requireToken = false;
            if (token$iv.getClass() != XmlToken.Text.class) {
                throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.Text.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()) + " (" + token$iv + ')');
            }
            XmlToken xmlToken2 = token$iv;
            if (xmlToken2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.xml.XmlToken.Text");
            }
            String string = ((XmlToken.Text)((XmlToken)((XmlToken.Text)xmlToken2))).getValue();
            if (string == null) {
                string = "";
            }
            String value = string;
            return (T)transform.invoke((Object)value);
        }
        this.reentryFlag = false;
        if (this.parsedFieldLocations.isEmpty()) {
            throw new DeserializationException("matchedFields is empty, was findNextFieldIndex() called?");
        }
        FieldLocation nextField = (FieldLocation)CollectionsKt.removeFirst(this.parsedFieldLocations);
        if (nextField instanceof FieldLocation.Text) {
            String string;
            XmlToken peekToken = XmlStreamReader.DefaultImpls.peek$default(this.reader, 0, 1, null);
            if (peekToken instanceof XmlToken.Text) {
                XmlStreamReader $this$takeNextAs$iv = this.reader;
                boolean $i$f$takeNextAs = false;
                XmlToken xmlToken = $this$takeNextAs$iv.nextToken();
                if (xmlToken == null) {
                    throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.Text.class) + " but instead found null");
                }
                XmlToken token$iv = xmlToken;
                boolean $i$f$requireToken = false;
                if (token$iv.getClass() != XmlToken.Text.class) {
                    throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.Text.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()) + " (" + token$iv + ')');
                }
                XmlToken xmlToken3 = token$iv;
                if (xmlToken3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.xml.XmlToken.Text");
                }
                string = ((XmlToken.Text)((XmlToken)((XmlToken.Text)xmlToken3))).getValue();
                if (string == null) {
                    string = "";
                }
            } else if (peekToken instanceof XmlToken.EndElement) {
                string = "";
            } else {
                throw new DeserializationException("Unexpected token " + peekToken);
            }
            String value = string;
            object = transform.invoke((Object)value);
        } else if (nextField instanceof FieldLocation.Attribute) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable peekToken = ((FieldLocation.Attribute)nextField).getNames();
            Function1<? super String, ? extends T> function1 = transform;
            boolean $i$f$mapNotNull = false;
            void $this$takeNextAs$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                XmlToken.QualifiedName it = (XmlToken.QualifiedName)element$iv$iv;
                boolean bl2 = false;
                if (this.parentToken.getAttributes().get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            String string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (string == null) {
                throw new DeserializationException("Expected attrib value " + CollectionsKt.first((Iterable)((FieldLocation.Attribute)nextField).getNames()) + " not found in " + this.parentToken.getName());
            }
            object = function1.invoke((Object)string);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (T)object;
    }

    public void skipValue() {
        this.reader.skipNext();
    }

    public byte deserializeByte() {
        return ((Number)this.deserializeValue(XmlStructDeserializer::deserializeByte$lambda$4)).byteValue();
    }

    public int deserializeInt() {
        return ((Number)this.deserializeValue(XmlStructDeserializer::deserializeInt$lambda$5)).intValue();
    }

    public short deserializeShort() {
        return ((Number)this.deserializeValue(XmlStructDeserializer::deserializeShort$lambda$6)).shortValue();
    }

    public long deserializeLong() {
        return ((Number)this.deserializeValue(XmlStructDeserializer::deserializeLong$lambda$7)).longValue();
    }

    public float deserializeFloat() {
        return ((Number)this.deserializeValue(XmlStructDeserializer::deserializeFloat$lambda$8)).floatValue();
    }

    public double deserializeDouble() {
        return ((Number)this.deserializeValue(XmlStructDeserializer::deserializeDouble$lambda$9)).doubleValue();
    }

    @NotNull
    public BigInteger deserializeBigInteger() {
        return (BigInteger)this.deserializeValue(arg_0 -> XmlStructDeserializer.deserializeBigInteger$lambda$12(this, arg_0));
    }

    @NotNull
    public BigDecimal deserializeBigDecimal() {
        return (BigDecimal)this.deserializeValue(arg_0 -> XmlStructDeserializer.deserializeBigDecimal$lambda$15(this, arg_0));
    }

    @NotNull
    public String deserializeString() {
        return (String)this.deserializeValue(XmlStructDeserializer::deserializeString$lambda$16);
    }

    public boolean deserializeBoolean() {
        return (Boolean)this.deserializeValue(XmlStructDeserializer::deserializeBoolean$lambda$17);
    }

    @NotNull
    public Document deserializeDocument() {
        throw new DeserializationException("cannot deserialize unsupported Document type in xml");
    }

    @NotNull
    public byte[] deserializeByteArray() {
        return Base64Kt.decodeBase64Bytes((String)this.deserializeString());
    }

    @NotNull
    public Instant deserializeInstant(@NotNull TimestampFormat format) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                String it = this.deserializeString();
                boolean bl = false;
                instant = Instant.Companion.fromEpochSeconds(it);
                break;
            }
            case 2: {
                String it = this.deserializeString();
                boolean bl = false;
                instant = Instant.Companion.fromIso8601(it);
                break;
            }
            case 3: {
                String it = this.deserializeString();
                boolean bl = false;
                instant = Instant.Companion.fromRfc5322(it);
                break;
            }
            default: {
                throw new DeserializationException("unknown timestamp format: " + format);
            }
        }
        return instant;
    }

    @Nullable
    public Void deserializeNull() {
        XmlStreamReader $this$takeNextAs$iv = this.reader;
        boolean $i$f$takeNextAs = false;
        XmlToken xmlToken = $this$takeNextAs$iv.nextToken();
        if (xmlToken == null) {
            throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.EndElement.class) + " but instead found null");
        }
        XmlToken token$iv = xmlToken;
        boolean $i$f$requireToken = false;
        if (token$iv.getClass() != XmlToken.EndElement.class) {
            throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.EndElement.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()) + " (" + token$iv + ')');
        }
        XmlToken xmlToken2 = token$iv;
        if (xmlToken2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.xml.XmlToken.EndElement");
        }
        XmlToken cfr_ignored_0 = (XmlToken.EndElement)xmlToken2;
        return null;
    }

    private final boolean inNestedMode() {
        boolean bl;
        boolean bl2 = this.reentryFlag;
        if (bl2) {
            bl = true;
        } else if (!bl2) {
            this.reentryFlag = true;
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private static final byte deserializeByte$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Integer n = StringsKt.toIntOrNull((String)it);
        if (n == null) {
            throw new DeserializationException("Unable to deserialize " + it);
        }
        return (byte)n.intValue();
    }

    private static final int deserializeInt$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Integer n = StringsKt.toIntOrNull((String)it);
        if (n == null) {
            throw new DeserializationException("Unable to deserialize " + it);
        }
        return n;
    }

    private static final short deserializeShort$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Integer n = StringsKt.toIntOrNull((String)it);
        if (n == null) {
            throw new DeserializationException("Unable to deserialize " + it);
        }
        return (short)n.intValue();
    }

    private static final long deserializeLong$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Long l = StringsKt.toLongOrNull((String)it);
        if (l == null) {
            throw new DeserializationException("Unable to deserialize " + it);
        }
        return l;
    }

    private static final float deserializeFloat$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Float f = StringsKt.toFloatOrNull((String)it);
        if (f == null) {
            throw new DeserializationException("Unable to deserialize " + it);
        }
        return f.floatValue();
    }

    private static final double deserializeDouble$lambda$9(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Double d = StringsKt.toDoubleOrNull((String)it);
        if (d == null) {
            throw new DeserializationException("Unable to deserialize " + it);
        }
        return d;
    }

    private static final BigInteger deserializeBigInteger$lambda$12(XmlStructDeserializer this$0, String it) {
        Object $this$deserializeBigInteger_u24lambda_u2412_u24lambda_u2410;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0;
        try {
            $this$deserializeBigInteger_u24lambda_u2412_u24lambda_u2410 = object;
            boolean bl = false;
            $this$deserializeBigInteger_u24lambda_u2412_u24lambda_u2410 = Result.constructor-impl((Object)new BigInteger(it));
        }
        catch (Throwable bl) {
            $this$deserializeBigInteger_u24lambda_u2412_u24lambda_u2410 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$deserializeBigInteger_u24lambda_u2412_u24lambda_u2410;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it2 = throwable;
            boolean bl = false;
            throw new DeserializationException("Unable to deserialize " + it2 + " as BigInteger");
        }
        return (BigInteger)object;
    }

    private static final BigDecimal deserializeBigDecimal$lambda$15(XmlStructDeserializer this$0, String it) {
        Object $this$deserializeBigDecimal_u24lambda_u2415_u24lambda_u2413;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0;
        try {
            $this$deserializeBigDecimal_u24lambda_u2415_u24lambda_u2413 = object;
            boolean bl = false;
            $this$deserializeBigDecimal_u24lambda_u2415_u24lambda_u2413 = Result.constructor-impl((Object)new BigDecimal(it));
        }
        catch (Throwable bl) {
            $this$deserializeBigDecimal_u24lambda_u2415_u24lambda_u2413 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$deserializeBigDecimal_u24lambda_u2415_u24lambda_u2413;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it2 = throwable;
            boolean bl = false;
            throw new DeserializationException("Unable to deserialize " + it2 + " as BigDecimal");
        }
        return (BigDecimal)object;
    }

    private static final String deserializeString$lambda$16(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final boolean deserializeBoolean$lambda$17(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Boolean.parseBoolean(it);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimestampFormat.values().length];
            try {
                nArray[TimestampFormat.EPOCH_SECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.ISO_8601.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.RFC_5322.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

