/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml.serialization;

import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import aws.smithy.kotlin.runtime.serde.xml.serialization.LazyTagWriterKt;
import aws.smithy.kotlin.runtime.serde.xml.serialization.TagChild;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\nJ\u0012\u0010\"\u001a\u00020\u001d2\n\u0010#\u001a\u00060$j\u0002`%J\u001c\u0010&\u001a\u00060$j\u0002`%*\u00060$j\u0002`%2\u0006\u0010!\u001a\u00020\nH\u0002J\u0014\u0010'\u001a\u00060$j\u0002`%*\u00060$j\u0002`%H\u0002J\u001c\u0010(\u001a\u00060$j\u0002`%*\u00060$j\u0002`%2\u0006\u0010!\u001a\u00020\nH\u0002J\u001c\u0010)\u001a\u00060$j\u0002`%*\u00060$j\u0002`%2\u0006\u0010!\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/serialization/LazyTagWriter;", "", "pretty", "", "indentLevel", "", "qName", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken$QualifiedName;", "nsAttributes", "", "", "<init>", "(ZILaws/smithy/kotlin/runtime/serde/xml/XmlToken$QualifiedName;Ljava/util/Map;)V", "getPretty", "()Z", "getIndentLevel", "()I", "getQName", "()Laws/smithy/kotlin/runtime/serde/xml/XmlToken$QualifiedName;", "getNsAttributes", "()Ljava/util/Map;", "attributes", "", "children", "", "Laws/smithy/kotlin/runtime/serde/xml/serialization/TagChild;", "tagIndentationSpace", "textIndentationSpace", "attribute", "", "value", "childTag", "childWriter", "text", "write", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendIfPretty", "appendLineIfPretty", "appendXmlEscaped", "appendXmlEscapedForAttribute", "serde-xml"})
@SourceDebugExtension(value={"SMAP\nLazyTagWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyTagWriter.kt\naws/smithy/kotlin/runtime/serde/xml/serialization/LazyTagWriter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,183:1\n216#2,2:184\n1863#3,2:186\n1179#4,2:188\n1179#4,2:190\n*S KotlinDebug\n*F\n+ 1 LazyTagWriter.kt\naws/smithy/kotlin/runtime/serde/xml/serialization/LazyTagWriter\n*L\n72#1:184,2\n114#1:186,2\n148#1:188,2\n163#1:190,2\n*E\n"})
public final class LazyTagWriter {
    private final boolean pretty;
    private final int indentLevel;
    @NotNull
    private final XmlToken.QualifiedName qName;
    @NotNull
    private final Map<XmlToken.QualifiedName, String> nsAttributes;
    @NotNull
    private final Map<XmlToken.QualifiedName, String> attributes;
    @NotNull
    private final List<TagChild> children;
    @NotNull
    private final String tagIndentationSpace;
    @NotNull
    private final String textIndentationSpace;

    public LazyTagWriter(boolean pretty, int indentLevel, @NotNull XmlToken.QualifiedName qName, @NotNull Map<XmlToken.QualifiedName, String> nsAttributes) {
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        Intrinsics.checkNotNullParameter(nsAttributes, (String)"nsAttributes");
        this.pretty = pretty;
        this.indentLevel = indentLevel;
        this.qName = qName;
        this.nsAttributes = nsAttributes;
        this.attributes = new LinkedHashMap();
        this.children = new ArrayList();
        this.tagIndentationSpace = StringsKt.repeat((CharSequence)"    ", (int)this.indentLevel);
        this.textIndentationSpace = StringsKt.repeat((CharSequence)"    ", (int)(this.indentLevel + 1));
        this.attributes.putAll(this.nsAttributes);
    }

    public final boolean getPretty() {
        return this.pretty;
    }

    public final int getIndentLevel() {
        return this.indentLevel;
    }

    @NotNull
    public final XmlToken.QualifiedName getQName() {
        return this.qName;
    }

    @NotNull
    public final Map<XmlToken.QualifiedName, String> getNsAttributes() {
        return this.nsAttributes;
    }

    public final void attribute(@NotNull XmlToken.QualifiedName qName, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        this.attributes.put(qName, value);
    }

    public final void childTag(@NotNull LazyTagWriter childWriter) {
        Intrinsics.checkNotNullParameter((Object)childWriter, (String)"childWriter");
        this.children.add(new TagChild.Tag(childWriter));
    }

    public final void text(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.children.add(new TagChild.Text(text));
    }

    public final void write(@NotNull StringBuilder buffer) {
        StringBuilder stringBuilder;
        Map.Entry<XmlToken.QualifiedName, String> element$iv;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.appendIfPretty(buffer, this.tagIndentationSpace).append('<').append(this.qName);
        Object $this$forEach$iv = this.attributes;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<XmlToken.QualifiedName, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<XmlToken.QualifiedName, String> e = element$iv = iterator.next();
            boolean bl = false;
            buffer.append(' ').append(e.getKey()).append("=\"");
            String value = e.getValue();
            if (value != null) {
                this.appendXmlEscapedForAttribute(buffer, value);
            }
            buffer.append('\"');
        }
        if (this.children.isEmpty()) {
            StringBuilder stringBuilder2 = this.appendIfPretty(buffer, " ").append("/>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            stringBuilder = this.appendLineIfPretty(stringBuilder2);
        } else if (this.children.size() == 1 && CollectionsKt.first(this.children) instanceof TagChild.Text) {
            StringBuilder stringBuilder3 = buffer.append('>');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Object object = CollectionsKt.first(this.children);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.xml.serialization.TagChild.Text");
            $this$forEach$iv = this.appendXmlEscaped(stringBuilder3, ((TagChild.Text)object).getText()).append("</").append(this.qName).append('>');
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"append(...)");
            stringBuilder = this.appendLineIfPretty((StringBuilder)$this$forEach$iv);
        } else {
            StringBuilder stringBuilder4 = buffer.append('>');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            this.appendLineIfPretty(stringBuilder4);
            $this$forEach$iv = this.children;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                TagChild child = (TagChild)((Object)element$iv);
                boolean bl = false;
                TagChild tagChild = child;
                if (tagChild instanceof TagChild.Text) {
                    this.appendLineIfPretty(this.appendXmlEscaped(this.appendIfPretty(buffer, this.textIndentationSpace), ((TagChild.Text)child).getText()));
                    continue;
                }
                if (tagChild instanceof TagChild.Tag) {
                    ((TagChild.Tag)child).getLazyTagWriter().write(buffer);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            StringBuilder stringBuilder5 = this.appendIfPretty(buffer, this.tagIndentationSpace).append("</").append(this.qName).append('>');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            stringBuilder = this.appendLineIfPretty(stringBuilder5);
        }
    }

    private final StringBuilder appendIfPretty(StringBuilder $this$appendIfPretty, String text) {
        if (this.pretty) {
            $this$appendIfPretty.append(text);
        }
        return $this$appendIfPretty;
    }

    private final StringBuilder appendLineIfPretty(StringBuilder $this$appendLineIfPretty) {
        if (this.pretty) {
            $this$appendLineIfPretty.append('\n');
        }
        return $this$appendLineIfPretty;
    }

    private final StringBuilder appendXmlEscaped(StringBuilder $this$appendXmlEscaped, String text) {
        CharSequence $this$forEach$iv = text;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            StringBuilder stringBuilder;
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            char c2 = c;
            if (c2 == '<') {
                stringBuilder = $this$appendXmlEscaped.append("&lt;");
                continue;
            }
            if (c2 == '>') {
                stringBuilder = $this$appendXmlEscaped.append("&gt;");
                continue;
            }
            if (c2 == '&') {
                stringBuilder = $this$appendXmlEscaped.append("&amp;");
                continue;
            }
            stringBuilder = ('\u0000' <= c2 ? c2 < ' ' : false) ? $this$appendXmlEscaped.append("&#x" + LazyTagWriterKt.access$hexCode(c) + ';') : (c2 == '\u0085' ? $this$appendXmlEscaped.append("&#x85;") : (c2 == '\u2028' ? $this$appendXmlEscaped.append("&#x2028;") : $this$appendXmlEscaped.append(c)));
        }
        return $this$appendXmlEscaped;
    }

    private final StringBuilder appendXmlEscapedForAttribute(StringBuilder $this$appendXmlEscapedForAttribute, String text) {
        CharSequence $this$forEach$iv = text;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            StringBuilder stringBuilder;
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            char c2 = c;
            if (c2 == '<') {
                stringBuilder = $this$appendXmlEscapedForAttribute.append("&lt;");
                continue;
            }
            if (c2 == '>') {
                stringBuilder = $this$appendXmlEscapedForAttribute.append("&gt;");
                continue;
            }
            if (c2 == '&') {
                stringBuilder = $this$appendXmlEscapedForAttribute.append("&amp;");
                continue;
            }
            if (c2 == '\"') {
                stringBuilder = $this$appendXmlEscapedForAttribute.append("&quot;");
                continue;
            }
            stringBuilder = ('\u0000' <= c2 ? c2 < ' ' : false) ? $this$appendXmlEscapedForAttribute.append("&#x" + LazyTagWriterKt.access$hexCode(c) + ';') : (c2 == '\u0085' ? $this$appendXmlEscapedForAttribute.append("&#x85;") : (c2 == '\u2028' ? $this$appendXmlEscapedForAttribute.append("&#x2028;") : $this$appendXmlEscapedForAttribute.append(c)));
        }
        return $this$appendXmlEscapedForAttribute;
    }
}

