/*
 * Decompiled with CFR 0.152.
 */
package band.wukong.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtil {
    public static final String FMT_YYYYMMDDHHMMSS_NO_SEP = "yyyyMMddHHmmSS";
    public static final String FMT_YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String FMT_YYYYMMDD = "yyyy-MM-dd";
    public static final String FMT_YYYYMMDD_NO_SEP = "yyyyMMdd";

    public static String format(Date date, String type) {
        if (null == date) {
            return "";
        }
        String strDate = "";
        SimpleDateFormat fmt = null;
        try {
            fmt = new SimpleDateFormat(type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return strDate;
        }
        strDate = fmt.format(date);
        return strDate;
    }

    public static String format(Date date) {
        if (null == date) {
            return "";
        }
        return DateUtil.format(date, FMT_YYYYMMDD);
    }

    public static Date parse(String date) {
        String re_yymmdd = "^([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]|[0-9][1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8])))$";
        if (date.matches(re_yymmdd)) {
            try {
                return new SimpleDateFormat(FMT_YYYYMMDD).parse(date);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        String re_yymmdd_hhmmss = "^([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]|[0-9][1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8])))\\p{Space}[0-2][0-9]:[0-5][0-9]:[0-5][0-9]$";
        if (date.matches(re_yymmdd_hhmmss)) {
            try {
                return new SimpleDateFormat(FMT_YYYYMMDDHHMMSS).parse(date);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        String re_yymmdd_no_sep = "^([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]|[0-9][1-9][0-9]{2}|[1-9][0-9]{3})(((0[13578]|1[02])(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8])))$";
        if (date.matches(re_yymmdd_no_sep)) {
            try {
                return new SimpleDateFormat(FMT_YYYYMMDD_NO_SEP).parse(date);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("\u4f20\u5165\u53c2\u6570\u683c\u5f0f\u4e0d\u652f\u6301\u3002date=" + date);
    }

    public static boolean isSameDay(Date d1, Date d2) {
        return DateUtil.format(d1).equals(DateUtil.format(d2));
    }
}

