/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.apps.rasterizer.DefaultSVGConverterController;
import org.apache.batik.apps.rasterizer.DestinationType;
import org.apache.batik.apps.rasterizer.SVGConverterController;
import org.apache.batik.apps.rasterizer.SVGConverterException;
import org.apache.batik.apps.rasterizer.SVGConverterFileSource;
import org.apache.batik.apps.rasterizer.SVGConverterSource;
import org.apache.batik.apps.rasterizer.SVGConverterURLSource;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class SVGConverter {
    public static final String ERROR_NO_SOURCES_SPECIFIED = "SVGConverter.error.no.sources.specified";
    public static final String ERROR_CANNOT_COMPUTE_DESTINATION = "SVGConverter.error.cannot.compute.destination";
    public static final String ERROR_CANNOT_USE_DST_FILE = "SVGConverter.error.cannot.use.dst.file";
    public static final String ERROR_CANNOT_ACCESS_TRANSCODER = "SVGConverter.error.cannot.access.transcoder";
    public static final String ERROR_SOURCE_SAME_AS_DESTINATION = "SVGConverter.error.source.same.as.destination";
    public static final String ERROR_CANNOT_READ_SOURCE = "SVGConverter.error.cannot.read.source";
    public static final String ERROR_CANNOT_OPEN_SOURCE = "SVGConverter.error.cannot.open.source";
    public static final String ERROR_OUTPUT_NOT_WRITEABLE = "SVGConverter.error.output.not.writeable";
    public static final String ERROR_CANNOT_OPEN_OUTPUT_FILE = "SVGConverter.error.cannot.open.output.file";
    public static final String ERROR_UNABLE_TO_CREATE_OUTPUT_DIR = "SVGConverter.error.unable.to.create.output.dir";
    public static final String ERROR_WHILE_RASTERIZING_FILE = "SVGConverter.error.while.rasterizing.file";
    protected static final String SVG_EXTENSION = ".svg";
    protected static final float DEFAULT_QUALITY = -1.0f;
    protected static final float MAXIMUM_QUALITY = 0.99f;
    protected static final DestinationType DEFAULT_RESULT_TYPE = DestinationType.PNG;
    protected static final float DEFAULT_WIDTH = -1.0f;
    protected static final float DEFAULT_HEIGHT = -1.0f;
    protected DestinationType destinationType = DEFAULT_RESULT_TYPE;
    protected float height = -1.0f;
    protected float width = -1.0f;
    protected float maxHeight = -1.0f;
    protected float maxWidth = -1.0f;
    protected float quality = -1.0f;
    protected int indexed = -1;
    protected Rectangle2D area = null;
    protected String language = null;
    protected String userStylesheet = null;
    protected float pixelUnitToMillimeter = -1.0f;
    protected boolean validate = false;
    protected boolean executeOnload = false;
    protected String allowedScriptTypes = null;
    protected boolean constrainScriptOrigin = true;
    protected boolean securityOff = false;
    protected Vector sources = null;
    protected File dst;
    protected Color backgroundColor = null;
    protected String mediaType = null;
    protected String defaultFontFamily = null;
    protected String alternateStylesheet = null;
    protected Vector files = new Vector();
    protected SVGConverterController controller;

    public SVGConverter() {
        this(new DefaultSVGConverterController());
    }

    public SVGConverter(SVGConverterController sVGConverterController) {
        if (sVGConverterController == null) {
            throw new IllegalArgumentException();
        }
        this.controller = sVGConverterController;
    }

    public void setDestinationType(DestinationType destinationType) {
        if (destinationType == null) {
            throw new IllegalArgumentException();
        }
        this.destinationType = destinationType;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public float getHeight() {
        return this.height;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getWidth() {
        return this.width;
    }

    public void setMaxHeight(float f) {
        this.maxHeight = f;
    }

    public float getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxWidth(float f) {
        this.maxWidth = f;
    }

    public float getMaxWidth() {
        return this.maxWidth;
    }

    public void setQuality(float f) throws IllegalArgumentException {
        if (f >= 1.0f) {
            throw new IllegalArgumentException();
        }
        this.quality = f;
    }

    public float getQuality() {
        return this.quality;
    }

    public void setIndexed(int n) throws IllegalArgumentException {
        this.indexed = n;
    }

    public int getIndexed() {
        return this.indexed;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setUserStylesheet(String string) {
        this.userStylesheet = string;
    }

    public String getUserStylesheet() {
        return this.userStylesheet;
    }

    public void setPixelUnitToMillimeter(float f) {
        this.pixelUnitToMillimeter = f;
    }

    public float getPixelUnitToMillimeter() {
        return this.pixelUnitToMillimeter;
    }

    public void setArea(Rectangle2D rectangle2D) {
        this.area = rectangle2D;
    }

    public Rectangle2D getArea() {
        return this.area;
    }

    public void setSources(String[] stringArray) {
        if (stringArray == null) {
            this.sources = null;
        } else {
            this.sources = new Vector();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    this.sources.addElement(stringArray[n]);
                }
                ++n;
            }
            if (this.sources.size() == 0) {
                this.sources = null;
            }
        }
    }

    public Vector getSources() {
        return this.sources;
    }

    public void setDst(File file) {
        this.dst = file;
    }

    public File getDst() {
        return this.dst;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setMediaType(String string) {
        this.mediaType = string;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setDefaultFontFamily(String string) {
        this.defaultFontFamily = string;
    }

    public String getDefaultFontFamily() {
        return this.defaultFontFamily;
    }

    public void setAlternateStylesheet(String string) {
        this.alternateStylesheet = string;
    }

    public String getAlternateStylesheet() {
        return this.alternateStylesheet;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setExecuteOnload(boolean bl) {
        this.executeOnload = bl;
    }

    public boolean getExecuteOnload() {
        return this.executeOnload;
    }

    public void setAllowedScriptTypes(String string) {
        this.allowedScriptTypes = string;
    }

    public String getAllowedScriptTypes() {
        return this.allowedScriptTypes;
    }

    public void setConstrainScriptOrigin(boolean bl) {
        this.constrainScriptOrigin = bl;
    }

    public boolean getConstrainScriptOrigin() {
        return this.constrainScriptOrigin;
    }

    public void setSecurityOff(boolean bl) {
        this.securityOff = bl;
    }

    public boolean getSecurityOff() {
        return this.securityOff;
    }

    protected boolean isFile(File file) {
        if (file.exists()) {
            return file.isFile();
        }
        return file.toString().toLowerCase().endsWith(this.destinationType.getExtension());
    }

    public void execute() throws SVGConverterException {
        Vector vector = this.computeSources();
        Vector<File> vector2 = null;
        if (vector.size() == 1 && this.dst != null && this.isFile(this.dst)) {
            vector2 = new Vector<File>();
            vector2.addElement(this.dst);
        } else {
            vector2 = this.computeDstFiles(vector);
        }
        Transcoder transcoder = this.destinationType.getTranscoder();
        if (transcoder == null) {
            throw new SVGConverterException(ERROR_CANNOT_ACCESS_TRANSCODER, new Object[]{this.destinationType.toString()}, true);
        }
        Map map = this.computeTranscodingHints();
        transcoder.setTranscodingHints(map);
        if (!this.controller.proceedWithComputedTask(transcoder, map, vector, vector2)) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            SVGConverterSource sVGConverterSource = (SVGConverterSource)vector.elementAt(n);
            File file = (File)vector2.elementAt(n);
            this.createOutputDir(file);
            this.transcode(sVGConverterSource, file, transcoder);
            ++n;
        }
    }

    protected Vector computeDstFiles(Vector vector) throws SVGConverterException {
        Vector<File> vector2 = new Vector<File>();
        if (this.dst != null) {
            if (this.dst.exists() && this.dst.isFile()) {
                throw new SVGConverterException(ERROR_CANNOT_USE_DST_FILE);
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                SVGConverterSource sVGConverterSource = (SVGConverterSource)vector.elementAt(n2);
                File file = new File(this.dst.getPath(), this.getDestinationFile(sVGConverterSource.getName()));
                vector2.addElement(file);
                ++n2;
            }
        } else {
            int n = vector.size();
            int n3 = 0;
            while (n3 < n) {
                SVGConverterSource sVGConverterSource = (SVGConverterSource)vector.elementAt(n3);
                if (!(sVGConverterSource instanceof SVGConverterFileSource)) {
                    throw new SVGConverterException(ERROR_CANNOT_COMPUTE_DESTINATION, new Object[]{sVGConverterSource});
                }
                SVGConverterFileSource sVGConverterFileSource = (SVGConverterFileSource)sVGConverterSource;
                File file = new File(sVGConverterFileSource.getFile().getParent(), this.getDestinationFile(sVGConverterSource.getName()));
                vector2.addElement(file);
                ++n3;
            }
        }
        return vector2;
    }

    protected Vector computeSources() throws SVGConverterException {
        Vector<SVGConverterSource> vector = new Vector<SVGConverterSource>();
        if (this.sources == null) {
            throw new SVGConverterException(ERROR_NO_SOURCES_SPECIFIED);
        }
        int n = this.sources.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.sources.elementAt(n2);
            File file = new File(string);
            if (file.exists()) {
                vector.addElement(new SVGConverterFileSource(file));
            } else {
                String[] stringArray = this.getFileNRef(string);
                file = new File(stringArray[0]);
                if (file.exists()) {
                    vector.addElement(new SVGConverterFileSource(file, stringArray[1]));
                } else {
                    vector.addElement(new SVGConverterURLSource(string));
                }
            }
            ++n2;
        }
        return vector;
    }

    public String[] getFileNRef(String string) {
        int n = string.lastIndexOf("#");
        String[] stringArray = new String[]{string, ""};
        if (n > -1) {
            stringArray[0] = string.substring(0, n);
            if (n + 1 < string.length()) {
                stringArray[1] = string.substring(n + 1);
            }
        }
        return stringArray;
    }

    protected Map computeTranscodingHints() {
        HashMap<TranscodingHints.Key, Object> hashMap = new HashMap<TranscodingHints.Key, Object>();
        if (this.area != null) {
            hashMap.put(SVGAbstractTranscoder.KEY_AOI, this.area);
        }
        if (this.quality > 0.0f) {
            hashMap.put(JPEGTranscoder.KEY_QUALITY, new Float(this.quality));
        }
        if (this.indexed != -1) {
            hashMap.put(PNGTranscoder.KEY_INDEXED, new Integer(this.indexed));
        }
        if (this.backgroundColor != null) {
            hashMap.put(ImageTranscoder.KEY_BACKGROUND_COLOR, this.backgroundColor);
        }
        if (this.height > 0.0f) {
            hashMap.put(SVGAbstractTranscoder.KEY_HEIGHT, new Float(this.height));
        }
        if (this.width > 0.0f) {
            hashMap.put(SVGAbstractTranscoder.KEY_WIDTH, new Float(this.width));
        }
        if (this.maxHeight > 0.0f) {
            hashMap.put(SVGAbstractTranscoder.KEY_MAX_HEIGHT, new Float(this.maxHeight));
        }
        if (this.maxWidth > 0.0f) {
            hashMap.put(SVGAbstractTranscoder.KEY_MAX_WIDTH, new Float(this.maxWidth));
        }
        if (this.mediaType != null) {
            hashMap.put(SVGAbstractTranscoder.KEY_MEDIA, this.mediaType);
        }
        if (this.defaultFontFamily != null) {
            hashMap.put(SVGAbstractTranscoder.KEY_DEFAULT_FONT_FAMILY, this.defaultFontFamily);
        }
        if (this.alternateStylesheet != null) {
            hashMap.put(SVGAbstractTranscoder.KEY_ALTERNATE_STYLESHEET, this.alternateStylesheet);
        }
        if (this.userStylesheet != null) {
            hashMap.put(SVGAbstractTranscoder.KEY_USER_STYLESHEET_URI, this.userStylesheet);
        }
        if (this.language != null) {
            hashMap.put(SVGAbstractTranscoder.KEY_LANGUAGE, this.language);
        }
        if (this.pixelUnitToMillimeter > 0.0f) {
            hashMap.put(SVGAbstractTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, new Float(this.pixelUnitToMillimeter));
        }
        if (this.validate) {
            hashMap.put(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, new Boolean(this.validate));
        }
        if (this.executeOnload) {
            hashMap.put(SVGAbstractTranscoder.KEY_EXECUTE_ONLOAD, new Boolean(this.executeOnload));
        }
        if (this.allowedScriptTypes != null) {
            hashMap.put(SVGAbstractTranscoder.KEY_ALLOWED_SCRIPT_TYPES, this.allowedScriptTypes);
        }
        if (!this.constrainScriptOrigin) {
            hashMap.put(SVGAbstractTranscoder.KEY_CONSTRAIN_SCRIPT_ORIGIN, new Boolean(this.constrainScriptOrigin));
        }
        return hashMap;
    }

    protected void transcode(SVGConverterSource sVGConverterSource, File file, Transcoder transcoder) throws SVGConverterException {
        boolean bl;
        FileOutputStream fileOutputStream;
        block18: {
            TranscoderInput transcoderInput = null;
            TranscoderOutput transcoderOutput = null;
            fileOutputStream = null;
            if (!this.controller.proceedWithSourceTranscoding(sVGConverterSource, file)) {
                return;
            }
            try {
                if (sVGConverterSource.isSameAs(file.getPath())) {
                    throw new SVGConverterException(ERROR_SOURCE_SAME_AS_DESTINATION, true);
                }
                if (!sVGConverterSource.isReadable()) {
                    throw new SVGConverterException(ERROR_CANNOT_READ_SOURCE, new Object[]{sVGConverterSource.getName()});
                }
                try {
                    InputStream inputStream = sVGConverterSource.openStream();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new SVGConverterException(ERROR_CANNOT_OPEN_SOURCE, new Object[]{sVGConverterSource.getName(), iOException.toString()});
                }
                transcoderInput = new TranscoderInput(sVGConverterSource.getURI());
                if (!this.isWriteable(file)) {
                    throw new SVGConverterException(ERROR_OUTPUT_NOT_WRITEABLE, new Object[]{file.getName()});
                }
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new SVGConverterException(ERROR_CANNOT_OPEN_OUTPUT_FILE, new Object[]{file.getName()});
                }
                transcoderOutput = new TranscoderOutput((OutputStream)fileOutputStream);
            }
            catch (SVGConverterException sVGConverterException) {
                boolean bl2 = this.controller.proceedOnSourceTranscodingFailure(sVGConverterSource, file, sVGConverterException.getErrorCode());
                if (bl2) {
                    return;
                }
                throw sVGConverterException;
            }
            bl = false;
            try {
                transcoder.transcode(transcoderInput, transcoderOutput);
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                boolean bl3 = this.controller.proceedOnSourceTranscodingFailure(sVGConverterSource, file, ERROR_WHILE_RASTERIZING_FILE);
                if (bl3) break block18;
                throw new SVGConverterException(ERROR_WHILE_RASTERIZING_FILE, new Object[]{file.getName(), exception.getMessage()});
            }
        }
        try {
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            return;
        }
        if (bl) {
            this.controller.onSourceTranscodingSuccess(sVGConverterSource, file);
        }
    }

    protected String getDestinationFile(String string) {
        String string2 = this.destinationType.getExtension();
        String string3 = string;
        int n = string3.lastIndexOf(".");
        String string4 = null;
        string4 = n != -1 ? new String(string3.substring(0, n) + string2) : new String(string3 + string2);
        return string4;
    }

    protected void createOutputDir(File file) throws SVGConverterException {
        boolean bl = true;
        String string = file.getParent();
        if (string != null) {
            File file2 = new File(file.getParent());
            if (!file2.exists()) {
                bl = file2.mkdirs();
            } else if (!file2.isDirectory()) {
                bl = file2.mkdirs();
            }
        }
        if (!bl) {
            throw new SVGConverterException(ERROR_UNABLE_TO_CREATE_OUTPUT_DIR);
        }
    }

    protected boolean isWriteable(File file) {
        if (file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public static class SVGFileFilter
    implements FileFilter {
        public static final String SVG_EXTENSION = ".svg";

        public boolean accept(File file) {
            return file != null && file.getName().toLowerCase().endsWith(".svg");
        }
    }
}

