/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart.dataset;

import be.ceau.chart.color.Color;
import be.ceau.chart.dataset.Dataset;
import be.ceau.chart.objects.OptionalArray;
import java.util.Arrays;
import java.util.List;

public abstract class BackgroundBorderHoverDataset<T extends BackgroundBorderHoverDataset<T, O>, O>
extends Dataset<T, O> {
    protected final List<Color> backgroundColor = new OptionalArray<Color>();
    protected final List<Color> borderColor = new OptionalArray<Color>();
    protected final List<Integer> borderWidth = new OptionalArray<Integer>();
    protected final List<Color> hoverBackgroundColor = new OptionalArray<Color>();
    protected final List<Color> hoverBorderColor = new OptionalArray<Color>();
    protected final List<Integer> hoverBorderWidth = new OptionalArray<Integer>();

    public List<Color> getBackgroundColor() {
        return this.backgroundColor;
    }

    public T addBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null) {
            this.backgroundColor.add(backgroundColor);
        }
        return (T)this;
    }

    public T addBackgroundColors(Color ... backgroundColors) {
        if (backgroundColors != null) {
            this.backgroundColor.addAll(Arrays.asList(backgroundColors));
        }
        return (T)this;
    }

    public T setBackgroundColor(Color backgroundColor) {
        this.backgroundColor.clear();
        this.addBackgroundColor(backgroundColor);
        return (T)this;
    }

    public T setBackgroundColor(List<Color> backgroundColor) {
        this.backgroundColor.clear();
        if (backgroundColor != null) {
            this.backgroundColor.addAll(backgroundColor);
        }
        return (T)this;
    }

    public List<Color> getBorderColor() {
        return this.borderColor;
    }

    public T addBorderColor(Color borderColor) {
        if (borderColor != null) {
            this.borderColor.add(borderColor);
        }
        return (T)this;
    }

    public T addBorderColors(Color ... borderColors) {
        if (borderColors != null) {
            this.borderColor.addAll(Arrays.asList(borderColors));
        }
        return (T)this;
    }

    public T setBorderColor(Color borderColor) {
        this.borderColor.clear();
        this.addBorderColor(borderColor);
        return (T)this;
    }

    public T setBorderColor(List<Color> borderColor) {
        this.borderColor.clear();
        if (borderColor != null) {
            this.borderColor.addAll(borderColor);
        }
        return (T)this;
    }

    public List<Integer> getBorderWidth() {
        return this.borderWidth;
    }

    public T addBorderWidth(Integer borderWidth) {
        if (borderWidth != null) {
            this.borderWidth.add(borderWidth);
        }
        return (T)this;
    }

    public T setBorderWidth(Integer borderWidth) {
        this.borderWidth.clear();
        this.addBorderWidth(borderWidth);
        return (T)this;
    }

    public T setBorderWidth(List<Integer> borderWidth) {
        this.borderWidth.clear();
        if (borderWidth != null) {
            this.borderWidth.addAll(borderWidth);
        }
        return (T)this;
    }

    public List<Color> getHoverBackgroundColor() {
        return this.hoverBackgroundColor;
    }

    public T addHoverBackgroundColor(Color hoverBackgroundColor) {
        if (hoverBackgroundColor != null) {
            this.hoverBackgroundColor.add(hoverBackgroundColor);
        }
        return (T)this;
    }

    public T setHoverBackgroundColor(Color hoverBackgroundColor) {
        this.hoverBackgroundColor.clear();
        this.addHoverBackgroundColor(hoverBackgroundColor);
        return (T)this;
    }

    public T setHoverBackgroundColor(List<Color> hoverBackgroundColor) {
        this.hoverBackgroundColor.clear();
        if (hoverBackgroundColor != null) {
            this.hoverBackgroundColor.addAll(hoverBackgroundColor);
        }
        return (T)this;
    }

    public List<Color> getHoverBorderColor() {
        return this.hoverBorderColor;
    }

    public T addHoverBorderColor(Color hoverBorderColor) {
        if (hoverBorderColor != null) {
            this.hoverBorderColor.add(hoverBorderColor);
        }
        return (T)this;
    }

    public T setHoverBorderColor(Color hoverBorderColor) {
        this.hoverBorderColor.clear();
        this.addHoverBorderColor(hoverBorderColor);
        return (T)this;
    }

    public T setHoverBorderColor(List<Color> hoverBorderColor) {
        this.hoverBorderColor.clear();
        if (hoverBorderColor != null) {
            this.hoverBorderColor.addAll(hoverBorderColor);
        }
        return (T)this;
    }

    public List<Integer> getHoverBorderWidth() {
        return this.hoverBorderWidth;
    }

    public T addHoverBorderWidth(Integer hoverBorderWidth) {
        if (hoverBorderWidth != null) {
            this.hoverBorderWidth.add(hoverBorderWidth);
        }
        return (T)this;
    }

    public T setHoverBorderWidth(Integer hoverBorderWidth) {
        this.hoverBorderWidth.clear();
        this.addHoverBorderWidth(hoverBorderWidth);
        return (T)this;
    }

    public T setHoverBorderWidth(List<Integer> hoverBorderWidth) {
        this.hoverBorderWidth.clear();
        if (hoverBorderWidth != null) {
            this.hoverBorderWidth.addAll(hoverBorderWidth);
        }
        return (T)this;
    }
}

