/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie;

import be.feelio.mollie.OAuthAwareObjectMapper;
import be.feelio.mollie.handler.CaptureHandler;
import be.feelio.mollie.handler.ChargebackHandler;
import be.feelio.mollie.handler.ConnectHandler;
import be.feelio.mollie.handler.CustomerHandler;
import be.feelio.mollie.handler.InvoiceHandler;
import be.feelio.mollie.handler.MandateHandler;
import be.feelio.mollie.handler.MethodHandler;
import be.feelio.mollie.handler.MiscellaneousHandler;
import be.feelio.mollie.handler.OnboardingHandler;
import be.feelio.mollie.handler.OrderHandler;
import be.feelio.mollie.handler.OrganizationHandler;
import be.feelio.mollie.handler.PaymentHandler;
import be.feelio.mollie.handler.PermissionHandler;
import be.feelio.mollie.handler.ProfileHandler;
import be.feelio.mollie.handler.RefundHandler;
import be.feelio.mollie.handler.SettlementHandler;
import be.feelio.mollie.handler.ShipmentHandler;
import be.feelio.mollie.handler.SubscriptionHandler;
import be.feelio.mollie.util.Config;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;

public class Client {
    private final String endpoint;

    public Client(String apiKey) {
        this.endpoint = "https://api.mollie.com/v2";
        Config.getInstance().setApiKey(apiKey);
        Config.getInstance().setAccessToken(null);
        Config.getInstance().setTestMode(false);
        this.initUniRest();
    }

    public void setAccessToken(String accessToken) {
        Config.getInstance().setAccessToken(accessToken);
    }

    public void revokeAccessToken() {
        Config.getInstance().setAccessToken(null);
    }

    public void enableTestMode() {
        Config.getInstance().setTestMode(true);
    }

    public void disableTestMode() {
        Config.getInstance().setTestMode(false);
    }

    public ConnectHandler connect() {
        return new ConnectHandler();
    }

    public PaymentHandler payments() {
        return new PaymentHandler(this.endpoint);
    }

    public MethodHandler methods() {
        return new MethodHandler(this.endpoint);
    }

    public RefundHandler refunds() {
        return new RefundHandler(this.endpoint);
    }

    public ChargebackHandler chargebacks() {
        return new ChargebackHandler(this.endpoint);
    }

    public CaptureHandler captures() {
        return new CaptureHandler(this.endpoint);
    }

    public OrderHandler orders() {
        return new OrderHandler(this.endpoint);
    }

    public ShipmentHandler shipments() {
        return new ShipmentHandler(this.endpoint);
    }

    public CustomerHandler customers() {
        return new CustomerHandler(this.endpoint);
    }

    public MandateHandler mandates() {
        return new MandateHandler(this.endpoint);
    }

    public SubscriptionHandler subscriptions() {
        return new SubscriptionHandler(this.endpoint);
    }

    public PermissionHandler permissions() {
        return new PermissionHandler(this.endpoint);
    }

    public OrganizationHandler organizations() {
        return new OrganizationHandler(this.endpoint);
    }

    public ProfileHandler profiles() {
        return new ProfileHandler(this.endpoint);
    }

    public OnboardingHandler onboarding() {
        return new OnboardingHandler(this.endpoint);
    }

    public SettlementHandler settlements() {
        return new SettlementHandler(this.endpoint);
    }

    public InvoiceHandler invoices() {
        return new InvoiceHandler(this.endpoint);
    }

    public MiscellaneousHandler miscellaneous() {
        return new MiscellaneousHandler(this.endpoint);
    }

    private void initUniRest() {
        Unirest.config().setObjectMapper((ObjectMapper)new OAuthAwareObjectMapper());
    }

    public String getEndpoint() {
        return this.endpoint;
    }
}

