/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie;

import be.feelio.mollie.Client;

public final class ClientBuilder {
    private String apiKey;
    private String organizationToken;
    private boolean testMode = false;

    public ClientBuilder withApiKey(String key) {
        this.apiKey = key;
        return this;
    }

    public ClientBuilder withOrganizationToken(String token) {
        this.organizationToken = token;
        return this;
    }

    public ClientBuilder withTestMode(boolean shouldBeTestMode) {
        this.testMode = shouldBeTestMode;
        return this;
    }

    public Client build() {
        if (this.apiKey == null) {
            throw new IllegalArgumentException("API key not set. Please use withApiKey(key)");
        }
        Client client = new Client(this.apiKey);
        if (this.organizationToken != null) {
            client.setAccessToken(this.organizationToken);
        }
        if (this.testMode) {
            client.enableTestMode();
        }
        return client;
    }
}

