/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.data.order;

import be.feelio.mollie.data.common.Amount;
import be.feelio.mollie.data.common.Locale;
import be.feelio.mollie.data.order.OrderAddressRequest;
import be.feelio.mollie.data.order.OrderLineRequest;
import be.feelio.mollie.data.payment.PaymentMethod;
import be.feelio.mollie.serializer.PaymentMethodSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OrderRequest {
    private Amount amount;
    private String orderNumber;
    private List<OrderLineRequest> lines;
    private OrderAddressRequest billingAddress;
    private Optional<OrderAddressRequest> shippingAddress;
    private Optional<Date> consumerDateOfBirth;
    private Optional<String> redirectUrl;
    private Optional<String> webhookUrl;
    private Locale locale;
    @JsonSerialize(using=PaymentMethodSerializer.class)
    private Optional<List<PaymentMethod>> method;
    private Map<String, Object> payment;
    private Map<String, Object> metaData;
    private Optional<Date> expiresAt;
    private Optional<String> profileId;
    private Optional<Boolean> testmode;

    private static Optional<OrderAddressRequest> $default$shippingAddress() {
        return Optional.empty();
    }

    private static Optional<Date> $default$consumerDateOfBirth() {
        return Optional.empty();
    }

    private static Optional<String> $default$redirectUrl() {
        return Optional.empty();
    }

    private static Optional<String> $default$webhookUrl() {
        return Optional.empty();
    }

    private static Optional<List<PaymentMethod>> $default$method() {
        return Optional.empty();
    }

    private static Optional<String> $default$profileId() {
        return Optional.empty();
    }

    private static Optional<Boolean> $default$testmode() {
        return Optional.empty();
    }

    public static OrderRequestBuilder builder() {
        return new OrderRequestBuilder();
    }

    public Amount getAmount() {
        return this.amount;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public List<OrderLineRequest> getLines() {
        return this.lines;
    }

    public OrderAddressRequest getBillingAddress() {
        return this.billingAddress;
    }

    public Optional<OrderAddressRequest> getShippingAddress() {
        return this.shippingAddress;
    }

    public Optional<Date> getConsumerDateOfBirth() {
        return this.consumerDateOfBirth;
    }

    public Optional<String> getRedirectUrl() {
        return this.redirectUrl;
    }

    public Optional<String> getWebhookUrl() {
        return this.webhookUrl;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Optional<List<PaymentMethod>> getMethod() {
        return this.method;
    }

    public Map<String, Object> getPayment() {
        return this.payment;
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public Optional<Date> getExpiresAt() {
        return this.expiresAt;
    }

    public Optional<String> getProfileId() {
        return this.profileId;
    }

    public Optional<Boolean> getTestmode() {
        return this.testmode;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setLines(List<OrderLineRequest> lines) {
        this.lines = lines;
    }

    public void setBillingAddress(OrderAddressRequest billingAddress) {
        this.billingAddress = billingAddress;
    }

    public void setShippingAddress(Optional<OrderAddressRequest> shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public void setConsumerDateOfBirth(Optional<Date> consumerDateOfBirth) {
        this.consumerDateOfBirth = consumerDateOfBirth;
    }

    public void setRedirectUrl(Optional<String> redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setWebhookUrl(Optional<String> webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMethod(Optional<List<PaymentMethod>> method) {
        this.method = method;
    }

    public void setPayment(Map<String, Object> payment) {
        this.payment = payment;
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    public void setExpiresAt(Optional<Date> expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setProfileId(Optional<String> profileId) {
        this.profileId = profileId;
    }

    public void setTestmode(Optional<Boolean> testmode) {
        this.testmode = testmode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderRequest)) {
            return false;
        }
        OrderRequest other = (OrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Amount this$amount = this.getAmount();
        Amount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$orderNumber = this.getOrderNumber();
        String other$orderNumber = other.getOrderNumber();
        if (this$orderNumber == null ? other$orderNumber != null : !this$orderNumber.equals(other$orderNumber)) {
            return false;
        }
        List<OrderLineRequest> this$lines = this.getLines();
        List<OrderLineRequest> other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        OrderAddressRequest this$billingAddress = this.getBillingAddress();
        OrderAddressRequest other$billingAddress = other.getBillingAddress();
        if (this$billingAddress == null ? other$billingAddress != null : !((Object)this$billingAddress).equals(other$billingAddress)) {
            return false;
        }
        Optional<OrderAddressRequest> this$shippingAddress = this.getShippingAddress();
        Optional<OrderAddressRequest> other$shippingAddress = other.getShippingAddress();
        if (this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress)) {
            return false;
        }
        Optional<Date> this$consumerDateOfBirth = this.getConsumerDateOfBirth();
        Optional<Date> other$consumerDateOfBirth = other.getConsumerDateOfBirth();
        if (this$consumerDateOfBirth == null ? other$consumerDateOfBirth != null : !((Object)this$consumerDateOfBirth).equals(other$consumerDateOfBirth)) {
            return false;
        }
        Optional<String> this$redirectUrl = this.getRedirectUrl();
        Optional<String> other$redirectUrl = other.getRedirectUrl();
        if (this$redirectUrl == null ? other$redirectUrl != null : !((Object)this$redirectUrl).equals(other$redirectUrl)) {
            return false;
        }
        Optional<String> this$webhookUrl = this.getWebhookUrl();
        Optional<String> other$webhookUrl = other.getWebhookUrl();
        if (this$webhookUrl == null ? other$webhookUrl != null : !((Object)this$webhookUrl).equals(other$webhookUrl)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)((Object)this$locale)).equals((Object)other$locale)) {
            return false;
        }
        Optional<List<PaymentMethod>> this$method = this.getMethod();
        Optional<List<PaymentMethod>> other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        Map<String, Object> this$payment = this.getPayment();
        Map<String, Object> other$payment = other.getPayment();
        if (this$payment == null ? other$payment != null : !((Object)this$payment).equals(other$payment)) {
            return false;
        }
        Map<String, Object> this$metaData = this.getMetaData();
        Map<String, Object> other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        Optional<Date> this$expiresAt = this.getExpiresAt();
        Optional<Date> other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Optional<String> this$profileId = this.getProfileId();
        Optional<String> other$profileId = other.getProfileId();
        if (this$profileId == null ? other$profileId != null : !((Object)this$profileId).equals(other$profileId)) {
            return false;
        }
        Optional<Boolean> this$testmode = this.getTestmode();
        Optional<Boolean> other$testmode = other.getTestmode();
        return !(this$testmode == null ? other$testmode != null : !((Object)this$testmode).equals(other$testmode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Amount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $orderNumber = this.getOrderNumber();
        result = result * 59 + ($orderNumber == null ? 43 : $orderNumber.hashCode());
        List<OrderLineRequest> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        OrderAddressRequest $billingAddress = this.getBillingAddress();
        result = result * 59 + ($billingAddress == null ? 43 : ((Object)$billingAddress).hashCode());
        Optional<OrderAddressRequest> $shippingAddress = this.getShippingAddress();
        result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
        Optional<Date> $consumerDateOfBirth = this.getConsumerDateOfBirth();
        result = result * 59 + ($consumerDateOfBirth == null ? 43 : ((Object)$consumerDateOfBirth).hashCode());
        Optional<String> $redirectUrl = this.getRedirectUrl();
        result = result * 59 + ($redirectUrl == null ? 43 : ((Object)$redirectUrl).hashCode());
        Optional<String> $webhookUrl = this.getWebhookUrl();
        result = result * 59 + ($webhookUrl == null ? 43 : ((Object)$webhookUrl).hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)((Object)$locale)).hashCode());
        Optional<List<PaymentMethod>> $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        Map<String, Object> $payment = this.getPayment();
        result = result * 59 + ($payment == null ? 43 : ((Object)$payment).hashCode());
        Map<String, Object> $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        Optional<Date> $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Optional<String> $profileId = this.getProfileId();
        result = result * 59 + ($profileId == null ? 43 : ((Object)$profileId).hashCode());
        Optional<Boolean> $testmode = this.getTestmode();
        result = result * 59 + ($testmode == null ? 43 : ((Object)$testmode).hashCode());
        return result;
    }

    public String toString() {
        return "OrderRequest(amount=" + this.getAmount() + ", orderNumber=" + this.getOrderNumber() + ", lines=" + this.getLines() + ", billingAddress=" + this.getBillingAddress() + ", shippingAddress=" + this.getShippingAddress() + ", consumerDateOfBirth=" + this.getConsumerDateOfBirth() + ", redirectUrl=" + this.getRedirectUrl() + ", webhookUrl=" + this.getWebhookUrl() + ", locale=" + (Object)((Object)this.getLocale()) + ", method=" + this.getMethod() + ", payment=" + this.getPayment() + ", metaData=" + this.getMetaData() + ", expiresAt=" + this.getExpiresAt() + ", profileId=" + this.getProfileId() + ", testmode=" + this.getTestmode() + ")";
    }

    public OrderRequest(Amount amount, String orderNumber, List<OrderLineRequest> lines, OrderAddressRequest billingAddress, Optional<OrderAddressRequest> shippingAddress, Optional<Date> consumerDateOfBirth, Optional<String> redirectUrl, Optional<String> webhookUrl, Locale locale, Optional<List<PaymentMethod>> method, Map<String, Object> payment, Map<String, Object> metaData, Optional<Date> expiresAt, Optional<String> profileId, Optional<Boolean> testmode) {
        this.amount = amount;
        this.orderNumber = orderNumber;
        this.lines = lines;
        this.billingAddress = billingAddress;
        this.shippingAddress = shippingAddress;
        this.consumerDateOfBirth = consumerDateOfBirth;
        this.redirectUrl = redirectUrl;
        this.webhookUrl = webhookUrl;
        this.locale = locale;
        this.method = method;
        this.payment = payment;
        this.metaData = metaData;
        this.expiresAt = expiresAt;
        this.profileId = profileId;
        this.testmode = testmode;
    }

    public OrderRequest() {
        this.shippingAddress = OrderRequest.$default$shippingAddress();
        this.consumerDateOfBirth = OrderRequest.$default$consumerDateOfBirth();
        this.redirectUrl = OrderRequest.$default$redirectUrl();
        this.webhookUrl = OrderRequest.$default$webhookUrl();
        this.method = OrderRequest.$default$method();
        this.profileId = OrderRequest.$default$profileId();
        this.testmode = OrderRequest.$default$testmode();
    }

    public static class OrderRequestBuilder {
        private Amount amount;
        private String orderNumber;
        private List<OrderLineRequest> lines;
        private OrderAddressRequest billingAddress;
        private boolean shippingAddress$set;
        private Optional<OrderAddressRequest> shippingAddress;
        private boolean consumerDateOfBirth$set;
        private Optional<Date> consumerDateOfBirth;
        private boolean redirectUrl$set;
        private Optional<String> redirectUrl;
        private boolean webhookUrl$set;
        private Optional<String> webhookUrl;
        private Locale locale;
        private boolean method$set;
        private Optional<List<PaymentMethod>> method;
        private Map<String, Object> payment;
        private Map<String, Object> metaData;
        private Optional<Date> expiresAt;
        private boolean profileId$set;
        private Optional<String> profileId;
        private boolean testmode$set;
        private Optional<Boolean> testmode;

        OrderRequestBuilder() {
        }

        public OrderRequestBuilder amount(Amount amount) {
            this.amount = amount;
            return this;
        }

        public OrderRequestBuilder orderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            return this;
        }

        public OrderRequestBuilder lines(List<OrderLineRequest> lines) {
            this.lines = lines;
            return this;
        }

        public OrderRequestBuilder billingAddress(OrderAddressRequest billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public OrderRequestBuilder shippingAddress(Optional<OrderAddressRequest> shippingAddress) {
            this.shippingAddress = shippingAddress;
            this.shippingAddress$set = true;
            return this;
        }

        public OrderRequestBuilder consumerDateOfBirth(Optional<Date> consumerDateOfBirth) {
            this.consumerDateOfBirth = consumerDateOfBirth;
            this.consumerDateOfBirth$set = true;
            return this;
        }

        public OrderRequestBuilder redirectUrl(Optional<String> redirectUrl) {
            this.redirectUrl = redirectUrl;
            this.redirectUrl$set = true;
            return this;
        }

        public OrderRequestBuilder webhookUrl(Optional<String> webhookUrl) {
            this.webhookUrl = webhookUrl;
            this.webhookUrl$set = true;
            return this;
        }

        public OrderRequestBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public OrderRequestBuilder method(Optional<List<PaymentMethod>> method) {
            this.method = method;
            this.method$set = true;
            return this;
        }

        public OrderRequestBuilder payment(Map<String, Object> payment) {
            this.payment = payment;
            return this;
        }

        public OrderRequestBuilder metaData(Map<String, Object> metaData) {
            this.metaData = metaData;
            return this;
        }

        public OrderRequestBuilder expiresAt(Optional<Date> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public OrderRequestBuilder profileId(Optional<String> profileId) {
            this.profileId = profileId;
            this.profileId$set = true;
            return this;
        }

        public OrderRequestBuilder testmode(Optional<Boolean> testmode) {
            this.testmode = testmode;
            this.testmode$set = true;
            return this;
        }

        public OrderRequest build() {
            Optional shippingAddress = this.shippingAddress;
            if (!this.shippingAddress$set) {
                shippingAddress = OrderRequest.$default$shippingAddress();
            }
            Optional consumerDateOfBirth = this.consumerDateOfBirth;
            if (!this.consumerDateOfBirth$set) {
                consumerDateOfBirth = OrderRequest.$default$consumerDateOfBirth();
            }
            Optional redirectUrl = this.redirectUrl;
            if (!this.redirectUrl$set) {
                redirectUrl = OrderRequest.$default$redirectUrl();
            }
            Optional webhookUrl = this.webhookUrl;
            if (!this.webhookUrl$set) {
                webhookUrl = OrderRequest.$default$webhookUrl();
            }
            Optional method = this.method;
            if (!this.method$set) {
                method = OrderRequest.$default$method();
            }
            Optional profileId = this.profileId;
            if (!this.profileId$set) {
                profileId = OrderRequest.$default$profileId();
            }
            Optional testmode = this.testmode;
            if (!this.testmode$set) {
                testmode = OrderRequest.$default$testmode();
            }
            return new OrderRequest(this.amount, this.orderNumber, this.lines, this.billingAddress, shippingAddress, consumerDateOfBirth, redirectUrl, webhookUrl, this.locale, method, this.payment, this.metaData, this.expiresAt, profileId, testmode);
        }

        public String toString() {
            return "OrderRequest.OrderRequestBuilder(amount=" + this.amount + ", orderNumber=" + this.orderNumber + ", lines=" + this.lines + ", billingAddress=" + this.billingAddress + ", shippingAddress=" + this.shippingAddress + ", consumerDateOfBirth=" + this.consumerDateOfBirth + ", redirectUrl=" + this.redirectUrl + ", webhookUrl=" + this.webhookUrl + ", locale=" + (Object)((Object)this.locale) + ", method=" + this.method + ", payment=" + this.payment + ", metaData=" + this.metaData + ", expiresAt=" + this.expiresAt + ", profileId=" + this.profileId + ", testmode=" + this.testmode + ")";
        }
    }
}

