/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.util.Config;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.slf4j.Logger;

public abstract class AbstractHandler {
    private final Logger log;
    private final String baseUrl;
    private final ObjectMapper mapper;

    AbstractHandler(String baseUrl, Logger log) {
        this.baseUrl = baseUrl;
        this.log = log;
        this.mapper = ObjectMapperService.getInstance().getMapper();
    }

    protected HttpResponse<String> get(String uri) throws IOException, MollieException {
        return this.get(uri, QueryParams.EMPTY);
    }

    protected HttpResponse<String> get(String uri, QueryParams params) throws IOException, MollieException {
        if (Config.getInstance().shouldAddTestMode() && !params.containsKey("testmode")) {
            params.put("testmode", "true");
        }
        String url = this.baseUrl + uri + params.toString();
        this.log.info("Executing 'GET {}'", (Object)url);
        HttpResponse response = ((GetRequest)((GetRequest)Unirest.get((String)url).header("Content-Type", "application/json")).header("Authorization", "Bearer " + Config.getInstance().getBearerToken())).asString();
        this.validateResponse((HttpResponse<String>)response);
        this.log.info("Successful response 'GET {}'", (Object)url);
        return response;
    }

    protected HttpResponse<String> postWithoutBody(String uri, QueryParams params) throws IOException, MollieException {
        String url = this.baseUrl + uri + params.toString();
        this.log.info("Executing 'POST {}'", (Object)url);
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)url).header("Content-Type", "application/json")).header("Authorization", "Bearer " + Config.getInstance().getBearerToken())).asString();
        this.validateResponse((HttpResponse<String>)response);
        this.log.info("Successful response 'POST {}'", (Object)url);
        return response;
    }

    protected HttpResponse<String> post(String uri, Object body) throws IOException, MollieException {
        return this.post(uri, body, QueryParams.EMPTY);
    }

    protected HttpResponse<String> post(String uri, Object body, QueryParams params) throws IOException, MollieException {
        String url = this.baseUrl + uri + params.toString();
        this.log.info("Executing 'POST {}'", (Object)url);
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)url).header("Content-Type", "application/json")).header("Authorization", "Bearer " + Config.getInstance().getBearerToken())).body(body).asString();
        this.validateResponse((HttpResponse<String>)response);
        this.log.info("Successful response 'POST {}'", (Object)url);
        return response;
    }

    protected HttpResponse<String> patch(String uri, Object body) throws IOException, MollieException {
        return this.patch(uri, body, QueryParams.EMPTY);
    }

    protected HttpResponse<String> patch(String uri, Object body, QueryParams params) throws IOException, MollieException {
        String url = this.baseUrl + uri + params.toString();
        this.log.info("Executing 'PATCH {}'", (Object)url);
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.patch((String)url).header("Content-Type", "application/json")).header("Authorization", "Bearer " + Config.getInstance().getBearerToken())).body(body).asString();
        this.validateResponse((HttpResponse<String>)response);
        this.log.info("Successful response 'PATCH {}'", (Object)url);
        return response;
    }

    protected HttpResponse<String> delete(String uri) throws IOException, MollieException {
        return this.delete(uri, QueryParams.EMPTY);
    }

    protected HttpResponse<String> delete(String uri, QueryParams params) throws IOException, MollieException {
        HashMap<String, String> body = new HashMap<String, String>();
        if (Config.getInstance().shouldAddTestMode()) {
            body.put("testmode", "true");
        }
        String url = this.baseUrl + uri + params.toString();
        this.log.info("Executing 'DELETE {}'", (Object)url);
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.delete((String)url).header("Content-Type", "application/json")).header("Authorization", "Bearer " + Config.getInstance().getBearerToken())).body(body).asString();
        this.validateResponse((HttpResponse<String>)response);
        this.log.info("Successful response 'DELETE {}'", (Object)url);
        return response;
    }

    protected HttpResponse<String> delete(String uri, Object body, QueryParams params) throws IOException, MollieException {
        String url = this.baseUrl + uri + params.toString();
        this.log.info("Executing 'DELETE {}'", (Object)url);
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.delete((String)url).header("Content-Type", "application/json")).header("Authorization", "Bearer " + Config.getInstance().getBearerToken())).body(body).asString();
        this.validateResponse((HttpResponse<String>)response);
        this.log.info("Successful response 'DELETE {}'", (Object)url);
        return response;
    }

    protected void validateResponse(HttpResponse<String> response) throws IOException, MollieException {
        if (response.getStatus() < 200 || response.getStatus() > 300) {
            this.log.error("Error response from mollie with status code '{}' and body: {}", (Object)response.getStatus(), response.getBody());
            throw new MollieException("Error response from mollie", (Map)this.mapper.readValue((String)response.getBody(), (TypeReference)new TypeReference<Map>(){}));
        }
    }
}

