/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.data.capture.CaptureListResponse;
import be.feelio.mollie.data.capture.CaptureResponse;
import be.feelio.mollie.data.chargeback.ChargebackListResponse;
import be.feelio.mollie.data.chargeback.ChargebackResponse;
import be.feelio.mollie.data.common.Pagination;
import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(CaptureHandler.class);

    public CaptureHandler(String baseUrl) {
        super(baseUrl, log);
    }

    public CaptureResponse getCapture(String paymentId, String captureId) throws MollieException {
        return this.getCapture(paymentId, captureId, QueryParams.EMPTY);
    }

    public CaptureResponse getCapture(String paymentId, String captureId, QueryParams params) throws MollieException {
        try {
            String uri = "/payments/" + paymentId + "/captures/" + captureId;
            HttpResponse<String> response = this.get(uri, params);
            return (CaptureResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<ChargebackResponse>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<CaptureListResponse> listCaptures(String paymentId) throws MollieException {
        return this.listCaptures(paymentId, QueryParams.EMPTY);
    }

    public Pagination<CaptureListResponse> listCaptures(String paymentId, QueryParams params) throws MollieException {
        try {
            String uri = "/payments/" + paymentId + "/captures";
            HttpResponse<String> response = this.get(uri, params);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<ChargebackListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

