/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.data.connect.AuthorizeRequest;
import be.feelio.mollie.data.connect.RevokeTokenRequest;
import be.feelio.mollie.data.connect.TokenRequest;
import be.feelio.mollie.data.connect.TokenResponse;
import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import be.feelio.mollie.util.UrlUtils;
import java.io.IOException;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ConnectHandler.class);

    public ConnectHandler() {
        super(null, log);
    }

    public String createAuthorizeUrl(AuthorizeRequest request) {
        return "https://www.mollie.com/oauth2/authorize" + this.convertAuthorizeRequestToQueryParams(request).toString();
    }

    public TokenResponse generateTokens(String clientId, String clientSecret, TokenRequest body) throws MollieException {
        return this.generateTokens(clientId, clientSecret, body, QueryParams.EMPTY);
    }

    public TokenResponse generateTokens(String clientId, String clientSecret, TokenRequest body, QueryParams params) throws MollieException {
        try {
            String url = "https://api.mollie.com/oauth2/tokens" + params.toString();
            log.info("Executing 'POST {}'", (Object)url);
            HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)url).header("Content-Type", "application/x-www-form-urlencoded")).basicAuth(clientId, clientSecret)).body(this.getGenerateTokensBody(body)).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'POST {}'", (Object)url);
            return (TokenResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), TokenResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void revokeToken(String clientId, String clientSecret, RevokeTokenRequest body) throws MollieException {
        this.revokeToken(clientId, clientSecret, body, QueryParams.EMPTY);
    }

    public void revokeToken(String clientId, String clientSecret, RevokeTokenRequest body, QueryParams params) throws MollieException {
        try {
            String url = "https://api.mollie.com/oauth2/tokens" + params.toString();
            log.info("Executing 'DELETE {}'", (Object)url);
            HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)url).header("Content-Type", "application/x-www-form-urlencoded")).basicAuth(clientId, clientSecret)).body(this.getRevokeTokenBody(body)).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'DELETE {}'", (Object)url);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    private QueryParams convertAuthorizeRequestToQueryParams(AuthorizeRequest request) {
        QueryParams params = new QueryParams();
        params.put("client_id", request.getClientId());
        request.getRedirectUri().ifPresent(uri -> params.put("redirect_uri", uri));
        params.put("state", request.getState());
        params.put("scope", String.join((CharSequence)" ", request.getScope()));
        params.put("response_type", request.getResponseType().getValue());
        params.put("approval_prompt", request.getApprovalPrompt().getValue());
        return params;
    }

    private String getGenerateTokensBody(TokenRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append("grant_type=").append(UrlUtils.urlEncode(request.getGrantType().name().toLowerCase()));
        request.getCode().ifPresent(code -> sb.append("&code=").append(UrlUtils.urlEncode(code)));
        request.getRefreshToken().ifPresent(token -> sb.append("&refresh_token=").append(UrlUtils.urlEncode(token)));
        sb.append("&redirect_uri=").append(UrlUtils.urlEncode(request.getRedirectUri()));
        return sb.toString();
    }

    private String getRevokeTokenBody(RevokeTokenRequest request) {
        return "token_type_hint=" + UrlUtils.urlEncode(request.getTokenTypeHint().name().toLowerCase()) + "&token=" + UrlUtils.urlEncode(request.getToken());
    }
}

