/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.data.common.Pagination;
import be.feelio.mollie.data.method.MethodListResponse;
import be.feelio.mollie.data.method.MethodResponse;
import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandler.class);

    public MethodHandler(String baseUrl) {
        super(baseUrl, log);
    }

    public Pagination<MethodListResponse> listMethods() throws MollieException {
        return this.listMethods(QueryParams.EMPTY);
    }

    public Pagination<MethodListResponse> listMethods(QueryParams params) throws MollieException {
        try {
            String uri = "/methods";
            HttpResponse<String> response = this.get(uri, params);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<MethodListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public MethodResponse getMethod(String methodId) throws MollieException {
        return this.getMethod(methodId, QueryParams.EMPTY);
    }

    public MethodResponse getMethod(String methodId, QueryParams params) throws MollieException {
        try {
            String uri = "/methods/" + methodId;
            HttpResponse<String> response = this.get(uri, params);
            return (MethodResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<MethodResponse>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

