/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.data.onboarding.OnboardingRequest;
import be.feelio.mollie.data.onboarding.OnboardingResponse;
import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnboardingHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(OnboardingHandler.class);

    public OnboardingHandler(String baseUrl) {
        super(baseUrl, log);
    }

    public OnboardingResponse getOnboardingStatus() throws MollieException {
        return this.getOnboardingStatus(QueryParams.EMPTY);
    }

    public OnboardingResponse getOnboardingStatus(QueryParams params) throws MollieException {
        try {
            String uri = "/onboarding/me";
            HttpResponse<String> response = this.get(uri, params);
            return (OnboardingResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OnboardingResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void submitOnboardingData(OnboardingRequest body) throws MollieException {
        this.submitOnboardingData(body, QueryParams.EMPTY);
    }

    public void submitOnboardingData(OnboardingRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/onboarding/me";
            this.post(uri, body, params);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

