/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.data.common.Pagination;
import be.feelio.mollie.data.order.CancelOrderLinesRequest;
import be.feelio.mollie.data.order.OrderLineUpdateRequest;
import be.feelio.mollie.data.order.OrderListResponse;
import be.feelio.mollie.data.order.OrderPaymentRequest;
import be.feelio.mollie.data.order.OrderRefundListResponse;
import be.feelio.mollie.data.order.OrderRefundRequest;
import be.feelio.mollie.data.order.OrderRequest;
import be.feelio.mollie.data.order.OrderResponse;
import be.feelio.mollie.data.order.OrderUpdateRequest;
import be.feelio.mollie.data.payment.PaymentResponse;
import be.feelio.mollie.data.refund.RefundResponse;
import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(OrderHandler.class);

    public OrderHandler(String baseUrl) {
        super(baseUrl, log);
    }

    public OrderResponse createOrder(OrderRequest body) throws MollieException {
        return this.createOrder(body, QueryParams.EMPTY);
    }

    public OrderResponse createOrder(OrderRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders";
            HttpResponse<String> response = this.post(uri, body, params);
            return (OrderResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrderResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public OrderResponse getOrder(String orderId) throws MollieException {
        return this.getOrder(orderId, QueryParams.EMPTY);
    }

    public OrderResponse getOrder(String orderId, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId;
            HttpResponse<String> response = this.get(uri, params);
            return (OrderResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrderResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<OrderListResponse> getOrders() throws MollieException {
        return this.getOrders(QueryParams.EMPTY);
    }

    public Pagination<OrderListResponse> getOrders(QueryParams params) throws MollieException {
        try {
            String uri = "/orders";
            HttpResponse<String> response = this.get(uri, params);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<OrderListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public OrderResponse updateOrder(String orderId, OrderUpdateRequest body) throws MollieException {
        return this.updateOrder(orderId, body, QueryParams.EMPTY);
    }

    public OrderResponse updateOrder(String orderId, OrderUpdateRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId;
            HttpResponse<String> response = this.patch(uri, body, params);
            return (OrderResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrderResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public OrderResponse updateOrderLine(String orderId, String lineId, OrderLineUpdateRequest body) throws MollieException {
        return this.updateOrderLine(orderId, lineId, body, QueryParams.EMPTY);
    }

    public OrderResponse updateOrderLine(String orderId, String lineId, OrderLineUpdateRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/lines/" + lineId;
            HttpResponse<String> response = this.patch(uri, body, params);
            return (OrderResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrderResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public OrderResponse cancelOrder(String orderId) throws MollieException {
        return this.cancelOrder(orderId, QueryParams.EMPTY);
    }

    public OrderResponse cancelOrder(String orderId, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId;
            HttpResponse<String> response = this.delete(uri, params);
            return (OrderResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrderResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void cancelOrderLines(String orderId, CancelOrderLinesRequest body) throws MollieException {
        this.cancelOrderLines(orderId, body, QueryParams.EMPTY);
    }

    public void cancelOrderLines(String orderId, CancelOrderLinesRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/lines";
            this.delete(uri, body, params);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public PaymentResponse createOrderPayment(String orderId, OrderPaymentRequest body) throws MollieException {
        return this.createOrderPayment(orderId, body, QueryParams.EMPTY);
    }

    public PaymentResponse createOrderPayment(String orderId, OrderPaymentRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/payments";
            HttpResponse<String> response = this.post(uri, body, params);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public RefundResponse createOrderRefund(String orderId, OrderRefundRequest body) throws MollieException {
        return this.createOrderRefund(orderId, body, QueryParams.EMPTY);
    }

    public RefundResponse createOrderRefund(String orderId, OrderRefundRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/refunds";
            HttpResponse<String> response = this.post(uri, body, params);
            return (RefundResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), RefundResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<OrderRefundListResponse> getOrderRefunds(String orderId) throws MollieException {
        return this.getOrderRefunds(orderId, QueryParams.EMPTY);
    }

    public Pagination<OrderRefundListResponse> getOrderRefunds(String orderId, QueryParams params) throws MollieException {
        try {
            String uri = "/orders/" + orderId + "/refunds";
            HttpResponse<String> response = this.get(uri, params);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<OrderRefundListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

