/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.data.organization.OrganizationResponse;
import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(OrganizationHandler.class);

    public OrganizationHandler(String baseUrl) {
        super(baseUrl, log);
    }

    public OrganizationResponse getMyOrganization() throws MollieException {
        return this.getMyOrganization(QueryParams.EMPTY);
    }

    public OrganizationResponse getMyOrganization(QueryParams params) throws MollieException {
        try {
            String uri = "/organizations/me";
            HttpResponse<String> response = this.get(uri, params);
            return (OrganizationResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrganizationResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public OrganizationResponse getOrganization(String organizationId) throws MollieException {
        return this.getOrganization(organizationId, QueryParams.EMPTY);
    }

    public OrganizationResponse getOrganization(String organizationId, QueryParams params) throws MollieException {
        try {
            String uri = "/organizations/" + organizationId;
            HttpResponse<String> response = this.get(uri, params);
            return (OrganizationResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrganizationResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

