/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.data.common.Pagination;
import be.feelio.mollie.data.method.MethodResponse;
import be.feelio.mollie.data.payment.PaymentMethod;
import be.feelio.mollie.data.profile.ProfileListResponse;
import be.feelio.mollie.data.profile.ProfileRequest;
import be.feelio.mollie.data.profile.ProfileResponse;
import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ProfileHandler.class);

    public ProfileHandler(String baseUrl) {
        super(baseUrl, log);
    }

    public ProfileResponse createProfile(ProfileRequest body) throws MollieException {
        return this.createProfile(body, QueryParams.EMPTY);
    }

    public ProfileResponse createProfile(ProfileRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/profiles";
            HttpResponse<String> response = this.post(uri, body, params);
            return (ProfileResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), ProfileResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public ProfileResponse getProfile(String id) throws MollieException {
        return this.getProfile(id, QueryParams.EMPTY);
    }

    public ProfileResponse getProfile(String id, QueryParams params) throws MollieException {
        try {
            String uri = "/profiles/" + id;
            HttpResponse<String> response = this.get(uri, params);
            return (ProfileResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), ProfileResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public ProfileResponse getMyProfile() throws MollieException {
        return this.getMyProfile(QueryParams.EMPTY);
    }

    public ProfileResponse getMyProfile(QueryParams params) throws MollieException {
        try {
            String uri = "/profiles/me";
            HttpResponse<String> response = this.get(uri, params);
            return (ProfileResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), ProfileResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public ProfileResponse updateProfile(String id, ProfileRequest body) throws MollieException {
        return this.updateProfile(id, body, QueryParams.EMPTY);
    }

    public ProfileResponse updateProfile(String id, ProfileRequest body, QueryParams params) throws MollieException {
        try {
            String uri = "/profiles/" + id;
            HttpResponse<String> response = this.patch(uri, body, params);
            return (ProfileResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), ProfileResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void deleteProfile(String id) throws MollieException {
        this.deleteProfile(id, QueryParams.EMPTY);
    }

    public void deleteProfile(String id, QueryParams params) throws MollieException {
        try {
            String uri = "/profiles/" + id;
            this.delete(uri, params);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public MethodResponse enableMyPaymentMethod(PaymentMethod paymentMethod) throws MollieException {
        return this.enablePaymentMethod("me", paymentMethod, QueryParams.EMPTY);
    }

    public MethodResponse enableMyPaymentMethod(PaymentMethod paymentMethod, QueryParams params) throws MollieException {
        return this.enablePaymentMethod("me", paymentMethod, params);
    }

    public MethodResponse enablePaymentMethod(String profileId, PaymentMethod paymentMethod) throws MollieException {
        return this.enablePaymentMethod(profileId, paymentMethod, QueryParams.EMPTY);
    }

    public MethodResponse enablePaymentMethod(String profileId, PaymentMethod paymentMethod, QueryParams params) throws MollieException {
        try {
            String uri = "/profiles/" + profileId + "/methods/" + paymentMethod.getJsonValue();
            HttpResponse<String> response = this.postWithoutBody(uri, params);
            return (MethodResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), MethodResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void disableMyPaymentMethod(PaymentMethod paymentMethod) throws MollieException {
        this.enablePaymentMethod("me", paymentMethod, QueryParams.EMPTY);
    }

    public void disableMyPaymentMethod(PaymentMethod paymentMethod, QueryParams params) throws MollieException {
        this.disablePaymentMethod("me", paymentMethod, params);
    }

    public void disablePaymentMethod(String profileId, PaymentMethod paymentMethod) throws MollieException {
        this.disablePaymentMethod(profileId, paymentMethod, QueryParams.EMPTY);
    }

    public void disablePaymentMethod(String profileId, PaymentMethod paymentMethod, QueryParams params) throws MollieException {
        try {
            String uri = "/profiles/" + profileId + "/methods/" + paymentMethod.getJsonValue();
            this.delete(uri, params);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<ProfileListResponse> getProfiles() throws MollieException {
        return this.getProfiles(QueryParams.EMPTY);
    }

    public Pagination<ProfileListResponse> getProfiles(QueryParams params) throws MollieException {
        try {
            String uri = "/profiles";
            HttpResponse<String> response = this.get(uri, params);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<ProfileListResponse>>(){});
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

