/*
 * Decompiled with CFR 0.152.
 */
package be.hikage.xdt4j.transform;

import be.hikage.xdt4j.locator.Locator;
import be.hikage.xdt4j.locator.LocatorFactory;
import java.util.ArrayList;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Transform {
    private static Logger LOG = LoggerFactory.getLogger(Transform.class);
    protected Element transformElement;
    protected Document workingDocument;
    protected String arguments;

    public Transform(Document workingDocument, Element transformElement, String arguments) {
        this.workingDocument = workingDocument;
        this.transformElement = transformElement;
        this.arguments = arguments;
    }

    public void apply() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Before applying {}: {}", (Object)this.getClass().getName(), (Object)this.workingDocument.asXML());
        }
        this.applyInternal();
        if (LOG.isTraceEnabled()) {
            LOG.trace("After applying {}: {}", (Object)this.getClass().getName(), (Object)this.workingDocument.asXML());
        }
    }

    protected abstract void applyInternal();

    protected Element getTransformElementCopy() {
        Element tempElement = this.transformElement.createCopy();
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
        for (Attribute attribute : tempElement.attributes()) {
            if ("http://schemas.microsoft.com/XML-Document-Transform".equals(attribute.getNamespaceURI())) continue;
            newAttributes.add(attribute);
        }
        tempElement.setAttributes(newAttributes);
        return tempElement;
    }

    protected String getXPath() {
        Locator locator = LocatorFactory.createLocator(this.transformElement);
        String xpath = locator != null ? locator.generateXPath(this.transformElement) : this.transformElement.getPath();
        LOG.debug("XPath outcome of Locator processing : {}", (Object)xpath);
        return xpath;
    }
}

