/*
 * Decompiled with CFR 0.152.
 */
package groovy.osgi.activator;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaMethod;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.runtime.m12n.ExtensionModule;
import org.codehaus.groovy.runtime.m12n.ExtensionModuleRegistry;
import org.codehaus.groovy.runtime.m12n.MetaInfExtensionModule;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.util.FastArray;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private final ConcurrentMap<Long, BundleWrapper> bundleWrappers = new ConcurrentHashMap<Long, BundleWrapper>();
    private final Map<CachedClass, List<MetaMethod>> map = new HashMap<CachedClass, List<MetaMethod>>();

    public synchronized void start(BundleContext bundleContext) throws Exception {
        LOG.debug("activating");
        bundleContext.addBundleListener((BundleListener)this);
        LOG.debug("checking existing bundles");
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() == 4 || bundle.getState() == 8 || bundle.getState() == 32 || bundle.getState() == 16) {
                this.register(bundle);
            }
            ++n2;
        }
        LOG.debug("activated");
    }

    public synchronized void stop(BundleContext bundleContext) throws Exception {
        LOG.debug("deactivating");
        bundleContext.removeBundleListener((BundleListener)this);
        while (!this.bundleWrappers.isEmpty()) {
            this.unregister((Long)this.bundleWrappers.keySet().iterator().next());
        }
        LOG.debug("deactivated");
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            this.register(event.getBundle());
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
    }

    protected void register(Bundle bundle) {
        LOG.debug("checking bundle " + bundle.getBundleId());
        if (this.containsExtensionModule(bundle) && this.hasCorrectMetaClassRegistry()) {
            LOG.debug("Registering bundle for extension module: " + bundle.getBundleId());
            try {
                this.registerExtensionModule(bundle);
            }
            catch (IOException e) {
                LOG.error("Could not register extension module", (Throwable)e);
            }
        }
    }

    private boolean hasCorrectMetaClassRegistry() {
        return GroovySystem.getMetaClassRegistry() instanceof MetaClassRegistryImpl;
    }

    protected void unregister(long bundleId) {
        BundleWrapper bundleWrapper = (BundleWrapper)this.bundleWrappers.remove(bundleId);
        if (bundleWrapper != null) {
            try {
                this.unregisterExtensionModule(bundleWrapper.bundle);
            }
            catch (IOException e) {
                LOG.error("Could not unregister extension module", (Throwable)e);
            }
        }
    }

    private boolean containsExtensionModule(Bundle bundle) {
        return bundle.getEntry("META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule") != null || bundle.getEntry("META-INF/services/org.codehaus.groovy.runtime.ExtensionModule") != null;
    }

    private void registerExtensionModule(Bundle bundle) throws IOException {
        Properties properties = this.loadProperties(Activator.getExtensionModuleUrl(bundle));
        String moduleName = properties.getProperty("moduleName");
        ExtensionModuleRegistry extensionModuleRegistry = ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getModuleRegistry();
        if (!extensionModuleRegistry.hasModule(moduleName)) {
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            MetaInfExtensionModule extensionModule = MetaInfExtensionModule.newModule((Properties)properties, (ClassLoader)wiring.getClassLoader());
            ExtensionModuleRegistry moduleRegistry = ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getModuleRegistry();
            FastArray instanceMethods = ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getInstanceMethods();
            FastArray staticMethods = ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getStaticMethods();
            this.registerExtensionModule((ExtensionModule)extensionModule, moduleRegistry, instanceMethods, staticMethods);
            this.bundleWrappers.put(bundle.getBundleId(), new BundleWrapper(bundle, (ExtensionModule)extensionModule));
        }
    }

    private void registerExtensionModule(ExtensionModule module, ExtensionModuleRegistry moduleRegistry, FastArray instanceMethods, FastArray staticMethods) {
        if (moduleRegistry.hasModule(module.getName())) {
            ExtensionModule loadedModule = moduleRegistry.getModule(module.getName());
            if (loadedModule.getVersion().equals(module.getVersion())) {
                return;
            }
            throw new GroovyRuntimeException("Conflicting module versions. Module [" + module.getName() + " is loaded in version " + loadedModule.getVersion() + " and you are trying to load version " + module.getVersion());
        }
        moduleRegistry.addModule(module);
        List metaMethods = module.getMetaMethods();
        for (MetaMethod metaMethod : metaMethods) {
            CachedClass cachedClass = metaMethod.getDeclaringClass();
            List methods = this.map.computeIfAbsent(cachedClass, k -> new ArrayList(4));
            methods.add(metaMethod);
            if (metaMethod.isStatic()) {
                staticMethods.add((Object)metaMethod);
                continue;
            }
            instanceMethods.add((Object)metaMethod);
        }
        for (Map.Entry entry : this.map.entrySet()) {
            CachedClass cls = (CachedClass)entry.getKey();
            cls.setNewMopMethods((List)entry.getValue());
        }
    }

    private void unregisterExtensionModule(Bundle bundle) throws IOException {
        Properties properties = this.loadProperties(Activator.getExtensionModuleUrl(bundle));
        String moduleName = properties.getProperty("moduleName");
        ExtensionModuleRegistry extensionModuleRegistry = ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getModuleRegistry();
        if (extensionModuleRegistry.hasModule(moduleName) && this.bundleWrappers.get(bundle.getBundleId()) != null) {
            extensionModuleRegistry.removeModule(((BundleWrapper)this.bundleWrappers.get(bundle.getBundleId())).extensionModule);
        }
    }

    private static URL getExtensionModuleUrl(Bundle bundle) {
        URL url = bundle.getEntry("META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule");
        if (url == null) {
            return bundle.getEntry("META-INF/services/org.codehaus.groovy.runtime.ExtensionModule");
        }
        return url;
    }

    private Properties loadProperties(URL resource) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = resource.openStream();){
            Properties properties = new Properties();
            properties.load(in);
            return properties;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class BundleWrapper {
        private final Bundle bundle;
        private final ExtensionModule extensionModule;

        public BundleWrapper(Bundle bundle, ExtensionModule extensionModule) {
            this.bundle = bundle;
            this.extensionModule = extensionModule;
        }
    }
}

