/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.authentication;

import be.personify.iam.scim.util.PropertyFactory;
import be.personify.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AuthenticationUtils
implements ApplicationContextAware {
    private static final Logger logger = LogManager.getLogger(AuthenticationUtils.class);
    private ApplicationContext applicationContext;
    @Value(value="${scim.authentication.implementation}")
    private String filterImplementation;
    @Autowired
    private PropertyFactory propertyFactory;
    private Map<String, List<String>> basicAuthUsers;
    private Map<String, List<String>> bearerAuthUsers;

    private Map<String, List<String>> getUserList(String authenticationType) {
        logger.info("initializing users of type {}", (Object)authenticationType);
        try {
            HashMap<String, List<String>> users = new HashMap<String, List<String>>();
            int count = 1;
            String user = null;
            List<Object> roles = null;
            while ((user = this.propertyFactory.getProperty("scim.authentication.propertyfile.method." + authenticationType + ".user." + count)) != null) {
                String rolesString = this.propertyFactory.getProperty("scim.authentication.propertyfile.method." + authenticationType + ".user." + count + ".roles");
                logger.info("adding user {} with roles {}", (Object)user.split(":")[0], (Object)rolesString);
                roles = new ArrayList();
                if (!StringUtils.isEmpty((String)rolesString)) {
                    roles = Arrays.asList(rolesString.split(","));
                }
                users.put(user, roles);
                ++count;
            }
            logger.info("initializing auth users of type {} done : found {} users", (Object)authenticationType, (Object)users.size());
            return users;
        }
        catch (Exception e) {
            logger.error("initializing auth users of type {} ", (Object)authenticationType, (Object)e);
            return null;
        }
    }

    public Filter getFilterImplementation() throws Exception {
        logger.info("trying to initialize authentication filter implementation of type {}", (Object)this.filterImplementation);
        Class<?> c = Class.forName(this.filterImplementation);
        Filter filter = (Filter)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        AutowireCapableBeanFactory factory = this.applicationContext.getAutowireCapableBeanFactory();
        factory.autowireBean((Object)filter);
        factory.initializeBean((Object)filter, "authenticationFilter");
        logger.info("successfully initialized {}", (Object)this.filterImplementation);
        return filter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Map<String, List<String>> getBasicAuthUsers() {
        if (this.basicAuthUsers == null) {
            this.basicAuthUsers = this.getUserList("Basic".toLowerCase());
        }
        return this.basicAuthUsers;
    }

    public Map<String, List<String>> getBearerAuthUsers() {
        if (this.bearerAuthUsers == null) {
            this.bearerAuthUsers = this.getUserList("Bearer".toLowerCase());
        }
        return this.bearerAuthUsers;
    }
}

